/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.ip.tencent;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.searcher.ip.tencent.JTencentIPPanel;
import com.nepxion.swing.searcher.ip.tencent.JTencentIPTable;
import com.nepxion.swing.searcher.ip.tencent.TencentIPTableModel;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.searcher.ip.tencent.TencentIPEntity;
import com.nepxion.util.searcher.ip.tencent.TencentIPSearcher;
import java.awt.event.ActionEvent;

public class TencentIPController {
    public static JSecurityAction getSearchAction(final JTencentIPPanel panel) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("query"), IconFactory.getSwingIcon("stereo_search.png"), SwingLocale.getString("ip_to_native_address")){

            @Override
            public void execute(ActionEvent e) {
                JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(panel), SwingLocale.getString("ip_to_native_address"), SwingLocale.getString("query_and_wait")){

                    @Override
                    protected void loadForeground(Object data) throws Exception {
                        TencentIPEntity entity = (TencentIPEntity)data;
                        if (entity == null) {
                            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(panel), SwingLocale.getString("no_records"), SwingLocale.getString("warning"), 2);
                            return;
                        }
                        TencentIPTableModel tableModel = (TencentIPTableModel)panel.getIPTable().getModel();
                        tableModel.addRow(entity);
                    }

                    @Override
                    protected Object loadBackground() throws Exception {
                        TencentIPSearcher searcher = new TencentIPSearcher();
                        TencentIPEntity entity = searcher.search();
                        return entity;
                    }
                };
                dialog.execute();
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JTencentIPTable table) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear_query_result")){

            @Override
            public void execute(ActionEvent e) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear_query_result"), SwingLocale.getString("confirm"), 0);
                if (selectedValue != 0) {
                    return;
                }
                TencentIPTableModel tableModel = (TencentIPTableModel)table.getModel();
                tableModel.clearRows();
            }
        };
        return action;
    }
}

