/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import twaver.table.PageListener;
import twaver.table.TablePaging;

public abstract class AbstractPageTableModel
extends AbstractTableModel
implements TablePaging {
    protected int pageTotalCount = 0;
    protected int pageRowSize = Integer.MAX_VALUE;
    protected int currentPageIndex = 1;
    private List A = new ArrayList();

    public void addPageListener(PageListener pageListener) {
        this.A.add(pageListener);
    }

    public void removePageListener(PageListener pageListener) {
        this.A.remove(pageListener);
    }

    public void firePageChanged() {
        for (int i2 = 0; i2 < this.A.size(); ++i2) {
            PageListener pageListener = (PageListener)this.A.get(i2);
            pageListener.pageChanged();
        }
    }

    public void update() {
        int rowSize = this.getTotalRowCount();
        this.pageTotalCount = rowSize / this.pageRowSize;
        if (rowSize % this.pageRowSize > 0) {
            ++this.pageTotalCount;
        }
        if (this.pageTotalCount < 1) {
            this.pageTotalCount = 1;
        }
        if (this.currentPageIndex < 1) {
            this.currentPageIndex = 1;
        }
        if (this.currentPageIndex > this.pageTotalCount) {
            this.currentPageIndex = this.pageTotalCount;
        }
        this.firePageChanged();
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getPageRowSize() {
        return this.pageRowSize;
    }

    public int getPageTotalCount() {
        return this.pageTotalCount;
    }

    public void setCurrentPageIndex(int currentpage) {
        if (this.currentPageIndex == currentpage) {
            return;
        }
        this.currentPageIndex = currentpage;
        this.update();
    }

    public void setPageRowSize(int pageRowSize) {
        if (this.pageRowSize == pageRowSize) {
            return;
        }
        this.pageRowSize = pageRowSize;
        if (this.pageRowSize <= 0) {
            this.pageRowSize = Integer.MAX_VALUE;
        }
        this.update();
    }

    public void firstPage() {
        if (this.currentPageIndex == 1) {
            return;
        }
        this.currentPageIndex = 1;
        this.update();
    }

    public void previousPage() {
        if (this.currentPageIndex <= 1) {
            return;
        }
        --this.currentPageIndex;
        this.update();
    }

    public void nextPage() {
        if (this.currentPageIndex >= this.pageTotalCount) {
            return;
        }
        ++this.currentPageIndex;
        this.update();
    }

    public void lastPage() {
        if (this.currentPageIndex == this.pageTotalCount) {
            return;
        }
        this.currentPageIndex = this.pageTotalCount;
        this.update();
    }

    public int getFirstRowIndex() {
        return Math.min((this.currentPageIndex - 1) * this.getPageRowSize(), this.getTotalRowCount() - 1);
    }

    public int getLastRowIndex() {
        return Math.min(this.getFirstRowIndex() + this.getPageRowSize() - 1, this.getTotalRowCount() - 1);
    }
}

