/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import twaver.TWaverUtil;
import twaver.base.A.E.m;
import twaver.network.InteractionEvent;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public class DefaultInputHandler
extends InputAdapter {
    protected TNetwork network = null;

    public DefaultInputHandler(TNetwork network) {
        this.network = network;
    }

    public void init() {
        this.network.getCanvas().requestFocus();
    }

    protected boolean confirmDelete() {
        int result = JOptionPane.showConfirmDialog(this.network, TWaverUtil.getString("DELETECONFIRM"), "", 0);
        return result == 0;
    }

    protected void deleteProcess() {
        if (this.confirmDelete()) {
            final List list = this.network.getDataBox().getSelectionModel().getAllSelectedElement();
            if (!this.network.isAnimateElementDelete()) {
                this.network.getDataBox().removeSelectedElements();
                this.network.adjustCanvasSize();
                InteractionEvent event = new InteractionEvent((Object)list, 14);
                this.network.fireInteractionPerformed(event);
            } else {
                Runnable r = new Runnable(){

                    public void run() {
                        DefaultInputHandler.this.network.adjustCanvasSize();
                        InteractionEvent event = new InteractionEvent((Object)list, 14);
                        DefaultInputHandler.this.network.fireInteractionPerformed(event);
                    }
                };
                TWaverUtil.animateDelete(this.network.getDataBox(), list, r, -1, -1);
            }
        }
    }

    public void keyPressed(KeyEvent e2) {
        if (e2.isControlDown() && e2.getKeyCode() == 65 && this.network.isEnableSelectAllWithKeyboard()) {
            this.network.selectAll();
        } else if (e2.isControlDown() && e2.getKeyCode() == 67 && this.network.isEnableCopyPasteWithKeyboard()) {
            this.network.getDataBox().copySelection();
        } else if (e2.isControlDown() && e2.getKeyCode() == 86 && this.network.isEnableCopyPasteWithKeyboard()) {
            this.network.pasteElements();
        } else if (e2.isControlDown() && e2.getKeyCode() == 90 && this.network.isEnableUndoRedoWithKeyboard()) {
            this.network.getDataBox().getUndoRedoManager().undo();
        } else if (e2.isControlDown() && e2.getKeyCode() == 89 && this.network.isEnableUndoRedoWithKeyboard()) {
            this.network.getDataBox().getUndoRedoManager().redo();
        } else if (e2.getKeyCode() == 127 && this.network.isEnableDeleteWithKeyboard()) {
            if (this.network.getDataBox().getSelectionModel().size() > 0) {
                this.deleteProcess();
            }
        } else if (e2.getKeyCode() == 27 && this.network.isEnableExitFullScreenWithKeyboard()) {
            if (this.network.isFullScreen()) {
                this.network.exitFullScreen();
            }
        } else if (this.network.isEnableSwitchFullScreenWithKeyboard()) {
            String key = m.A(this.network, "network.full.screen.keyboard");
            KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
            if (e2.getKeyCode() == keyStroke.getKeyCode()) {
                this.network.toggleFullScreen();
            }
        }
    }
}

