/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.background;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import javax.swing.ImageIcon;
import twaver.TWaverUtil;
import twaver.base.A.E.d;
import twaver.base.A.H.I;
import twaver.network.background.AbstractBackground;
import twaver.web.WebUtil;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;

public class TextureBackground
extends AbstractBackground {
    protected transient TexturePaint texture = null;
    protected String imageURL = null;

    public TextureBackground() {
    }

    public TextureBackground(TexturePaint texture) {
        this.texture = texture;
    }

    public TextureBackground(Image image) {
        this.texture = d.A(image);
    }

    public TextureBackground(String imageURL) {
        this.setImageURL(imageURL);
    }

    public void paintContent(Graphics2D g2, double zoom, Rectangle viewportRect) {
        if (this.texture == null && this.imageURL != null) {
            this.setImageURL(this.imageURL);
        }
        if (this.texture != null) {
            g2.setPaint(this.texture);
            g2.fillRect(0, 0, (int)viewportRect.getWidth(), (int)viewportRect.getHeight());
        }
    }

    public Dimension getBackgroundSize() {
        return null;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
        this.texture = d.A(TWaverUtil.getImage(imageURL));
    }

    public SVGStruct toSVG(SVGContext context) {
        if (this.imageURL != null) {
            ImageIcon image = TWaverUtil.getImageIcon(this.imageURL);
            StringBuffer sb = new StringBuffer();
            Rectangle rect = new Rectangle(0, 0, image.getIconWidth(), image.getIconHeight());
            String id = WebUtil.getNextCustomDefinitionID();
            I.A(sb, id, rect).append(">");
            I.A(context, sb, this.imageURL, null, 0, 0, this.getAlpha());
            sb.append("</pattern>");
            context.registerCustomDefinition(sb.toString());
            StringBuffer svgSB = I.A(context, "svg_background_id", null, (Object)id, null, null, -1.0f, 0.0, null);
            I.C(context, svgSB);
            svgSB.append("/>\n");
            return new SVGStruct(svgSB.toString(), null);
        }
        return SVGStruct.EMPTY;
    }
}

