/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.swing.font.FontContext;
import com.nepxion.swing.font.FontManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import twaver.network.background.ColorBackground;

public class TGraphBackground
extends ColorBackground {
    public static final Color BLUE_STYLE_COLOR = new Color(172, 193, 212);
    public static final Color GREEN_STYLE_COLOR = new Color(170, 190, 160);
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    private String title;
    private int titleAlignment = 0;
    private int titleHorizontalGap = 0;
    private int titleVerticalGap = 0;
    private int titleMaximumHeight = 50;
    private Color titleColor = Color.black;
    private Font titleFont = FontContext.getChartTitleFont();

    public TGraphBackground(Color color, Color gradientColor) {
        this.setColor(color);
        this.setGradientColor(gradientColor);
        this.setGradient(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
    }

    public int getTitleHorizontalGap() {
        return this.titleHorizontalGap;
    }

    public void setTitleHorizontalGap(int titleHorizontalGap) {
        this.titleHorizontalGap = titleHorizontalGap;
    }

    public int getTitleVerticalGap() {
        return this.titleVerticalGap;
    }

    public void setTitleVerticalGap(int titleVerticalGap) {
        this.titleVerticalGap = titleVerticalGap;
    }

    public int getTitleMaximumHeight() {
        return this.titleMaximumHeight;
    }

    public void setTitleMaximumHeight(int titleMaximumHeight) {
        this.titleMaximumHeight = titleMaximumHeight;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void paintContent(Graphics2D g, double zoom, Rectangle viewportRect) {
        super.paintContent(g, zoom, viewportRect);
        if (this.title != null && !this.title.trim().equals("")) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.titleColor);
            g2d.setFont(this.titleFont);
            int width = viewportRect.width;
            int height = viewportRect.height;
            if (this.titleAlignment == 0) {
                FontManager.drawCenterString((Graphics2D)g2d, (String)this.title, (int)width, (int)this.titleMaximumHeight, (int)this.titleHorizontalGap, (int)this.titleVerticalGap);
            } else {
                FontManager.drawCenterString((Graphics2D)g2d, (String)this.title, (int)width, (int)this.titleMaximumHeight, (int)this.titleHorizontalGap, (int)(height - this.titleMaximumHeight - this.titleVerticalGap));
            }
        }
    }
}

