/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import twaver.base.A.D.K;
import twaver.base.A.E.L;
import twaver.base.A.E.b;
import twaver.base.A.E.d;
import twaver.network.ui.AbstractBorderUI;
import twaver.network.ui.BaseElementUI;
import twaver.network.ui.ElementUI;
import twaver.network.ui.GroupUI;
import twaver.network.ui.NodeUI;

public class DefaultBorderUI
extends AbstractBorderUI {
    public DefaultBorderUI(ElementUI elementUI) {
        super(elementUI);
    }

    public void paintBorder(Graphics2D g2d) {
        if (!this.isVisible()) {
            return;
        }
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.isAntialias()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isXormode()) {
            g2d.setXORMode(Color.WHITE);
        }
        Shape shape = this.getShape();
        if (this.isFill()) {
            g2d.setColor(this.getFillColor());
            g2d.fill(shape);
        }
        g2d.setStroke(this.getStorke());
        g2d.setColor(this.getColor());
        g2d.draw(shape);
        if (this.isXormode()) {
            g2d.setPaintMode();
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    public Rectangle getBounds() {
        if (!this.isVisible()) {
            return null;
        }
        Shape shape = this.elementUI.getBorderShape();
        if (shape != null) {
            return shape.getBounds();
        }
        Rectangle bounds = this.element.getBounds();
        int offset = this.getBorderInset();
        if (offset > 0) {
            bounds.grow(offset, offset);
        }
        return bounds;
    }

    protected Shape getShape() {
        NodeUI nodeUI;
        BaseElementUI ui;
        int insets = this.getBorderInset();
        Rectangle bounds = this.element.getBounds();
        bounds = this.elementUI instanceof GroupUI ? ((GroupUI)this.elementUI).getShape().getBounds() : this.element.getBounds();
        bounds.grow(insets, insets);
        if (this.getType() == 3) {
            int shapeFactory = b.J(this.element, "border.shape.factory");
            return L.B(shapeFactory, bounds);
        }
        if (this.getType() == 2) {
            return L.A(bounds, insets);
        }
        if (this.elementUI instanceof BaseElementUI && (ui = (BaseElementUI)this.elementUI).isCustomDraw() && !ui.isCustomDrawDefaultBorder()) {
            K shapeFactory = ui.getShapeFactory();
            return shapeFactory.C(ui, bounds);
        }
        Shape shape = this.elementUI.getBorderShape();
        if (shape == null && this.elementUI instanceof NodeUI && (nodeUI = (NodeUI)this.elementUI).isDrawImageShape()) {
            shape = nodeUI.getImageShape();
        }
        if (shape != null && insets > 0) {
            Area area = new Area(d.B(insets * 2).createStrokedShape(shape));
            area.add(new Area(shape));
            shape = area;
        }
        if (shape == null) {
            --bounds.width;
            --bounds.height;
            shape = bounds;
        }
        return shape;
    }
}

