/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.radiobutton;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.button.ISelectorMenuButton;
import com.nepxion.swing.selector.button.JBasicSelectorMenuButton;
import com.nepxion.swing.selector.button.JClassicSelectorMenuButton;
import com.nepxion.swing.selector.radiobutton.JRadioButtonListPanel;
import com.nepxion.swing.textfield.JBasicTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JPanel;

public class JRadioButtonSelectorBar
extends JPanel {
    private JBasicTextField textField = new JBasicTextField();
    private ISelectorMenuButton menuButton;
    private JRadioButtonListPanel radioButtonListPanel;

    public JRadioButtonSelectorBar(List allElementNodes) {
        this(allElementNodes, false);
    }

    public JRadioButtonSelectorBar(List allElementNodes, boolean isClassicStyle) {
        this.textField.setEditable(false);
        this.radioButtonListPanel = new JRadioButtonListPanel(allElementNodes);
        this.radioButtonListPanel.setPreferredSize(new Dimension(300, 300));
        this.menuButton = isClassicStyle ? new JClassicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("selection")){

            @Override
            public boolean confirm() {
                return JRadioButtonSelectorBar.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        } : new JBasicSelectorMenuButton((Icon)IconFactory.getSwingIcon("property.png"), SwingLocale.getString("selection")){

            @Override
            public boolean confirm() {
                return JRadioButtonSelectorBar.this.confirm();
            }

            @Override
            public boolean cancel() {
                return true;
            }
        };
        this.menuButton.setContentPane(this.radioButtonListPanel);
        JPanel buttonContainer = this.menuButton.getOptionButtonPanel().getContainer();
        JClassicButton refreshButton = new JClassicButton(SwingLocale.getString("refresh"), IconFactory.getSwingIcon("stereo/refresh_16.png"), SwingLocale.getString("refresh"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonSelectorBar.this.refresh();
            }
        });
        buttonContainer.add((Component)refreshButton, 0);
        buttonContainer.add(Box.createHorizontalStrut(5), 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.add((Component)((Object)this.menuButton), "East");
        ButtonManager.updateUI((Container)this, new Dimension(26, 26));
    }

    public void refresh() {
    }

    public boolean confirm() {
        IElementNode selectedElementNode = this.radioButtonListPanel.getSelectedElementNode();
        if (selectedElementNode == null) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("select_not_null"), SwingLocale.getString("warning"), 2);
            return false;
        }
        this.textField.setText(selectedElementNode.getText());
        return true;
    }

    public JBasicTextField getTextField() {
        return this.textField;
    }

    public ISelectorMenuButton getMenuButton() {
        return this.menuButton;
    }

    public JRadioButtonListPanel getRadioButtonListPanel() {
        return this.radioButtonListPanel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEditable(enabled);
        ((Component)((Object)this.menuButton)).setEnabled(enabled);
    }

    public Object getValue() {
        return this.textField.getText();
    }

    public void setValue(Object value) {
        this.textField.setText(value != null ? value.toString() : "");
    }
}

