/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.A;
import twaver.table.editor.B;

public class FontChooser
extends JComponent
implements ListSelectionListener {
    protected static final float defaultSize = 8.0f;
    public static final String PREVIEW_PANEL_PROPERTY = "previewPanel";
    private Font B;
    private JList I;
    private JList E;
    private JList C;
    private JTextField G;
    private Font[] F;
    private JLabel A;
    private Object[] H = new Object[]{TWaverUtil.getString("PLAIN"), TWaverUtil.getString("BOLD"), TWaverUtil.getString("ITALIC"), TWaverUtil.getString("BOLDITALIC")};
    private int[] D = new int[]{0, 1, 2, 3};

    public FontChooser() {
        this(TUIManager.getDefaultFont());
    }

    public FontChooser(Font font) {
        this.B = font == null ? TUIManager.getDefaultFont() : font;
        this.A();
    }

    private void A() {
        this.setLayout(new GridLayout(1, 2, 5, 5));
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        JPanel fontcontainer = new JPanel(new BorderLayout(5, 5));
        fontcontainer.add((Component)new JLabel(TWaverUtil.getString("FONT")), "North");
        String[] names = gEnv.getAvailableFontFamilyNames();
        this.F = new Font[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.F[i2] = new Font(names[i2], 0, 12);
        }
        this.I = new JList<String>(names);
        JScrollPane fontNamesScroll = new JScrollPane(this.I);
        this.I.addListSelectionListener(this);
        fontcontainer.add((Component)fontNamesScroll, "Center");
        JPanel fontStylePanel = new JPanel(new BorderLayout(5, 5));
        this.C = new JList<Object>(this.H);
        JScrollPane fontStylesScroll = new JScrollPane(this.C);
        this.C.setSelectedIndex(0);
        this.C.addListSelectionListener(this);
        fontStylePanel.add((Component)new JLabel(TWaverUtil.getString("STYLE")), "North");
        fontStylePanel.add((Component)fontStylesScroll, "Center");
        JPanel fontSizePanel = new JPanel(new BorderLayout(5, 5));
        ArrayList<String> sizes = new ArrayList<String>();
        for (int i3 = 2; i3 < 80; ++i3) {
            sizes.add(i3 + "");
        }
        this.E = new JList<Object>(sizes.toArray());
        JScrollPane fontSizesScroll = new JScrollPane(this.E);
        this.E.addListSelectionListener(this);
        this.G = new JTextField(5);
        this.G.setEditable(true);
        this.G.setText(Integer.toString(this.B.getSize()));
        this.G.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (e2.getSource() == FontChooser.this.G) {
                    FontChooser.this.E.setSelectedValue(FontChooser.this.G.getText(), true);
                    FontChooser.this.A(FontChooser.this.B());
                }
            }
        });
        fontSizePanel.add((Component)new JLabel(TWaverUtil.getString("SIZE")), "North");
        fontSizePanel.add((Component)fontSizesScroll, "Center");
        JPanel other = new JPanel(new GridLayout(1, 2));
        other.add(fontStylePanel);
        other.add(fontSizePanel);
        JPanel examplePanel = new JPanel(new GridLayout(2, 1));
        examplePanel.add(other);
        JLabel previewPane = new JLabel();
        previewPane.setFont(this.B);
        previewPane.setBorder(new TitledBorder(new EtchedBorder(1), TWaverUtil.getString("PREVIEW")));
        this.setPreviewPanel(previewPane);
        examplePanel.add(this.A);
        this.A.setBackground(this.getBackground());
        this.B(this.B);
        this.add(fontcontainer);
        this.add(examplePanel);
        this.validate();
    }

    private void B(Font font) {
        if (font == null) {
            return;
        }
        this.E.setSelectedValue(Integer.toString(font.getSize()), true);
        this.G.setText(Integer.toString(font.getSize()));
        this.I.setSelectedValue(font.getFamily(), true);
        int style = font.getStyle();
        switch (style) {
            case 1: {
                this.C.setSelectedValue(this.H[1], false);
                break;
            }
            case 2: {
                this.C.setSelectedValue(this.H[2], false);
                break;
            }
            case 3: {
                this.C.setSelectedValue(this.H[3], false);
                break;
            }
            default: {
                this.C.setSelectedValue(this.H[0], false);
            }
        }
    }

    private void A(Font f2) {
        if (f2 == null) {
            return;
        }
        this.B = f2;
        this.A.setFont(this.B);
        this.A.setText(this.B.getName());
        this.A.repaint();
    }

    private void A(Font font, int style, float size) {
        if (font != null) {
            this.B = font.deriveFont(style, size);
        }
        this.A.setFont(this.B);
        this.A.setText(font.getName());
        this.A.repaint();
    }

    private void A(float size) {
        this.A(this.B.deriveFont(size));
    }

    private void A(int style) {
        this.A(this.B.deriveFont(style));
    }

    public Font getFont() {
        return this.B;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.A(font);
        this.B(font);
    }

    public void valueChanged(ListSelectionEvent e2) {
        Object source = e2.getSource();
        if (source == this.I) {
            Font f2 = this.F[this.I.getSelectedIndex()];
            this.A(f2, this.C(), this.B());
        } else if (source == this.E) {
            this.G.setText((String)this.E.getSelectedValue());
            this.A(this.B());
        } else if (source == this.C) {
            this.A(this.C());
        }
    }

    private float B() {
        float size;
        try {
            size = Integer.parseInt(this.G.getText());
        }
        catch (NumberFormatException e2) {
            size = 8.0f;
        }
        return size;
    }

    private int C() {
        return this.D[this.C.getSelectedIndex()];
    }

    public static Font showDialog(Component component, String title, Font initialFont) {
        FontChooser pane = new FontChooser(initialFont != null ? initialFont : TUIManager.getDefaultFont());
        A ok = new A(pane);
        JDialog dialog = FontChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addWindowListener(new B._A());
        dialog.addComponentListener(new B._B());
        dialog.setVisible(true);
        return ok.A();
    }

    public static JDialog createDialog(Component c2, String title, boolean modal, FontChooser chooserPane, ActionListener okListener, ActionListener cancelListener) {
        return new B(c2, title, modal, chooserPane, okListener, cancelListener);
    }

    public void setPreviewPanel(JLabel preview) {
        if (this.A != preview) {
            JLabel oldPreview = this.A;
            this.A = preview;
            this.firePropertyChange(PREVIEW_PANEL_PROPERTY, oldPreview, preview);
        }
    }
}

