/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import twaver.EditableFilter;
import twaver.Element;
import twaver.TWaverUtil;
import twaver.base.A.D.D;
import twaver.base.A.E.A;
import twaver.base.A.E.b;
import twaver.base.A.E.m;
import twaver.base.A.I.B;
import twaver.network.ui.AbstractAttachment;
import twaver.network.ui.ElementUI;
import twaver.network.ui.LinkUI;
import twaver.swing.LabelInputField;
import twaver.swing.RotatableLabel;

public class LabelAttachment
extends AbstractAttachment {
    protected Font font;
    protected boolean visible;
    protected Color color;
    protected Color background;
    protected boolean border;
    protected Stroke borderStroke;
    protected Color borderColor;
    protected boolean underline;
    protected Stroke underlineStroke;
    protected Color underlineColor;
    protected int yOffset;
    protected int xOffset;
    protected int yGap;
    protected int xGap;
    protected int position;
    protected boolean selectable;
    protected int orientation;
    protected boolean highlightable;
    protected Color highlightBackground;
    protected Color highlightForeground;
    protected int maxLength;
    protected Icon icon = TWaverUtil.getIcon(b.Q(this.element, "label.icon"));
    protected boolean underBody;
    private static final RotatableLabel J = new RotatableLabel(1);
    private static final RotatableLabel G = new RotatableLabel(2);
    private static final RotatableLabel I = new RotatableLabel(3);
    private static final RotatableLabel E = new RotatableLabel(4);
    private boolean F = true;
    private Rectangle H = null;

    public LabelAttachment(ElementUI ui) {
        super(ui);
        this.font = b.D(this.element, "label.font");
        this.color = b.P(this.element, "label.color");
        this.background = b.P(this.element, "label.background");
        this.position = b.J(this.element, "label.position");
        this.visible = b.K(this.element, "label.visible");
        this.yOffset = b.J(this.element, "label.yoffset");
        this.xOffset = b.J(this.element, "label.xoffset");
        this.yGap = b.J(this.element, "label.ygap");
        this.xGap = b.J(this.element, "label.xgap");
        this.border = b.K(this.element, "label.border");
        this.borderStroke = b.F(this.element, "label.border.stroke");
        this.borderColor = b.P(this.element, "label.border.color");
        this.underline = b.K(this.element, "label.underline");
        this.underlineStroke = b.F(this.element, "label.underline.stroke");
        this.underlineColor = b.P(this.element, "label.underline.color");
        this.selectable = b.K(this.element, "label.selectable");
        this.highlightable = b.K(this.element, "label.highlightable");
        this.orientation = b.J(this.element, "label.orientation");
        this.highlightBackground = b.P(this.element, "label.highlight.background");
        this.highlightForeground = b.P(this.element, "label.highlight.foreground");
        this.maxLength = b.J(this.element, "label.maxlength");
    }

    public RotatableLabel getRenderer() {
        if (this.orientation == 2) {
            return G;
        }
        if (this.orientation == 3) {
            return I;
        }
        if (this.orientation == 4) {
            return E;
        }
        return J;
    }

    public String getText(Element element) {
        return m.A((B)this.network, element);
    }

    public Point getLocation() {
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return bounds.getLocation();
    }

    public void paint(Graphics2D g2d) {
        if (!this.visible) {
            return;
        }
        String elementLabel = this.getText(this.element);
        if (elementLabel == null) {
            return;
        }
        this.paintName(g2d, elementLabel);
    }

    public void paintName(Graphics2D g2d, String elementLabel) {
        Rectangle bounds = this.getBounds();
        RotatableLabel renderer = this.getRenderer();
        if (this.highlightable && this.element.isSelected() && this.network.isSelectedStatePaintable(this.element)) {
            renderer.setOpaque(true);
            renderer.setBackground(this.highlightBackground);
            renderer.setForeground(this.highlightForeground);
        } else {
            if (this.background == null) {
                renderer.setOpaque(false);
            } else {
                renderer.setOpaque(true);
                renderer.setBackground(this.background);
            }
            renderer.setForeground(this.color);
        }
        renderer.setBorderVisible(this.border);
        renderer.setBorderStroke(this.borderStroke);
        renderer.setBorderColor(this.borderColor);
        renderer.setUnderlineVisible(this.underline);
        renderer.setUnderlineStroke(this.underlineStroke);
        renderer.setUnderlineColor(this.underlineColor);
        if (bounds instanceof D) {
            D bs = (D)bounds;
            renderer.setBounds(0, 0, bs.E(), bs.C());
            g2d.translate(bs.D().x, bs.D().y);
            g2d.rotate(bs.A());
            renderer.paint(g2d);
            g2d.rotate(-bs.A());
            g2d.translate(-bs.D().x, -bs.D().y);
        } else {
            renderer.setBounds(0, 0, bounds.width, bounds.height);
            g2d.translate(bounds.x, bounds.y);
            renderer.paint(g2d);
            g2d.translate(-bounds.x, -bounds.y);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDrawBorder() {
        return this.border;
    }

    public void performAction(int gesture, MouseEvent e2) {
        if (gesture != 2) {
            return;
        }
        EditableFilter filter = this.network.getElementLabelEditableFilter();
        if (filter != null && filter.isEditable(this.element)) {
            this.startLabelEditing();
        } else {
            super.performAction(gesture, e2);
        }
    }

    public void startLabelEditing() {
        Rectangle bounds;
        String elementLabel = this.getText(this.element);
        Point centerPoint = null;
        Shape shape = this.getShape();
        if (shape != null) {
            bounds = shape.getBounds();
            centerPoint = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        }
        if (centerPoint == null) {
            if (this.ui instanceof LinkUI) {
                centerPoint = this.ui.getHotspot();
            } else {
                bounds = this.network.getElementBounds(this.element);
                centerPoint = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
            }
        }
        centerPoint.x = (int)((double)centerPoint.x * this.network.getZoom());
        centerPoint.y = (int)((double)centerPoint.y * this.network.getZoom());
        LabelInputField lf = this.network.getElementLabelInputField();
        lf.setFont(this.element.getLabelFont());
        lf.setForeground(this.element.getLabelColor());
        lf.setCurrentElement(this.element);
        lf.startEditing(elementLabel, centerPoint, this.network.getCanvas());
    }

    public boolean isShowUnderBody() {
        return this.underBody;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public Shape getShape() {
        Rectangle bounds = this.getBounds();
        if (bounds instanceof D) {
            return ((D)bounds).B();
        }
        return bounds;
    }

    public Rectangle getBounds() {
        if (!this.visible) {
            return null;
        }
        if (!this.F) {
            return this.H;
        }
        String elementLabel = this.getText(this.element);
        if (elementLabel == null) {
            this.H = null;
        }
        RotatableLabel renderer = this.getRenderer();
        renderer.setFont(this.getFont());
        ((JLabel)renderer).setText(elementLabel);
        renderer.setIcon(this.icon);
        Dimension size = ((JComponent)renderer).getPreferredSize();
        size.width += this.xGap;
        size.height += this.yGap;
        if (this.orientation == 1) {
            size.width += 10;
            if (this.maxLength > 0 && size.width > this.maxLength) {
                size.width = this.maxLength;
            } else if (this.maxLength < 0) {
                size.width = -this.maxLength;
            }
        } else if (this.orientation == 3 || this.orientation == 4) {
            size.height += 10;
        }
        this.H = A.A(this.ui, size, this.position, this.xOffset, this.yOffset);
        return this.H;
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.startsWith("CP:label.")) {
            propertyName = propertyName.substring("CP:".length());
            this.A(propertyName);
        }
        this.F = true;
    }

    private void A(String propertyName) {
        if (propertyName.equals("label.color")) {
            this.color = b.P(this.element, "label.color");
        } else if (propertyName.equals("label.background")) {
            this.background = b.P(this.element, "label.background");
        } else if (propertyName.equals("label.position")) {
            this.position = b.J(this.element, "label.position");
        } else if (propertyName.equals("label.visible")) {
            this.visible = b.K(this.element, "label.visible");
        } else if (propertyName.equals("label.border")) {
            this.border = b.K(this.element, "label.border");
        } else if (propertyName.equals("label.border.stroke")) {
            this.borderStroke = b.F(this.element, "label.border.stroke");
        } else if (propertyName.equals("label.border.color")) {
            this.borderColor = b.P(this.element, "label.border.color");
        } else if (propertyName.equals("label.underline")) {
            this.underline = b.K(this.element, "label.underline");
        } else if (propertyName.equals("label.underline.stroke")) {
            this.underlineStroke = b.F(this.element, "label.underline.stroke");
        } else if (propertyName.equals("label.underline.color")) {
            this.underlineColor = b.P(this.element, "label.underline.color");
        } else if (propertyName.equals("label.yoffset")) {
            this.yOffset = b.J(this.element, "label.yoffset");
        } else if (propertyName.equals("label.xoffset")) {
            this.xOffset = b.J(this.element, "label.xoffset");
        } else if (propertyName.equals("label.ygap")) {
            this.yGap = b.J(this.element, "label.ygap");
        } else if (propertyName.equals("label.xgap")) {
            this.xGap = b.J(this.element, "label.xgap");
        } else if (propertyName.equals("label.selectable")) {
            this.selectable = b.K(this.element, "label.selectable");
        } else if (propertyName.equals("label.highlightable")) {
            this.highlightable = b.K(this.element, "label.highlightable");
        } else if (propertyName.equals("label.orientation")) {
            this.orientation = b.J(this.element, "label.orientation");
        } else if (propertyName.equals("label.highlight.background")) {
            this.highlightBackground = b.P(this.element, "label.highlight.background");
        } else if (propertyName.equals("label.highlight.foreground")) {
            this.highlightForeground = b.P(this.element, "label.highlight.foreground");
        } else if (propertyName.equals("label.maxlength")) {
            this.maxLength = b.J(this.element, "label.maxlength");
        } else if (propertyName.equals("label.font")) {
            this.font = b.D(this.element, "label.font");
        } else if (propertyName.equals("label.icon")) {
            this.icon = TWaverUtil.getIcon(b.Q(this.element, "label.icon"));
        }
    }

    static {
        J.setDoubleBuffered(false);
        G.setDoubleBuffered(false);
        I.setDoubleBuffered(false);
        E.setDoubleBuffered(false);
    }
}

