/*
 * Decompiled with CFR 0.152.
 */
package twaver.animate;

import java.awt.Rectangle;
import java.util.Map;
import twaver.Element;
import twaver.ResizableNode;
import twaver.animate.AnimateProperty;

public class AnimateResize
extends AnimateProperty {
    public AnimateResize(Map newLocations) {
        this(newLocations, null);
    }

    public AnimateResize(Map newBounds, Runnable runnable) {
        this(newBounds, runnable, -1, -1);
    }

    public AnimateResize(Map newBounds, Runnable runnable, int stepSize, int sleep) {
        super(newBounds, runnable, stepSize, sleep);
    }

    public Object getPropertyValue(Element element) {
        return element.getBounds();
    }

    public void step(int stepIndex, Element element, Object oldPropertyValue, Object newPropertyValue) {
        Rectangle oldBound = (Rectangle)oldPropertyValue;
        Rectangle newBound = (Rectangle)newPropertyValue;
        double x = (double)oldBound.x + (double)stepIndex * (newBound.getX() - oldBound.getX()) / (double)this.stepSize;
        double y = (double)oldBound.y + (double)stepIndex * (newBound.getY() - oldBound.getY()) / (double)this.stepSize;
        double w = (double)oldBound.width + (double)stepIndex * (newBound.getWidth() - oldBound.getWidth()) / (double)this.stepSize;
        double h2 = (double)oldBound.height + (double)stepIndex * (newBound.getHeight() - oldBound.getHeight()) / (double)this.stepSize;
        element.setLocation(x, y);
        ((ResizableNode)element).setSize((int)w, (int)h2);
    }
}

