/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.statusbar.JStatusBar;
import com.nepxion.swing.statusbar.JStatusItem;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.NumberFormat;
import javax.swing.JLabel;
import twaver.ZoomListener;

public class TGraphScaleBar
extends JStatusBar {
    public TGraphScaleBar(final TGraph graph) {
        this.setSeparatorHeight(13);
        final JLabel zoomLabel = new JLabel(TIconFactory.getContextIcon("zoom.png"));
        final JLabel positionLabel = new JLabel(TIconFactory.getContextIcon("scale.png"));
        positionLabel.setText("x:0 y:0");
        this.addItem(new JStatusItem((Component)zoomLabel), 90, 2, "LoweredStyle", true);
        this.addItem(new JStatusItem((Component)positionLabel), 130, 2, "LoweredStyle", false);
        graph.getCanvas().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                TGraphScaleBar.this.update(zoomLabel, positionLabel, graph, null);
            }
        });
        graph.getCanvas().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TGraphScaleBar.this.update(zoomLabel, positionLabel, graph, e.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TGraphScaleBar.this.update(zoomLabel, positionLabel, graph, e.getPoint());
            }
        });
        graph.getCanvas().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                TGraphScaleBar.this.update(zoomLabel, positionLabel, graph, e.getPoint());
            }
        });
        graph.getZoomer().addZoomListener(new ZoomListener(){

            public void zoomChanged(double oldZoom, double newZoom) {
                TGraphScaleBar.this.update(zoomLabel, positionLabel, graph, null);
            }
        });
        this.update(zoomLabel, positionLabel, graph, null);
    }

    private void update(JLabel zoomLabel, JLabel positionLabel, TGraph graph, Point point) {
        double zoom = graph.getZoom();
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        zoomLabel.setText(TLocale.getString("graph_zoom") + ":" + format.format(zoom));
        if (point != null) {
            int x = (int)(point.getX() / zoom);
            int y = (int)(point.getY() / zoom);
            positionLabel.setText("x:" + x + " y:" + y);
        }
    }
}

