/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static String getRequestResult(URL url) {
        return XMLUtils.getRequestResult(url, "UTF-8");
    }

    public static String getRequestResult(URL url, String charset) {
        block5: {
            if (url != null) {
                try {
                    String line;
                    StringBuffer sb = new StringBuffer();
                    URLConnection connection = url.openConnection();
                    connection.connect();
                    InputStream is = connection.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(charset)));
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    reader.close();
                    return sb.toString();
                }
                catch (Exception e) {
                    if (e instanceof ConnectException) {
                        JOptionPane.showMessageDialog(null, url + " refused: connect");
                    }
                    if (!(e instanceof UnknownHostException)) break block5;
                    JOptionPane.showMessageDialog(null, "can not find " + url);
                }
            }
        }
        return null;
    }

    public static Document createDocument(String contents, String charset) {
        if (contents != null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                DocumentBuilder db = factory.newDocumentBuilder();
                final ByteArrayInputStream byteIs = new ByteArrayInputStream("".getBytes());
                db.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        return new InputSource(byteIs);
                    }
                });
                ByteArrayInputStream bis = new ByteArrayInputStream(contents.getBytes());
                InputSource inSource = new InputSource(new InputStreamReader((InputStream)bis, charset));
                Document doc = db.parse(inSource);
                bis.close();
                return doc;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getSonValue(Node parent, String sonTag) {
        Node p = XMLUtils.getChild(parent, sonTag);
        return XMLUtils.getNodeValue(p);
    }

    public static String getNodeValue(Node node) {
        Node n;
        if (node != null && (n = node.getFirstChild()) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    public static String getPropertyValue(Node node, String property) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        return map.getNamedItem(property).getNodeValue();
    }

    public static Node getChild(Node parent, String sonTag) {
        List result = XMLUtils.getChildren(parent, sonTag);
        if (result != null && result.size() == 1) {
            return (Node)result.get(0);
        }
        return null;
    }

    public static List getChildren(Node parent, String name) {
        Vector<Node> result = new Vector<Node>();
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals(name)) {
                result.add(node);
            }
            ++i;
        }
        return result;
    }

    public static final String wrapTagHead(String tag) {
        return "<" + tag + ">\n";
    }

    public static final String wrapTagWithAttributes(String tag, String attributes) {
        return "<" + tag + attributes + "/>\n";
    }

    public static final String wrapTagTail(String tag) {
        return "</" + tag + ">\n";
    }

    public static final String wrapValue(String property, Object value) {
        return " " + property + "=\"" + value + "\"";
    }

    public static final String wrapTagWithValue(String tag, Object value) {
        String v = value == null ? null : value.toString();
        return "<" + tag + ">" + v + "</" + tag + ">\n";
    }
}

