/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.timer;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.timer.ITimerComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class JTimerLabel
extends JLabel
implements ITimerComponent {
    public static final String LOOP_ICON = "thread/loop/";
    public static final String BALL_ICON = "thread/ball/";
    public static final String CIRCLE_ICON = "thread/circle/";
    public static final String COMPASS_ICON = "thread/compass/";
    public static final String MAGNIFIER_ICON = "thread/magnifier/";
    private UpdateTimer updateTimer = new UpdateTimer();
    private int delayTime = 30;
    private Icon[] iconGroup;
    private int index = 0;

    public JTimerLabel() {
        this(LOOP_ICON);
    }

    public JTimerLabel(String icon) {
        if (icon.equals(LOOP_ICON)) {
            this.iconGroup = new Icon[15];
            this.updateTimer.setDelay(30);
        } else if (icon.equals(BALL_ICON)) {
            this.iconGroup = new Icon[30];
            this.updateTimer.setDelay(80);
        } else if (icon.equals(CIRCLE_ICON)) {
            this.iconGroup = new Icon[60];
            this.updateTimer.setDelay(80);
        } else if (icon.equals(COMPASS_ICON)) {
            this.iconGroup = new Icon[15];
            this.updateTimer.setDelay(350);
        } else if (icon.equals(MAGNIFIER_ICON)) {
            this.iconGroup = new Icon[22];
            this.updateTimer.setDelay(80);
        }
        for (int i = 0; i < this.iconGroup.length; ++i) {
            this.iconGroup[i] = IconFactory.getSwingIcon(icon + (i + 1) + ".png");
        }
        this.reset();
    }

    @Override
    public boolean isRunning() {
        return this.updateTimer.isRunning();
    }

    @Override
    public void reset() {
        this.index = 0;
        this.setIcon(this.iconGroup[0]);
    }

    @Override
    public void start() {
        this.reset();
        this.updateTimer.start();
    }

    @Override
    public void start(int delayTime) {
        this.setDelayTime(delayTime);
        this.start();
    }

    @Override
    public void restart() {
        this.updateTimer.start();
    }

    @Override
    public void restart(int delayTime) {
        this.setDelayTime(delayTime);
        this.restart();
    }

    @Override
    public void stop() {
        this.updateTimer.stop();
    }

    @Override
    public void finish() {
    }

    @Override
    public int getDelayTime() {
        return this.delayTime;
    }

    @Override
    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
        this.updateTimer.setDelay(delayTime);
    }

    public class UpdateTimer
    extends Timer
    implements ActionListener {
        public UpdateTimer() {
            super(JTimerLabel.this.delayTime, null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTimerLabel.this.index = (JTimerLabel.this.index + 1) % JTimerLabel.this.iconGroup.length;
            JTimerLabel.this.setIcon(JTimerLabel.this.iconGroup[JTimerLabel.this.index]);
        }
    }
}

