/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.id.netease;

import com.nepxion.util.locale.UtilityLocale;
import com.nepxion.util.net.http.apache.ClientInvoker;
import com.nepxion.util.net.http.apache.ClientParameterList;
import com.nepxion.util.net.http.apache.ClientRequestGet;
import com.nepxion.util.searcher.id.netease.NeteaseIDConstants;
import com.nepxion.util.searcher.id.netease.NeteaseIDEntity;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.net.URI;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class NeteaseIDSearcher
implements NeteaseIDConstants {
    private String charset = "GBK";
    private ClientInvoker clientInvoker;

    public NeteaseIDSearcher() {
        this("GBK");
    }

    public NeteaseIDSearcher(String charset) {
        this.charset = charset;
        this.clientInvoker = new ClientInvoker();
    }

    public NeteaseIDEntity search(String id) throws Exception {
        String xml = this.getXML(id);
        return this.createEntity(xml);
    }

    private NeteaseIDEntity createEntity(String xml) {
        if (xml == null || xml.equals("")) {
            return null;
        }
        Document document = null;
        try {
            document = Dom4JReader.getDocument(xml);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        Element productElement = rootElement.element("product");
        NeteaseIDEntity idEntity = new NeteaseIDEntity();
        Element codeElement = productElement.element("code");
        idEntity.setCode(codeElement.getText());
        Element locationElement = productElement.element("location");
        idEntity.setLocation(locationElement.getText());
        Element birthdayElement = productElement.element("birthday");
        String birthday = birthdayElement.getText();
        birthday = birthday.substring(0, 4) + "-" + birthday.substring(4, 6) + "-" + birthday.substring(6);
        idEntity.setBirthday(birthday);
        Element genderElement = productElement.element("gender");
        String gender = genderElement.getText();
        gender = gender.equals("m") ? UtilityLocale.getString("male") : (gender.equals("f") ? UtilityLocale.getString("femal") : UtilityLocale.getString("unknown"));
        idEntity.setGender(gender);
        return idEntity;
    }

    public String getXML(String id) throws Exception {
        ClientRequestGet clientRequestGet = new ClientRequestGet();
        clientRequestGet.setURI(URI.create("http://www.youdao.com/smartresult-xml/search.s"));
        ClientParameterList clientParameterList = new ClientParameterList();
        clientParameterList.put("q", id);
        clientParameterList.put("type", "id");
        clientRequestGet.setParameterEntity(clientParameterList, this.charset);
        String responseText = this.clientInvoker.getResponseText(clientRequestGet, this.charset);
        return responseText;
    }
}

