/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Rectangle;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.GraphEvent;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.YCursor;
import y.base.YList;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;
import y.view.Bend;
import y.view.BendCursor;
import y.view.BendList;
import y.view.Drawable;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2DEvent;
import y.view.Graph2DListener;
import y.view.Graph2DSelectionEvent;
import y.view.Graph2DSelectionListener;
import y.view.Graph2DView;
import y.view.HitInfo;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.PolyLineEdgeRealizer;
import y.view.Selections;
import y.view.ShapeNodeRealizer;
import y.view.View;
import y.view.a;
import y.view.new;
import y.view.try;

public class Graph2D
extends LayoutGraph {
    private NodeRealizer a3;
    private EdgeRealizer a4;
    private YList a6;
    private YList a5;
    private View a8;
    private URL a2;
    private BackupRealizersHandler a9;
    private Vector a7;
    private Vector ba;

    public Graph2D() {
        this.a(new ShapeNodeRealizer(), new PolyLineEdgeRealizer());
    }

    public Graph2D(Graph2D graph2D) {
        this(graph2D, (YCursor)graph2D.nodes());
    }

    public Graph2D(Graph2D graph2D, YCursor yCursor) {
        super(graph2D, yCursor);
        this.a(graph2D.a3.createCopy(), graph2D.a4.createCopy());
    }

    private void a(NodeRealizer nodeRealizer, EdgeRealizer edgeRealizer) {
        this.a3 = nodeRealizer;
        this.a4 = edgeRealizer;
        this.a6 = new YList();
        this.a5 = new YList();
        this.a7 = new Vector(1);
        this.ba = new Vector(1);
    }

    public Graph createCopy() {
        return new Graph2D(this);
    }

    public Graph createGraph() {
        return new Graph2D();
    }

    public Edge createEdge(Node node, Node node2) {
        return this.createEdge(node, node2, this.a4.createCopy());
    }

    public Edge createEdge(Node node, Node node2, EdgeRealizer edgeRealizer) {
        return this.createEdge(node, null, node2, null, 0, 0, edgeRealizer);
    }

    public Edge createEdge(Node node, Edge edge, Node node2, Edge edge2, int n, int n2) {
        return this.createEdge(node, edge, node2, edge2, n, n2, this.a4.createCopy());
    }

    public Edge createEdge(Node node, Edge edge, Node node2, Edge edge2, int n, int n2, EdgeRealizer edgeRealizer) {
        new new_ = new new(this, node, edge, node2, edge2, n, n2, edgeRealizer);
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 1, new_));
        }
        return new_;
    }

    public Node createNode() {
        return this.createNode(this.a3.createCopy());
    }

    public Node createNode(double d2, double d3) {
        NodeRealizer nodeRealizer = this.a3.createCopy();
        nodeRealizer.setCenter(d2, d3);
        return this.createNode(nodeRealizer);
    }

    public Node createNode(double d2, double d3, String string) {
        NodeRealizer nodeRealizer = this.a3.createCopy();
        nodeRealizer.setCenter(d2, d3);
        nodeRealizer.setLabelText(string);
        return this.createNode(nodeRealizer);
    }

    public Node createNode(double d2, double d3, double d4, double d5, String string) {
        NodeRealizer nodeRealizer = this.a3.createCopy();
        nodeRealizer.setSize(d4, d5);
        nodeRealizer.setCenter(d2, d3);
        nodeRealizer.setLabelText(string);
        return this.createNode(nodeRealizer);
    }

    public Node createNode(NodeRealizer nodeRealizer) {
        a a2 = new a(this, nodeRealizer);
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 0, a2));
        }
        return a2;
    }

    public Rectangle getBoundingBox() {
        Rectangle rectangle = new Rectangle(0, 0, -1, -1);
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).calcUnionRect(rectangle);
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            this.getRealizer(edgeCursor.edge()).calcUnionRect(rectangle);
            edgeCursor.next();
        }
        return rectangle;
    }

    public Rectangle getBoundingBox(byte by) {
        Rectangle rectangle = new Rectangle(0, 0, -1, -1);
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).calcUnionRect(rectangle, by);
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            EdgeRealizer edgeRealizer = this.getRealizer(edgeCursor.edge());
            if (edgeRealizer.getLayer() == by) {
                edgeRealizer.calcUnionRect(rectangle);
            }
            edgeCursor.next();
        }
        return rectangle;
    }

    public void setLayerAll(byte by) {
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).setLayer(by);
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            this.getRealizer(edgeCursor.edge()).setLayer(by);
            edgeCursor.next();
        }
    }

    public Rectangle setLocation(double d2, double d3) {
        Rectangle rectangle = this.getBoundingBox();
        double d4 = d2 - rectangle.getX();
        double d5 = d3 - rectangle.getY();
        this.moveNodes(this.nodes(), d4, d5);
        this.moveBends(this.bends(), d4, d5);
        rectangle.setLocation((int)d2, (int)d3);
        return rectangle;
    }

    public BendCursor bends() {
        return new try(this);
    }

    public void setDefaultNodeRealizer(NodeRealizer nodeRealizer) {
        this.a3 = nodeRealizer;
    }

    public void setDefaultEdgeRealizer(EdgeRealizer edgeRealizer) {
        this.a4 = edgeRealizer;
    }

    public NodeRealizer getDefaultNodeRealizer() {
        return this.a3;
    }

    public EdgeRealizer getDefaultEdgeRealizer() {
        return this.a4;
    }

    public NodeRealizer getRealizer(Node node) {
        return ((a)node).r;
    }

    public EdgeRealizer getRealizer(Edge edge) {
        return ((new)edge).l;
    }

    public void setRealizer(Node node, NodeRealizer nodeRealizer) {
        NodeRealizer nodeRealizer2 = ((a)node).r;
        nodeRealizer.a(node);
        ((a)node).r = nodeRealizer;
        this.fireGraph2DEvent(node, "realizer", nodeRealizer2, nodeRealizer);
    }

    public void setRealizer(Edge edge, EdgeRealizer edgeRealizer) {
        EdgeRealizer edgeRealizer2 = ((new)edge).l;
        edgeRealizer.bindEdge(edge);
        ((new)edge).l = edgeRealizer;
        this.fireGraph2DEvent(edge, "realizer", edgeRealizer2, edgeRealizer);
    }

    public NodeLayout getLayout(Node node) {
        return this.getRealizer(node);
    }

    public EdgeLayout getLayout(Edge edge) {
        return this.getRealizer(edge);
    }

    public NodeLabelLayout[] getLabelLayout(Node node) {
        NodeLabelLayout[] nodeLabelLayoutArray = new NodeLabelLayout[]{this.getRealizer(node).getLabel()};
        return nodeLabelLayoutArray;
    }

    public EdgeLabelLayout[] getLabelLayout(Edge edge) {
        EdgeRealizer edgeRealizer = this.getRealizer(edge);
        EdgeLabelLayout[] edgeLabelLayoutArray = new EdgeLabelLayout[edgeRealizer.labelCount()];
        int n = 0;
        while (n < edgeLabelLayoutArray.length) {
            edgeLabelLayoutArray[n] = edgeRealizer.getLabel(n);
            ++n;
        }
        return edgeLabelLayoutArray;
    }

    public Node getFeature(NodeLabelLayout nodeLabelLayout) {
        NodeLabel nodeLabel = (NodeLabel)nodeLabelLayout;
        return nodeLabel.getNode();
    }

    public Edge getFeature(EdgeLabelLayout edgeLabelLayout) {
        EdgeLabel edgeLabel = (EdgeLabel)edgeLabelLayout;
        return edgeLabel.getEdge();
    }

    public boolean isSelectionEmpty() {
        return this.selectedNodes().size() == 0 && this.selectedBends().size() == 0 && this.selectedEdges().size() == 0;
    }

    public boolean isSelectionSingleton() {
        return this.selectedNodes().size() + this.selectedBends().size() == 1;
    }

    public NodeCursor selectedNodes() {
        NodeList nodeList = new NodeList();
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            if (this.getRealizer(nodeCursor.node()).isSelected()) {
                nodeList.addLast(nodeCursor.node());
            }
            nodeCursor.next();
        }
        return nodeList.nodes();
    }

    public EdgeCursor selectedEdges() {
        EdgeList edgeList = new EdgeList();
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            if (this.getRealizer(edgeCursor.edge()).isSelected()) {
                edgeList.addLast(edgeCursor.edge());
            }
            edgeCursor.next();
        }
        return edgeList.edges();
    }

    public BendCursor selectedBends() {
        BendList bendList = new BendList();
        BendCursor bendCursor = this.bends();
        while (bendCursor.ok()) {
            if (bendCursor.bend().isSelected()) {
                bendList.addLast(bendCursor.bend());
            }
            bendCursor.next();
        }
        return bendList.bends();
    }

    public void unselectAll() {
        this.firePreEvent();
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).setSelected(false);
            nodeCursor.next();
        }
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            EdgeRealizer edgeRealizer = this.getRealizer(edgeCursor.edge());
            edgeRealizer.setSelected(false);
            BendCursor bendCursor = edgeRealizer.bends();
            while (bendCursor.ok()) {
                bendCursor.bend().setSelected(false);
                bendCursor.next();
            }
            edgeCursor.next();
        }
        this.firePostEvent();
    }

    public void unselectNodes() {
        this.firePreEvent();
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).setSelected(false);
            nodeCursor.next();
        }
        this.firePostEvent();
    }

    public void unselectEdges() {
        this.firePreEvent();
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            this.getRealizer(edgeCursor.edge()).setSelected(false);
            edgeCursor.next();
        }
        this.firePostEvent();
    }

    public void unselectBends() {
        this.firePreEvent();
        BendCursor bendCursor = this.bends();
        while (bendCursor.ok()) {
            bendCursor.bend().setSelected(false);
            bendCursor.next();
        }
        this.firePostEvent();
    }

    public void moveNodes(NodeCursor nodeCursor, double d2, double d3) {
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).moveBy(d2, d3);
            nodeCursor.next();
        }
    }

    public void moveBends(BendCursor bendCursor, double d2, double d3) {
        bendCursor.toFirst();
        while (bendCursor.ok()) {
            bendCursor.bend().moveBy(d2, d3);
            bendCursor.next();
        }
    }

    public void removeSelection() {
        Object object;
        if (this.listeners != null) {
            this.firePreEvent();
        }
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            object = this.getRealizer(edgeCursor.edge());
            boolean bl = false;
            BendCursor bendCursor = ((EdgeRealizer)object).bends();
            while (bendCursor.ok()) {
                if (bendCursor.bend().isSelected()) {
                    bl = true;
                }
                bendCursor.next();
            }
            if (bl) {
                this.backupRealizers(new EdgeList(edgeCursor.edge()).edges());
                object = this.getRealizer(edgeCursor.edge());
                BendCursor bendCursor2 = ((EdgeRealizer)object).bends();
                while (bendCursor2.ok()) {
                    if (bendCursor2.bend().isSelected()) {
                        ((EdgeRealizer)object).removeBend(bendCursor2.bend());
                    }
                    bendCursor2.next();
                }
            }
            if (((EdgeRealizer)object).isSelected()) {
                this.removeEdge(edgeCursor.edge());
            }
            edgeCursor.next();
        }
        object = this.nodes();
        while (object.ok()) {
            if (this.getRealizer(object.node()).isSelected()) {
                this.removeNode(object.node());
            }
            object.next();
        }
        if (this.listeners != null) {
            this.firePostEvent();
        }
    }

    public void selectBoxContent(Rectangle rectangle) {
        this.selectBoxContent(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void selectBoxContent(double d2, double d3, double d4, double d5) {
        Object object;
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            object = nodeCursor.node();
            if (this.getRealizer((Node)object).isInBox(d2, d3, d4, d5)) {
                Selections.selectNodeAndSelfLoopBends(this, (Node)object);
            }
            nodeCursor.next();
        }
        object = this.bends();
        while (object.ok()) {
            Bend bend = object.bend();
            if (bend.isInBox(d2, d3, d4, d5)) {
                bend.setSelected(true);
            }
            object.next();
        }
    }

    public HitInfo getHitInfo(double d2, double d3, boolean bl) {
        return new HitInfo(this, d2, d3, bl);
    }

    public HitInfo getHitInfo(double d2, double d3) {
        return this.getHitInfo(d2, d3, true);
    }

    public void setLabelText(Node node, String string) {
        this.getRealizer(node).setLabelText(string);
    }

    public String getLabelText(Node node) {
        return this.getRealizer(node).getLabelText();
    }

    public void setLabelText(Edge edge, String string) {
        this.getRealizer(edge).setLabelText(string);
    }

    public String getLabelText(Edge edge) {
        return this.getRealizer(edge).getLabelText();
    }

    public void setSelected(Edge edge, boolean bl) {
        this.getRealizer(edge).setSelected(bl);
    }

    public void setSelected(EdgeCursor edgeCursor, boolean bl) {
        if (!edgeCursor.ok()) {
            return;
        }
        this.firePreEvent();
        while (edgeCursor.ok()) {
            this.getRealizer(edgeCursor.edge()).setSelected(bl);
            edgeCursor.next();
        }
        this.firePostEvent();
    }

    public void setSelected(Node node, boolean bl) {
        this.getRealizer(node).setSelected(bl);
    }

    public void setSelected(NodeCursor nodeCursor, boolean bl) {
        if (!nodeCursor.ok()) {
            return;
        }
        this.firePreEvent();
        while (nodeCursor.ok()) {
            this.getRealizer(nodeCursor.node()).setSelected(bl);
            nodeCursor.next();
        }
        this.firePostEvent();
    }

    public void setBendsSelected(BendCursor bendCursor, boolean bl) {
        if (!bendCursor.ok()) {
            return;
        }
        this.firePreEvent();
        while (bendCursor.ok()) {
            bendCursor.bend().setSelected(bl);
            bendCursor.next();
        }
        this.firePostEvent();
    }

    public void setBendsSelected(Edge edge, boolean bl) {
        this.setBendsSelected(this.getRealizer(edge).bends(), bl);
    }

    public void setBendsSelected(EdgeCursor edgeCursor, boolean bl) {
        if (!edgeCursor.ok()) {
            return;
        }
        this.firePreEvent();
        while (edgeCursor.ok()) {
            this.setBendsSelected(edgeCursor.edge(), bl);
            edgeCursor.next();
        }
        this.firePostEvent();
    }

    public void selectAllNodesAndBends(boolean bl) {
        this.firePreEvent();
        this.setSelected(this.nodes(), bl);
        this.setBendsSelected(this.edges(), bl);
        this.firePostEvent();
    }

    public boolean isSelected(Edge edge) {
        return this.getRealizer(edge).isSelected();
    }

    public boolean isSelected(Node node) {
        return this.getRealizer(node).isSelected();
    }

    public double getCenterX(Node node) {
        return this.getRealizer(node).getCenterX();
    }

    public double getCenterY(Node node) {
        return this.getRealizer(node).getCenterY();
    }

    public double getX(Node node) {
        return this.getRealizer(node).getX();
    }

    public double getY(Node node) {
        return this.getRealizer(node).getY();
    }

    public double getWidth(Node node) {
        return this.getRealizer(node).getWidth();
    }

    public double getHeight(Node node) {
        return this.getRealizer(node).getHeight();
    }

    public void setCenter(Node node, double d2, double d3) {
        this.getRealizer(node).setCenter(d2, d3);
    }

    public void setSize(Node node, double d2, double d3) {
        this.getRealizer(node).setSize(d2, d3);
    }

    public void setLocation(Node node, double d2, double d3) {
        this.getRealizer(node).setLocation(d2, d3);
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.getURL();
        this.a2 = uRL;
        this.fireGraph2DEvent(this, "URL", uRL2, uRL);
    }

    public URL getURL() {
        return this.a2;
    }

    public void addDrawable(Drawable drawable) {
        this.a5.addLast(drawable);
    }

    public YCursor drawables() {
        return this.a5.cursor();
    }

    public void removeDrawable(Drawable drawable) {
        this.a5.remove(drawable);
    }

    public YCursor getViews() {
        return this.a6.cursor();
    }

    public View getCurrentView() {
        if (this.a8 != null) {
            return this.a8;
        }
        if (this.a6.size() > 0) {
            return (View)this.a6.first();
        }
        return null;
    }

    public void setCurrentView(View view) {
        this.a8 = view;
    }

    public void registerView(View view) {
        this.a6.addLast(view);
    }

    public void removeView(View view) {
        if (this.getCurrentView() == view) {
            this.setCurrentView(null);
        }
        this.a6.remove(view);
    }

    public void updateViews() {
        YCursor yCursor = this.a6.cursor();
        while (yCursor.ok()) {
            ((View)yCursor.current()).updateView();
            yCursor.next();
        }
    }

    public void fitGraph2DView() {
        if (!(this.getCurrentView() instanceof Graph2DView)) {
            return;
        }
        ((Graph2DView)this.getCurrentView()).fitContent();
    }

    public void setBackupRealizersHandler(BackupRealizersHandler backupRealizersHandler) {
        this.a9 = backupRealizersHandler;
    }

    public BackupRealizersHandler getBackupRealizersHandler() {
        return this.a9;
    }

    public void backupRealizers() {
        this.firePreEvent();
        this.backupRealizers(this.nodes());
        this.backupRealizers(this.edges());
        this.firePostEvent();
    }

    public void backupRealizers(EdgeCursor edgeCursor) {
        if (this.a9 != null) {
            this.a9.backupRealizers(this, edgeCursor);
        }
    }

    public void backupRealizers(NodeCursor nodeCursor) {
        if (this.a9 != null) {
            this.a9.backupRealizers(this, nodeCursor);
        }
    }

    public void addGraph2DSelectionListener(Graph2DSelectionListener graph2DSelectionListener) {
        this.a7.add(graph2DSelectionListener);
    }

    public void removeGraph2DSelectionListener(Graph2DSelectionListener graph2DSelectionListener) {
        this.a7.remove(graph2DSelectionListener);
    }

    public Iterator getGraph2DSelectionListeners() {
        return this.a7.iterator();
    }

    protected void fireGraph2DSelectionEvent(Object object) {
        Graph2DSelectionEvent graph2DSelectionEvent = new Graph2DSelectionEvent(this, object);
        int n = 0;
        while (n < this.a7.size()) {
            ((Graph2DSelectionListener)this.a7.get(n)).onGraph2DSelectionEvent(graph2DSelectionEvent);
            ++n;
        }
    }

    public void addGraph2DListener(Graph2DListener graph2DListener) {
        this.ba.add(graph2DListener);
    }

    public void removeGraph2DListener(Graph2DListener graph2DListener) {
        this.ba.remove(graph2DListener);
    }

    public Iterator getGraph2DListeners() {
        return this.ba.iterator();
    }

    protected void fireGraph2DEvent(Object object, String string, Object object2, Object object3) {
        Graph2DEvent graph2DEvent = new Graph2DEvent(this, object, string, object2, object3);
        int n = 0;
        while (n < this.ba.size()) {
            ((Graph2DListener)this.ba.get(n)).onGraph2DEvent(graph2DEvent);
            ++n;
        }
    }

    public static interface BackupRealizersHandler {
        public void backupRealizers(Graph2D var1, EdgeCursor var2);

        public void backupRealizers(Graph2D var1, NodeCursor var2);
    }
}

