/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;

public class HoverBorder
implements Border {
    private Dimension lastComponentSize;
    private int thickness;
    private Insets insets;
    private Color color;
    private Color color2;

    public HoverBorder(Color color, int thickness) {
        this.color = color;
        if (color == null) {
            this.color = color = Color.gray;
        }
        this.color2 = new Color(210, 210, 210, 0);
        this.thickness = thickness;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Dimension currentComponent = c.getSize();
        if (currentComponent.equals(this.lastComponentSize)) {
            return this.insets;
        }
        this.insets = new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        this.lastComponentSize = currentComponent;
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g.create();
        GradientPaint gp = new GradientPaint(x, y, this.color, x, y + this.thickness, this.color2);
        g2d.setPaint(gp);
        g2d.fillRect(x, y, width, this.thickness);
        gp = new GradientPaint(x, y + height - this.thickness - 1, this.color2, x, y + height, this.color);
        g2d.setPaint(gp);
        g2d.fillRect(x, y + height - this.thickness - 1, width, this.thickness);
        gp = new GradientPaint(x, y, this.color, x + this.thickness, y, this.color2);
        g2d.setPaint(gp);
        g2d.fillRect(x, y, this.thickness, height);
        gp = new GradientPaint(x + width - this.thickness - 1, y, this.color2, x + width, y, this.color);
        g2d.setPaint(gp);
        g2d.fillRect(x + width - this.thickness - 1, y, this.thickness, height);
        g2d.setPaint(this.color);
        g2d.drawRect(x, y, width - 1, height - 1);
        g2d.dispose();
    }
}

