/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.element;

import com.nepxion.cots.twaver.element.TElement;
import com.nepxion.cots.twaver.locale.TLocale;
import java.awt.Color;
import twaver.Element;
import twaver.Link;
import twaver.Node;
import twaver.TDataBox;
import twaver.TUIManager;

public class TLink
extends Link
implements TElement {
    private Color highLightColor = Color.green;
    private boolean isHighLightable = false;
    private boolean isLeaf = false;
    private boolean isCategory = false;
    private boolean isSpecial = false;
    private boolean isDeletePermitted = true;

    public TLink() {
        this.initComponents();
    }

    public TLink(Node from, Node to) {
        super(from, to);
        this.initComponents();
    }

    public TLink(Object id) {
        super(id);
        this.initComponents();
    }

    public TLink(Object id, Node from, Node to) {
        super(id, from, to);
        this.initComponents();
    }

    private void initComponents() {
        this.putLinkAntialias(true);
        this.putClientProperty("border.underneath", Boolean.FALSE);
        this.putClientProperty("border.type", 1);
        this.putClientProperty("link.to.arrow.color", Color.yellow);
    }

    public Color getHighLightColor() {
        return this.highLightColor;
    }

    public void setHighLightColor(Color highLightColor) {
        this.highLightColor = highLightColor;
    }

    public boolean isHighLightable() {
        return this.isHighLightable;
    }

    public void setHighLightable(boolean isHighLightable) {
        this.isHighLightable = isHighLightable;
        if (this.isSelected()) {
            return;
        }
        if (this.isHighLightable) {
            this.putClientProperty("link.color", this.highLightColor);
        } else {
            this.putClientProperty("link.color", TUIManager.get((String)"link.color"));
        }
    }

    public Element copy() {
        TLink link = (TLink)super.copy();
        this.copyProperty(link, true);
        return link;
    }

    public Element copy(Object id) {
        TLink link = (TLink)super.copy(id);
        this.copyProperty(link, true);
        return link;
    }

    public Element copy(TDataBox box) {
        TLink link = (TLink)super.copy(box);
        this.copyProperty(link, true);
        return link;
    }

    public Element copy(Object id, TDataBox box) {
        TLink link = (TLink)super.copy(id, box);
        this.copyProperty(link, true);
        return link;
    }

    public Element copyAll() {
        TLink link = (TLink)super.copy();
        this.copyProperty(link, false);
        link.setUserObject(this.getUserObject());
        return link;
    }

    private void copyProperty(TLink link, boolean changeName) {
        if (changeName) {
            link.setName(TLocale.getString("element_copied") + " " + this.getName());
        }
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public boolean isCategory() {
        return this.isCategory;
    }

    @Override
    public void setCategory(boolean isCategory) {
        this.isCategory = isCategory;
    }

    @Override
    public boolean isSpecial() {
        return this.isSpecial;
    }

    @Override
    public void setSpecial(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @Override
    public boolean isDeletePermitted() {
        return this.isDeletePermitted;
    }

    @Override
    public void setDeletePermitted(boolean isDeletePermitted) {
        this.isDeletePermitted = isDeletePermitted;
    }

    public void putClientProperty(Object key, Object value) {
        if (TUIManager.isPredefinedClientPropertyKey((String)key.toString())) {
            super.putClientProperty(key, value);
        } else {
            this.putServiceClientProperty(key, value);
        }
    }

    public void putServiceClientProperty(Object key, Object value) {
    }

    public Object getClientProperty(Object key) {
        if (TUIManager.isPredefinedClientPropertyKey((String)key.toString())) {
            return super.getClientProperty(key);
        }
        return this.getServiceClientProperty(key);
    }

    public Object getServiceClientProperty(Object key) {
        return null;
    }

    public void setName(String name) {
        super.setName(name);
        this.setServiceName(name);
    }

    public void setServiceName(String name) {
    }

    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
        this.setServiceUserObject(userObject);
    }

    public void setServiceUserObject(Object userObject) {
    }

    public String toString() {
        return this.getName();
    }
}

