/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.system;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.io.IOUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class SystemUtil {
    public static boolean verifyOS(String osName) {
        String name = System.getProperty("os.name");
        return name != null && name.startsWith(osName);
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String processCmd(String cmd, boolean waitFor) throws Exception {
        return SystemUtil.processCmd(cmd, EncoderContext.getIOCharset(), waitFor);
    }

    public static String processCmd(String cmd, String charset, boolean waitFor) throws Exception {
        Process process = Runtime.getRuntime().exec("cmd /c " + cmd);
        InputStream inputStream = process.getInputStream();
        String result = IOUtil.readString(inputStream, charset, true);
        if (waitFor) {
            process.waitFor();
        }
        return result;
    }

    public static InputStream processCmdStream(String cmd, boolean waitFor) throws Exception {
        Process process = Runtime.getRuntime().exec("cmd /c " + cmd);
        InputStream inputStream = process.getInputStream();
        if (waitFor) {
            process.waitFor();
        }
        return inputStream;
    }

    public static void processBat(String cmd, boolean waitFor) throws Exception {
        Process process = Runtime.getRuntime().exec("cmd.exe /c start " + (waitFor ? "/wait " : "") + cmd);
        if (waitFor) {
            process.waitFor();
        }
    }

    public static String getEnvironmentVariable(String key) throws Exception {
        Map environmentVariables = SystemUtil.getEnvironmentVariables();
        for (String k : environmentVariables.keySet()) {
            if (!k.trim().toLowerCase().equals(key.trim().toLowerCase())) continue;
            return (String)environmentVariables.get(k);
        }
        return null;
    }

    public static Map getEnvironmentVariables() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream inputStream = SystemUtil.processCmdStream("set", false);
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                String[] stringArray = line.split("=");
                map.put(stringArray[0].trim(), stringArray[1].trim());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return map;
    }

    public static String getRegEnvironmentVariable(String key, boolean system) throws Exception {
        Map environmentVariables = SystemUtil.getRegEnvironmentVariables(system);
        for (String k : environmentVariables.keySet()) {
            if (!k.trim().toLowerCase().equals(key.trim().toLowerCase())) continue;
            return (String)environmentVariables.get(k);
        }
        return null;
    }

    public static Map getRegEnvironmentVariables(boolean system) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String cmd = null;
        cmd = system ? "reg query \"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\\\" /v" : "reg query \"HKEY_CURRENT_USER\\Environment\\\" /v";
        InputStream inputStream = SystemUtil.processCmdStream(cmd, false);
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if ((line = line.trim()).equals("")) continue;
                if (line.indexOf("REG_SZ") > -1) {
                    stringArray = line.split("REG_SZ");
                    map.put(stringArray[0].trim(), stringArray[1].trim());
                    continue;
                }
                if (line.indexOf("REG_EXPAND_SZ") <= -1) continue;
                stringArray = line.split("REG_EXPAND_SZ");
                map.put(stringArray[0].trim(), stringArray[1].trim());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return map;
    }
}

