/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.io;

import com.nepxion.util.encoder.EncoderContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class IOUtil {
    public static void write(OutputStream outputStream, Object object) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(outputStream);
            oos.writeObject(object);
            oos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static Object read(InputStream inputStream) throws IOException, ClassNotFoundException {
        Object object = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(inputStream);
            object = ois.readObject();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
        return object;
    }

    public static ByteArrayOutputStream write(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.write(baos, object);
        baos.flush();
        baos.close();
        return baos;
    }

    public static Object read(ByteArrayOutputStream outputStream) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(outputStream.toByteArray());
        Object object = IOUtil.read(bais);
        bais.close();
        return object;
    }

    public static ByteArrayInputStream getInputStream(Object object) throws IOException {
        ByteArrayOutputStream baos = IOUtil.write(object);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    public static Object getObject(InputStream inputStream) throws IOException, ClassNotFoundException {
        return IOUtil.read(inputStream);
    }

    public static ByteArrayInputStream getInputStream(String text) {
        ByteArrayInputStream bais = new ByteArrayInputStream(text.getBytes());
        return bais;
    }

    public static String getString(InputStream inputStream) throws IOException, UnsupportedEncodingException {
        return IOUtil.getString(inputStream, EncoderContext.getIOCharset());
    }

    public static String getString(InputStream inputStream, String charset) throws IOException, UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charset);
            char[] bytes = new char[4096];
            int index = -1;
            while ((index = inputStreamReader.read(bytes)) != -1) {
                stringBuffer.append(new String(bytes, 0, index));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String readString(InputStream inputStream, boolean emptyLineRemoved) throws IOException, UnsupportedEncodingException {
        return IOUtil.readString(inputStream, EncoderContext.getIOCharset(), emptyLineRemoved);
    }

    public static String readString(InputStream inputStream, String charset, boolean emptyLineRemoved) throws IOException, UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, charset);
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (emptyLineRemoved) {
                    if (line.equals("")) continue;
                    stringBuffer.append(line + "\n");
                    continue;
                }
                stringBuffer.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuffer.toString().trim();
    }

    public static Object deepClone(Object object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = IOUtil.write(object);
        Object cloneObject = IOUtil.read(baos);
        return cloneObject;
    }

    public static void main(String[] args) {
        String[] array = new String[]{"Value1", "Value2", "Value3"};
        ByteArrayInputStream arrayInputStream = null;
        try {
            arrayInputStream = IOUtil.getInputStream(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("getInputStream() : " + arrayInputStream);
        String[] object = null;
        try {
            object = (String[])IOUtil.getObject(arrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("getObject() : [" + object[0] + ", " + object[1] + ", " + object[2] + "]");
        String text = "Value1, Value2, Value3";
        ByteArrayInputStream stringInputStream = IOUtil.getInputStream(text);
        System.out.println("getInputStream() : " + stringInputStream);
        String string = null;
        try {
            string = IOUtil.getString(stringInputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("getString() : " + string);
    }
}

