/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import twaver.Branch;
import twaver.Link;
import twaver.Node;
import twaver.Segment;
import twaver.SerializablePropertyChangeListener;

public class PolyLine
extends Link {
    protected List segments = new ArrayList();
    protected List branchs = new ArrayList();
    protected Object blinkingObject = null;
    private PropertyChangeListener J = new SerializablePropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("fromNode") || propertyName.equals("toNode")) {
                Node newNode;
                Node oldNode = (Node)evt.getOldValue();
                if (oldNode != null) {
                    oldNode.removePropertyChangeListener(PolyLine.this.K);
                }
                if ((newNode = (Node)evt.getNewValue()) != null) {
                    newNode.removePropertyChangeListener(PolyLine.this.K);
                    newNode.addPropertyChangeListener(PolyLine.this.K);
                }
            }
            PolyLine.this.firePropertyChange("segment", evt.getOldValue(), evt.getNewValue());
        }
    };
    private PropertyChangeListener L = new SerializablePropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("segment")) {
                Segment segment = (Segment)evt.getOldValue();
                if (segment != null) {
                    PolyLine.this.removeSegment(segment);
                }
                if ((segment = (Segment)evt.getNewValue()) != null) {
                    PolyLine.this.addSegment(segment);
                }
            }
            PolyLine.this.firePropertyChange("segment", evt.getOldValue(), evt.getNewValue());
        }
    };
    private PropertyChangeListener K = new SerializablePropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            PolyLine.this.handleNodePropertyChange(evt);
        }
    };

    protected void handleNodePropertyChange(PropertyChangeEvent evt) {
        if (this.isShapeFrozen()) {
            return;
        }
        if (evt.getPropertyName().equals("location")) {
            this.firePropertyChange("segment", evt.getOldValue(), evt.getNewValue());
        }
    }

    public PolyLine() {
    }

    public PolyLine(Object id) {
        super(id);
    }

    public PolyLine(Node from, Node to) {
        this.setFrom(from);
        this.setTo(to);
    }

    public PolyLine(Object id, Node from, Node to) {
        super(id);
        this.setFrom(from);
        this.setTo(to);
    }

    public boolean isAdjustToBottom() {
        return true;
    }

    public void addBranch(Branch branch) {
        if (this.branchs.contains(branch)) {
            return;
        }
        branch.getPropertyChangeSupport().addPropertyChangeListener(this.L);
        this.branchs.add(branch);
        branch.A(this);
        List branchSegments = branch.getSegments();
        for (int i2 = 0; i2 < branchSegments.size(); ++i2) {
            Segment segment = (Segment)branchSegments.get(i2);
            this.addSegment(segment);
        }
    }

    public void removeBranch(Branch branch) {
        if (branch == this.blinkingObject) {
            this.setBlinkingObject(null);
        }
        branch.getPropertyChangeSupport().removePropertyChangeListener(this.L);
        this.branchs.remove(branch);
        branch.A(null);
        List branchSegments = branch.getSegments();
        for (int i2 = 0; i2 < branchSegments.size(); ++i2) {
            Segment segment = (Segment)branchSegments.get(i2);
            this.removeSegment(segment);
        }
    }

    public void clearBranchs() {
        while (this.branchs.size() > 0) {
            this.removeBranch((Branch)this.branchs.get(0));
        }
    }

    public void setBranchs(List branchs) {
        this.clearBranchs();
        for (int i2 = 0; i2 < branchs.size(); ++i2) {
            this.addBranch((Branch)branchs.get(i2));
        }
    }

    public void setSegments(List segments) {
        this.clearSegments();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            this.addSegment((Segment)segments.get(i2));
        }
    }

    public void clearSegments() {
        while (this.segments.size() > 0) {
            this.removeSegment((Segment)this.segments.get(0));
        }
    }

    public void addSegment(Segment segment) {
        if (this.segments.contains(segment)) {
            return;
        }
        this.segments.add(segment);
        segment.setPolyLine(this);
        segment.getPropertyChangeSupport().addPropertyChangeListener(this.J);
        Node node = segment.getFromNode();
        if (node != null) {
            node.removePropertyChangeListener(this.K);
            node.addPropertyChangeListener(this.K);
        }
        if ((node = segment.getToNode()) != null) {
            node.removePropertyChangeListener(this.K);
            node.addPropertyChangeListener(this.K);
        }
        this.firePropertyChange("segment", null, segment);
    }

    public void removeSegment(Segment segment) {
        if (segment == this.blinkingObject) {
            this.setBlinkingObject(null);
        }
        this.segments.remove(segment);
        segment.setPolyLine(null);
        segment.getPropertyChangeSupport().removePropertyChangeListener(this.J);
        Node node = segment.getFromNode();
        if (node != null) {
            node.removePropertyChangeListener(this.K);
        }
        if ((node = segment.getToNode()) != null) {
            node.removePropertyChangeListener(this.K);
        }
        this.firePropertyChange("segment", segment, null);
    }

    public void insertSegment(int index, Segment segment) {
        if (this.segments.contains(segment)) {
            return;
        }
        this.segments.add(index, segment);
        segment.setPolyLine(this);
        segment.getPropertyChangeSupport().addPropertyChangeListener(this.J);
        Node node = segment.getFromNode();
        if (node != null) {
            node.removePropertyChangeListener(this.K);
            node.addPropertyChangeListener(this.K);
        }
        if ((node = segment.getToNode()) != null) {
            node.removePropertyChangeListener(this.K);
            node.addPropertyChangeListener(this.K);
        }
        this.firePropertyChange("segment", null, segment);
    }

    public List getAllNodes() {
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i2 = 0; i2 < this.segments.size(); ++i2) {
            Segment segment = (Segment)this.segments.get(i2);
            Node node = segment.getFromNode();
            if (node != null && !list.contains(node)) {
                list.add(node);
            }
            if ((node = segment.getToNode()) == null || list.contains(node)) continue;
            list.add(node);
        }
        return list;
    }

    public List getOrderSegments() {
        if (this.branchs.size() == 0) {
            return this.getSegments();
        }
        ArrayList segments = new ArrayList();
        for (int i2 = 0; i2 < this.branchs.size(); ++i2) {
            Branch branch = (Branch)this.branchs.get(i2);
            segments.addAll(branch.getSegments());
        }
        return segments;
    }

    public String getUIClassID() {
        return "PolyLineUI";
    }

    public String getSVGUIClassID() {
        return "PolyLineSVGUI";
    }

    public List getSegments() {
        return this.segments;
    }

    public List getBranchs() {
        return this.branchs;
    }

    public Object getBlinkingObject() {
        return this.blinkingObject;
    }

    public void setBlinkingObject(Object blinkingObject) {
        Object oldValue = this.blinkingObject;
        this.blinkingObject = blinkingObject;
        this.firePropertyChange("blinkingObject", oldValue, this.blinkingObject);
    }

    public boolean isBlinking(Segment segment) {
        if (this.blinkingObject != null) {
            if (this.blinkingObject == this) {
                return true;
            }
            if (segment == this.blinkingObject) {
                return true;
            }
            if (segment.getBranch() == this.blinkingObject) {
                return true;
            }
        }
        return false;
    }
}

