/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.element.TDataBoxPropertyChangeAdapter;
import com.nepxion.cots.twaver.element.TDataBoxSelectionAdapter;
import com.nepxion.cots.twaver.element.TDataBoxUndoRedoAdapter;
import com.nepxion.cots.twaver.element.TElement;
import com.nepxion.cots.twaver.element.TGroup;
import com.nepxion.cots.twaver.element.TGroupType;
import com.nepxion.cots.twaver.element.TLink;
import com.nepxion.cots.twaver.element.TNode;
import com.nepxion.cots.twaver.graph.TExportDataConfig;
import com.nepxion.cots.twaver.graph.TExportImageConfig;
import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TGraphControlBar;
import com.nepxion.cots.twaver.graph.TGraphScaleBar;
import com.nepxion.cots.twaver.graph.TInternalFrame;
import com.nepxion.cots.twaver.graph.TLayouterBar;
import com.nepxion.cots.twaver.graph.TOverview;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.checkbox.JCheckBoxSelector;
import com.nepxion.swing.selector.file.JFileFilter;
import com.nepxion.swing.selector.file.JFileSelector;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.data.CollectionUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.filechooser.FileFilter;
import twaver.DataBoxOutputSetting;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.DataBoxSelectionModel;
import twaver.DoubleClickableFilter;
import twaver.EditableFilter;
import twaver.Element;
import twaver.ElementPersistentFilter;
import twaver.Generator;
import twaver.Link;
import twaver.MovableFilter;
import twaver.ResizableFilter;
import twaver.SubNetworkPersistentFilter;
import twaver.TDataBox;
import twaver.TSubNetwork;
import twaver.TUIManager;
import twaver.UndoRedoListener;
import twaver.VisibleFilter;
import twaver.network.InteractionEvent;
import twaver.network.InteractionModeFactory;
import twaver.network.TNetwork;

public class TGraphManager {
    public static void select(TGraph graph) {
        graph.setInteractionMode(InteractionModeFactory.getDefaultMode((TNetwork)graph));
    }

    public static void layzMove(TGraph graph) {
        graph.setInteractionMode(InteractionModeFactory.getDefaultLazySelectionMode((TNetwork)graph));
    }

    public static void pan(TGraph graph) {
        graph.setInteractionMode(InteractionModeFactory.getPanMode((TNetwork)graph));
        graph.getCanvas().setCursor(TGraph.PAN_CURSOR);
    }

    public static void zoomIn(TGraph graph) {
        graph.getZoomer().zoomIn();
    }

    public static void zoomOut(TGraph graph) {
        graph.getZoomer().zoomOut();
    }

    public static void zoomInRectangle(TGraph graph) {
        graph.setInteractionMode(InteractionModeFactory.getZoomToRectMode((TNetwork)graph));
        graph.getCanvas().setCursor(TGraph.ZOOM_IN_RECTANGLE_CURSOR);
    }

    public static void zoomReset(TGraph graph) {
        graph.getZoomer().zoomReset();
    }

    public static void zoomBack(TGraph graph) {
        graph.zoomBack();
    }

    public static void zoomToOverview(TGraph graph) {
        graph.getZoomer().zoomToOverview(10, 10);
    }

    public static void fullScreen(TGraph graph) {
        graph.toggleFullScreen();
    }

    public static void magnifier(TGraph graph) {
        graph.setInteractionMode(InteractionModeFactory.getMagnifierMode((TNetwork)graph));
    }

    public static void setMagnifierShape(TGraph graph, Shape shape) {
        graph.getMagnifier().setShape(shape);
    }

    public static void delete(TGraph graph) {
        int selectedValue;
        DataBoxSelectionModel dataBoxSelectionModel = graph.getDataBox().getSelectionModel();
        if (dataBoxSelectionModel.size() > 0 && (selectedValue = JBasicOptionPane.showConfirmDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("element_delete_confirm"), (String)SwingLocale.getString((String)"confirm"), (int)0)) == 0) {
            List allSelectedElement = dataBoxSelectionModel.getAllSelectedElement();
            for (TElement element : allSelectedElement) {
                if (element.isDeletePermitted()) continue;
                JBasicOptionPane.showMessageDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)(TLocale.getString("element") + " " + element.toString() + " " + TLocale.getString("element_delete_denied")), (String)SwingLocale.getString((String)"error"), (int)2);
                return;
            }
            graph.getDataBox().removeSelectedElements();
            graph.adjustCanvasSize();
            InteractionEvent event = new InteractionEvent((Object)allSelectedElement, 14);
            graph.fireInteractionPerformed(event);
        }
    }

    public static void clear(TGraph graph) {
        int selectedValue;
        if (graph.getDataBox().getAllElements().size() != 0 && (selectedValue = JBasicOptionPane.showConfirmDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("element_clear_confirm"), (String)SwingLocale.getString((String)"confirm"), (int)0)) == 0) {
            graph.getDataBox().clear();
        }
    }

    public static void copy(TGraph graph) {
        graph.getDataBox().copySelection();
    }

    public static void paste(TGraph graph) {
        graph.pasteElements();
    }

    public static void rename(TGraph graph) {
        if (graph.getDataBox().getSelectionModel().size() != 1) {
            return;
        }
        Element element = graph.getDataBox().getLastSelectedElement();
        graph.startEditingAtElement(element);
    }

    public static void selectAll(TGraph graph) {
        graph.getDataBox().selectAll();
    }

    public static void undo(TGraph graph) {
        graph.getDataBox().getUndoRedoManager().undo();
    }

    public static void redo(TGraph graph) {
        graph.getDataBox().getUndoRedoManager().redo();
    }

    public static void alignLeft(TGraph graph) {
        graph.getDataBox().alignLeftSelection();
    }

    public static void alignVerticalCenter(TGraph graph) {
        graph.getDataBox().alignCenterSelection();
    }

    public static void alignRight(TGraph graph) {
        graph.getDataBox().alignRightSelection();
    }

    public static void alignTop(TGraph graph) {
        graph.getDataBox().alignTopSelection();
    }

    public static void alignHorizontalCenter(TGraph graph) {
        graph.getDataBox().alignMiddleSelection();
    }

    public static void alignBottom(TGraph graph) {
        graph.getDataBox().alignBottomSelection();
    }

    public static void pileToLeft(TGraph graph) {
        graph.getDataBox().leftPileSelection();
    }

    public static void pileToRight(TGraph graph) {
        graph.getDataBox().rightPileSelection();
    }

    public static void pileToTop(TGraph graph) {
        graph.getDataBox().topPileSelection();
    }

    public static void pileToBottom(TGraph graph) {
        graph.getDataBox().bottomPileSelection();
    }

    public static void sameWidth(TGraph graph) {
        graph.getDataBox().sameWidthSelection();
    }

    public static void sameHeight(TGraph graph) {
        graph.getDataBox().sameHeightSelection();
    }

    public static void sameHorizontalSpace(TGraph graph) {
        graph.getDataBox().evenHSpaceSelection();
    }

    public static void sameVerticalSpace(TGraph graph) {
        graph.getDataBox().evenVSpaceSelection();
    }

    public static void moveToTop(TGraph graph) {
        Iterator iterator = graph.getDataBox().selection();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            graph.getDataBox().sendToTop(element);
        }
    }

    public static void moveToBottom(TGraph graph) {
        Iterator iterator = graph.getDataBox().selection();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            graph.getDataBox().sendToBottom(element);
        }
    }

    public static void lockSelection(TGraph graph) {
        for (Object object : graph.getSelectionModel().getAllSelectedElement()) {
            TGraphManager.lockSelection(object);
        }
    }

    public static void lockSelection(Object object) {
        if (object instanceof TNode) {
            TNode node;
            node.setMovable(!(node = (TNode)object).isMovable());
        } else if (object instanceof TGroup) {
            TGroup group;
            group.setMovable(!(group = (TGroup)object).isMovable());
            for (Object childObject : group.getChildren()) {
                TGraphManager.lockSelection(childObject);
            }
        }
    }

    public static void lockSelection(TGraph graph, boolean isMovable) {
        for (Object object : graph.getSelectionModel().getAllSelectedElement()) {
            TGraphManager.lockSelection(object, isMovable);
        }
    }

    public static void lockSelection(Object object, boolean isMovable) {
        if (object instanceof TNode) {
            TNode node = (TNode)object;
            node.setMovable(isMovable);
        } else if (object instanceof TGroup) {
            TGroup group = (TGroup)object;
            group.setMovable(isMovable);
            for (Object childObject : group.getChildren()) {
                TGraphManager.lockSelection(childObject, isMovable);
            }
        }
    }

    public static void hideChildren(TGraph graph) {
        for (Object object : graph.getSelectionModel().getAllSelectedElement()) {
            TNode node;
            if (!(object instanceof TNode)) continue;
            node.setChildrenHidden(!(node = (TNode)object).isChildrenHidden());
        }
        graph.getCanvas().repaint();
    }

    public static void setGroupType(TGraph graph, TGroupType groupType) {
        Iterator iterator = graph.getDataBox().iteratorReverse();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof TGroup)) continue;
            TGroup group = (TGroup)element;
            group.setGroupType(groupType.getType());
        }
    }

    public static void setGroupExpand(TGraph graph, boolean isExpand) {
        Iterator iterator = graph.getDataBox().iteratorReverse();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof TGroup)) continue;
            TGroup group = (TGroup)element;
            group.setExpand(isExpand);
        }
    }

    public static void setLinkVisible(TGraph graph, boolean isVisible) {
        Iterator iterator = graph.getDataBox().iteratorReverse();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof TLink)) continue;
            TLink link = (TLink)element;
            link.setVisible(isVisible);
        }
    }

    public static void addDataBoxChangeListener(TGraph graph) {
        graph.addPropertyChangeListener("databox", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TDataBox oldDataBox = (TDataBox)e.getOldValue();
                TDataBox newDataBox = (TDataBox)e.getNewValue();
                if (oldDataBox != null && newDataBox != null) {
                    TGraphManager.fireDataBoxChangeEvent(oldDataBox, newDataBox);
                }
            }
        });
    }

    public static void fireDataBoxChangeEvent(TDataBox oldDataBox, TDataBox newDataBox) {
        List selectionListeners = oldDataBox.getSelectionModel().getDataBoxSelectionListeners();
        for (Object selectionAdapterObject : selectionListeners) {
            if (!(selectionAdapterObject instanceof TDataBoxSelectionAdapter)) continue;
            TDataBoxSelectionAdapter selectionAdapter = (TDataBoxSelectionAdapter)((Object)selectionAdapterObject);
            oldDataBox.getSelectionModel().removeDataBoxSelectionListener((DataBoxSelectionListener)selectionAdapter);
            newDataBox.getSelectionModel().addDataBoxSelectionListener((DataBoxSelectionListener)selectionAdapter);
        }
        List undoRedoListeners = oldDataBox.getUndoRedoManager().getUndoRedoListeners();
        for (Object undoRedoAdapterObject : undoRedoListeners) {
            if (!(undoRedoAdapterObject instanceof TDataBoxUndoRedoAdapter)) continue;
            TDataBoxUndoRedoAdapter undoRedoAdapter = (TDataBoxUndoRedoAdapter)undoRedoAdapterObject;
            oldDataBox.getUndoRedoManager().removeUndoRedoListener((UndoRedoListener)undoRedoAdapter);
            newDataBox.getUndoRedoManager().addUndoRedoListener((UndoRedoListener)undoRedoAdapter);
            undoRedoAdapter.enableButton();
        }
        newDataBox.getUndoRedoManager().setLimit(200);
    }

    public static void fireElementPropertyChangeEvent(TDataBox oldDataBox, TDataBox newDataBox) {
        List elementPropertyChangeListeners = oldDataBox.getElementPropertyChangeListeners();
        for (Object elementPropertyAdapterObject : elementPropertyChangeListeners) {
            if (!(elementPropertyAdapterObject instanceof TDataBoxPropertyChangeAdapter)) continue;
            TDataBoxPropertyChangeAdapter propertyChangeAdapter = (TDataBoxPropertyChangeAdapter)elementPropertyAdapterObject;
            oldDataBox.removeElementPropertyChangeListener((PropertyChangeListener)propertyChangeAdapter);
            newDataBox.addElementPropertyChangeListener((PropertyChangeListener)propertyChangeAdapter);
        }
    }

    public static void addCanvasAdjustListener(final TGraph graph) {
        graph.getCanvas().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i = 0; i < graph.getLayeredPane().getComponentCount(); ++i) {
                    Component component = graph.getLayeredPane().getComponent(i);
                    if (!(component instanceof JInternalFrame)) continue;
                    graph.adjustComponentPosition((JInternalFrame)component);
                }
            }
        });
    }

    public static void setElementSelectColorGenerator(TGraph graph, final Color nodeColor, final Color linkColor) {
        graph.setElementSelectColorGenerator(new Generator(){

            public Object generate(Object element) {
                if (element instanceof TNode || element instanceof TGroup) {
                    return nodeColor;
                }
                if (element instanceof TLink) {
                    return linkColor;
                }
                return null;
            }
        });
    }

    public static void addElementSelectionListener(TGraph graph, final String nodeImage, final String nodeSelectionImage, final Color linkColor, final Color linkSelectionColor) {
        new TDataBoxSelectionAdapter(graph.getDataBox()){

            @Override
            public void selectionChanged(DataBoxSelectionEvent e) {
                for (Element element : e.getElements()) {
                    if (element instanceof TNode || element instanceof TGroup) {
                        if (element.isSelected()) {
                            element.setImage(nodeSelectionImage);
                            element.setIcon(nodeSelectionImage);
                            continue;
                        }
                        element.setImage(nodeImage);
                        element.setIcon(nodeImage);
                        continue;
                    }
                    if (!(element instanceof TLink)) continue;
                    if (element.isSelected()) {
                        element.putClientProperty((Object)"link.color", (Object)linkSelectionColor);
                        continue;
                    }
                    element.putClientProperty((Object)"link.color", (Object)linkColor);
                }
            }
        };
    }

    public static void addNodeSelectionListener(TGraph graph, final String nodeImage, final String nodeSelectionImage) {
        new TDataBoxSelectionAdapter(graph.getDataBox()){

            @Override
            public void selectionChanged(DataBoxSelectionEvent e) {
                for (Element element : e.getElements()) {
                    if (!(element instanceof TNode) && !(element instanceof TGroup)) continue;
                    if (element.isSelected()) {
                        element.setImage(nodeSelectionImage);
                        element.setIcon(nodeSelectionImage);
                        continue;
                    }
                    element.setImage(nodeImage);
                    element.setIcon(nodeImage);
                }
            }
        };
    }

    public static void addLinkSelectionListener(TGraph graph, final Color linkSelectionColor) {
        new TDataBoxSelectionAdapter(graph.getDataBox()){

            @Override
            public void selectionChanged(DataBoxSelectionEvent e) {
                for (Element element : e.getElements()) {
                    if (!(element instanceof TLink)) continue;
                    if (element.isSelected()) {
                        element.putClientProperty((Object)"link.color", (Object)linkSelectionColor);
                        continue;
                    }
                    TLink link = (TLink)element;
                    if (link.isHighLightable()) {
                        element.putClientProperty((Object)"link.color", (Object)link.getHighLightColor());
                        continue;
                    }
                    element.putClientProperty((Object)"link.color", TUIManager.get((String)"link.color"));
                }
            }
        };
    }

    public static void setDoubleClickableFilter(TGraph graph, final boolean nodeFiltable, final boolean linkFiltable) {
        graph.setDoubleClickableFilter(new DoubleClickableFilter(){

            public boolean isDoubleClickable(Element element) {
                if (element instanceof TNode || element instanceof TGroup) {
                    return nodeFiltable;
                }
                if (element instanceof TLink) {
                    return linkFiltable;
                }
                return true;
            }
        });
    }

    public static void setMovable(TGraph graph, boolean isMovable) {
        if (!isMovable) {
            TGraphManager.addMovableFilter(graph, isMovable);
        } else {
            graph.clearMovableFilters();
        }
    }

    public static void addMovableFilter(TGraph graph, final boolean isMovable) {
        graph.addMovableFilter(new MovableFilter(){

            public boolean isMovable(Element element) {
                return isMovable;
            }
        });
    }

    public static void setElementLabelEditable(TGraph graph, final boolean isEditable) {
        graph.setElementLabelEditableFilter(new EditableFilter(){

            public boolean isEditable(Element element) {
                return isEditable;
            }
        });
    }

    public static void setResizableFilter(TGraph graph, final boolean isResizable) {
        graph.setResizableFilter(new ResizableFilter(){

            public boolean isResizable(Element element) {
                return isResizable;
            }
        });
    }

    public static void addVisibleFilter(final TGraph graph) {
        graph.addVisibleFilter(new VisibleFilter(){

            public boolean isVisible(Element element) {
                Element parent = element.getParent();
                if (parent instanceof TNode && ((TNode)parent).isChildrenHidden()) {
                    return false;
                }
                if (parent != null && !(parent instanceof Link)) {
                    return graph.isVisible(parent);
                }
                return true;
            }
        });
    }

    public static void toggleControlBar(TGraph graph, boolean isVisible) {
        TInternalFrame controlBarInternalFrame = graph.getControlBarInternalFrame();
        if (controlBarInternalFrame == null) {
            TGraphControlBar controlBar = new TGraphControlBar(graph);
            controlBar.setPreferredSize(new Dimension(90, 310));
            controlBarInternalFrame = new TInternalFrame(graph, TLocale.getString("operation_pane"), TIconFactory.getContextIcon("pane.png"), (Component)((Object)controlBar));
            controlBarInternalFrame.setLocation(0, 0);
            controlBarInternalFrame.setHorizontalTweening(false);
            controlBarInternalFrame.setVerticalTweening(true);
            controlBarInternalFrame.setTweeningDimension(controlBarInternalFrame.getSize());
            graph.getLayeredPane().add(controlBarInternalFrame);
            graph.setControlBarInternalFrame(controlBarInternalFrame);
        }
        if (isVisible) {
            controlBarInternalFrame.tween(true);
        } else {
            controlBarInternalFrame.tween(false);
        }
    }

    public static void scale(TGraph graph) {
        TInternalFrame scaleInternalFrame = graph.getScaleInternalFrame();
        if (scaleInternalFrame == null) {
            TGraphScaleBar scaleBar = new TGraphScaleBar(graph);
            scaleBar.setPreferredSize(new Dimension(230, 20));
            scaleInternalFrame = new TInternalFrame(graph, TLocale.getString("graph_scale"), TIconFactory.getContextIcon("scale.png"), (Component)((Object)scaleBar));
            scaleInternalFrame.setResizable(false);
            scaleInternalFrame.setLocation(0, graph.getViewport().getHeight() - scaleInternalFrame.getHeight() + 2);
            scaleInternalFrame.setHorizontalTweening(true);
            scaleInternalFrame.setVerticalTweening(false);
            scaleInternalFrame.setTweeningDimension(scaleInternalFrame.getSize());
            graph.getLayeredPane().add(scaleInternalFrame);
            graph.setScaleInternalFrame(scaleInternalFrame);
        }
        if (!scaleInternalFrame.isVisible()) {
            scaleInternalFrame.tween(true);
        } else {
            scaleInternalFrame.tween(false);
        }
    }

    public static void overview(TGraph graph) {
        TOverview overview = graph.getOverview();
        if (overview == null) {
            overview = new TOverview(graph, TLocale.getString("graph_overview"), new Dimension(150, 150), TIconFactory.getContextIcon("overview.png"));
            overview.setLocation(graph.getViewport().getWidth() - overview.getWidth() + 2, graph.getViewport().getHeight() - overview.getHeight() + 2);
            overview.setHorizontalTweening(true);
            overview.setVerticalTweening(true);
            overview.setTweeningDimension(overview.getSize());
            graph.getLayeredPane().add((Component)((Object)overview));
            graph.setOverview(overview);
        }
        if (!overview.isVisible()) {
            overview.tween(true);
        } else {
            overview.tween(false);
        }
        if (overview.isVisible()) {
            graph.adjustComponentPosition((JComponent)((Object)overview));
        }
    }

    public static void layout(TGraph graph) {
        TInternalFrame layoutInternalFrame = graph.getLayoutInternalFrame();
        if (layoutInternalFrame == null) {
            TLayouterBar layouterBar = new TLayouterBar(graph);
            layouterBar.setPreferredSize(new Dimension(225, 295));
            layoutInternalFrame = new TInternalFrame(graph, TLocale.getString("layout"), TIconFactory.getContextIcon("layout.png"), (Component)((Object)layouterBar));
            layoutInternalFrame.setResizable(false);
            layoutInternalFrame.setLocation(graph.getViewport().getWidth() - layoutInternalFrame.getPreferredSize().width + 2, 0);
            layoutInternalFrame.setHorizontalTweening(false);
            layoutInternalFrame.setVerticalTweening(true);
            layoutInternalFrame.setTweeningDimension(layoutInternalFrame.getSize());
            graph.getLayeredPane().add(layoutInternalFrame);
            graph.setLayoutInternalFrame(layoutInternalFrame);
        }
        if (!layoutInternalFrame.isVisible()) {
            layoutInternalFrame.tween(true);
        } else {
            layoutInternalFrame.tween(false);
        }
    }

    public static void importXML(final TGraph graph) {
        File file;
        JFileSelector fileSelector = graph.getImportDataFileSelector();
        if (fileSelector == null) {
            List xmlFilterWords = CollectionUtil.parseList((Object[])new String[]{"xml"});
            String xmlFilterDescription = "XML File(*.xml)";
            JFileFilter xmlFileFilter = new JFileFilter(xmlFilterWords, xmlFilterDescription);
            fileSelector = new JFileSelector((Component)HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("import_data_description"));
            fileSelector.addChoosableFileFilter((FileFilter)xmlFileFilter);
            fileSelector.setFileFilter((FileFilter)xmlFileFilter);
            graph.setImportDataFileSelector(fileSelector);
        }
        if ((file = fileSelector.openFile()) != null) {
            if (graph.getDataBox().size() != 0) {
                int selectedValue = JBasicOptionPane.showConfirmDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("import_confirm"), (String)SwingLocale.getString((String)"confirm"), (int)1);
                if (selectedValue == 0) {
                    graph.getDataBox().clear();
                } else if (selectedValue == 2) {
                    return;
                }
            }
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("import_data_description"), SwingLocale.getString((String)"export_and_wait")){

                protected void loadForeground(Object data) throws Exception {
                    try {
                        TSubNetwork currentSubNetwork = graph.getCurrentSubNetwork();
                        graph.getDataBox().parse(file.toURI().toString(), (Element)currentSubNetwork);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    JBasicOptionPane.showMessageDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("import_data_description"), (String)SwingLocale.getString((String)"information"), (int)1);
                }

                protected Object loadBackground() throws Exception {
                    return null;
                }
            };
            dialog.execute();
        }
    }

    public static void exportXML(final TGraph graph) {
        TExportDataConfig exportDataConfig = graph.getExportDataConfig();
        if (exportDataConfig == null) {
            exportDataConfig = new TExportDataConfig(graph);
            graph.setExportDataConfig(exportDataConfig);
        }
        JCheckBoxSelector selector = exportDataConfig.getSelector();
        selector.setVisible(true);
        selector.dispose();
        if (selector.getSelectedElementNodes() == null || !selector.isConfirmed()) {
            return;
        }
        JFileSelector fileSelector = graph.getExportDataFileSelector();
        if (fileSelector == null) {
            List xmlFilterWords = CollectionUtil.parseList((Object[])new String[]{"xml"});
            String xmlFilterDescription = "XML File(*.xml)";
            JFileFilter xmlFileFilter = new JFileFilter(xmlFilterWords, xmlFilterDescription);
            fileSelector = new JFileSelector((Component)HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_data_description"));
            fileSelector.addChoosableFileFilter((FileFilter)xmlFileFilter);
            fileSelector.setFileFilter((FileFilter)xmlFileFilter);
            graph.setExportDataFileSelector(fileSelector);
        }
        final boolean isSaveElementID = exportDataConfig.isSaveElementID();
        final boolean isSaveLayers = exportDataConfig.isSaveLayers();
        final boolean isSaveAlarmState = exportDataConfig.isSaveAlarmState();
        final boolean isSaveCurrentSubNetwork = exportDataConfig.isSaveCurrentSubNetwork();
        final String filePath = fileSelector.saveFile(graph.getDataBox().getName());
        if (filePath != null) {
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_data_description"), SwingLocale.getString((String)"export_and_wait")){

                protected void loadForeground(Object data) throws Exception {
                    JBasicOptionPane.showMessageDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("export_data_successfully"), (String)SwingLocale.getString((String)"information"), (int)1);
                }

                protected Object loadBackground() throws Exception {
                    try {
                        DataBoxOutputSetting setting = new DataBoxOutputSetting();
                        setting.setWithElementId(isSaveElementID);
                        setting.setWithAlarmState(isSaveAlarmState);
                        setting.setWithLayers(isSaveLayers);
                        if (isSaveCurrentSubNetwork) {
                            TSubNetwork subNetwork = graph.getCurrentSubNetwork();
                            setting.setElementFilter((ElementPersistentFilter)new SubNetworkPersistentFilter(subNetwork));
                        }
                        graph.getDataBox().output(filePath, setting);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    return null;
                }
            };
            dialog.execute();
        }
    }

    public static void exportSVG(final TGraph graph) {
        String filePath;
        JFileSelector fileSelector = graph.getSVGFileSelector();
        if (fileSelector == null) {
            List svgFilterWords = CollectionUtil.parseList((Object[])new String[]{"svg"});
            String svgFilterDescription = "SVG File(*.svg)";
            JFileFilter svgFileFilter = new JFileFilter(svgFilterWords, svgFilterDescription);
            fileSelector = new JFileSelector((Component)HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_vector_description"));
            fileSelector.addChoosableFileFilter((FileFilter)svgFileFilter);
            fileSelector.setFileFilter((FileFilter)svgFileFilter);
            graph.setSVGFileSelector(fileSelector);
        }
        if ((filePath = fileSelector.saveFile(graph.getDataBox().getName())) != null) {
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_vector_description"), SwingLocale.getString((String)"export_and_wait")){

                protected void loadForeground(Object data) throws Exception {
                    JBasicOptionPane.showMessageDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("export_vector_successfully"), (String)SwingLocale.getString((String)"information"), (int)1);
                }

                protected Object loadBackground() throws Exception {
                    try {
                        graph.exportSVG(filePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    return null;
                }
            };
            dialog.execute();
        }
    }

    public static void exportImage(final TGraph graph) {
        TExportImageConfig exportImageConfig = graph.getExportImageConfig();
        if (exportImageConfig == null) {
            exportImageConfig = new TExportImageConfig(graph);
            exportImageConfig.setPreferredSize(new Dimension(250, 250));
            graph.setExportImageConfig(exportImageConfig);
        }
        exportImageConfig.setZoom();
        int selectedValue = JBasicOptionPane.showDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)exportImageConfig, (String)TLocale.getString("export_image_setting"), (Icon)IconFactory.getSwingIcon((String)"banner/image.png"));
        if (selectedValue != 0) {
            return;
        }
        JFileSelector fileSelector = graph.getImageFileSelector();
        if (fileSelector == null) {
            List jpgFilterWords = CollectionUtil.parseList((Object[])new String[]{"jpg"});
            String jpgFilterDescription = "JPG File(*.jpg)";
            JFileFilter jpgFileFilter = new JFileFilter(jpgFilterWords, jpgFilterDescription);
            List jpegFilterWords = CollectionUtil.parseList((Object[])new String[]{"jpeg"});
            String jpegFilterDescription = "JPEG File(*.jpeg)";
            JFileFilter jpegFileFilter = new JFileFilter(jpegFilterWords, jpegFilterDescription);
            List pngFilterWords = CollectionUtil.parseList((Object[])new String[]{"png"});
            String pngFilterDescription = "PNG File(*.png)";
            JFileFilter pngFileFilter = new JFileFilter(pngFilterWords, pngFilterDescription);
            fileSelector = new JFileSelector((Component)HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_image_description"));
            fileSelector.addChoosableFileFilter((FileFilter)jpgFileFilter);
            fileSelector.addChoosableFileFilter((FileFilter)jpegFileFilter);
            fileSelector.addChoosableFileFilter((FileFilter)pngFileFilter);
            fileSelector.setFileFilter((FileFilter)jpgFileFilter);
            graph.setImageFileSelector(fileSelector);
        }
        final boolean isSaveWhole = exportImageConfig.isSaveWhole();
        final boolean isSaveElement = exportImageConfig.isSaveElement();
        final double zoom = exportImageConfig.getZoom();
        final int margin = exportImageConfig.getMargin();
        final String filePath = fileSelector.saveFile(graph.getDataBox().getName());
        final String formatName = fileSelector.getFileFilter().getDescription();
        if (filePath != null) {
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame((Component)((Object)graph)), TLocale.getString("export_image_description"), SwingLocale.getString((String)"export_and_wait")){

                protected void loadForeground(Object data) throws Exception {
                    JBasicOptionPane.showMessageDialog((Component)HandleManager.getFrame((Component)((Object)graph)), (Object)TLocale.getString("export_image_successfully"), (String)SwingLocale.getString((String)"information"), (int)1);
                }

                protected Object loadBackground() throws Exception {
                    try {
                        if (isSaveWhole) {
                            graph.exportImage(filePath, formatName, zoom);
                        } else if (isSaveElement) {
                            graph.exportImageCoverElements(filePath, formatName, margin, zoom);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                    return null;
                }
            };
            dialog.execute();
        }
    }

    public static void print(TGraph graph) {
        graph.getPrinter().preview();
    }
}

