/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.toggle;

import com.nepxion.swing.toggle.IToggleContentPanel;
import com.nepxion.swing.toggle.ITogglePanel;
import com.nepxion.swing.toggle.JThreadTogglePanel;
import com.nepxion.swing.tree.toggle.IToggleAdapter;
import com.nepxion.swing.tree.toggle.IToggleTree;
import javax.swing.tree.TreeNode;

public abstract class AbstractToggleAdapter
implements IToggleAdapter {
    private IToggleTree toggleTree;

    public AbstractToggleAdapter(IToggleTree toggleTree) {
        this.toggleTree = toggleTree;
        this.toggleTree.setToggleAdapter(this);
    }

    @Override
    public void invoke(TreeNode oldSelectionTreeNode, TreeNode newSelectionTreeNode) {
        if (newSelectionTreeNode == null) {
            return;
        }
        IToggleContentPanel toggleContentPanel = this.toggleTree.getToggleContentPanel();
        if (toggleContentPanel == null) {
            return;
        }
        ITogglePanel togglePanel = this.getTogglePanel(newSelectionTreeNode);
        if (togglePanel == null) {
            return;
        }
        if (togglePanel.getToggleText() == null) {
            String text = newSelectionTreeNode.toString();
            togglePanel.setToggleText(text);
        }
        if (togglePanel.getToggleDescription() == null) {
            String description = this.toggleTree.getTreeNavigator().getURL(newSelectionTreeNode);
            togglePanel.setToggleDescription(description);
        }
        toggleContentPanel.toggle(togglePanel);
        if (togglePanel instanceof JThreadTogglePanel) {
            JThreadTogglePanel threadTogglePanel = (JThreadTogglePanel)togglePanel;
            threadTogglePanel.execute();
        }
    }

    public IToggleTree getToggleTree() {
        return this.toggleTree;
    }

    public abstract ITogglePanel getTogglePanel(TreeNode var1);
}

