/*
 * Decompiled with CFR 0.152.
 */
package twaver.table;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import twaver.AlarmSeverity;
import twaver.AlarmSeverityChangeListener;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.C.M;
import twaver.base.A.E.Z;
import twaver.base.A.J.A.A;
import twaver.base.A.J.A.B;
import twaver.base.A.J.A.C;
import twaver.base.A.J.A.D;
import twaver.base.A.J.A.E;
import twaver.base.A.J.A.F;
import twaver.base.A.J.A.G;
import twaver.table.CellEditorManager;
import twaver.table.CellRendererManager;
import twaver.table.ColumnVisibleFilter;
import twaver.table.ResizableTable;
import twaver.table.TTableColumn;
import twaver.table.TTableListener;
import twaver.table.TTableModel;
import twaver.table.TTablePopupMenuFactory;
import twaver.table.TTableRowFilter;

public class TTable
extends ResizableTable {
    public static final String OID_COLUMN = "table.column.oid";
    public static final String CHECK_COLUMN = "table.column.check";
    public static final String TREE_COLUMN = "table.column.tree";
    static final String \u01db = TWaverUtil.getString("table.showAll");
    protected TTableModel tableModel;
    private TTablePopupMenuFactory \u01d9;
    private TTablePopupMenuFactory \u01df;
    private CellRendererManager \u01eb = new CellRendererManager();
    private CellEditorManager \u01ea = new CellEditorManager();
    private twaver.base.A.J.C \u01e6 = new twaver.base.A.J.C(this);
    private AlarmSeverityChangeListener \u01e7 = new AlarmSeverityChangeListener(){

        public boolean alarmSeverityChange() {
            TTable.this.repaint();
            return false;
        }
    };
    private boolean \u01e4 = TUIManager.getBoolean("tree.enable.right.click.event");
    private boolean \u01e5 = TUIManager.getBoolean("table.show.table.header.icon");
    private boolean \u01ed = TUIManager.getBoolean("table.sortable");
    private boolean \u01dc = TUIManager.getBoolean("table.local.sortable");
    private boolean \u01ec = TUIManager.getBoolean("table.multi.column.sortable");
    private boolean \u01ee = TUIManager.getBoolean("table.selectable.on.right.click");
    private boolean \u01e9 = TUIManager.getBoolean("table.clear.selection.on.margin.clicked");
    private boolean \u01dd = TUIManager.getBoolean("table.show.predefined.columns.in.popupmenu");
    private boolean \u01e2 = TUIManager.getBoolean("table.enable.tristate.sorting");
    private boolean \u01de = TUIManager.getBoolean("table.distinct.sortable.header");
    private ColumnVisibleFilter \u01e8 = null;
    private MouseEvent \u01e3 = null;
    private boolean \u01da = TUIManager.getBoolean("table.lazy.publish.mode");
    private boolean \u01e0 = false;
    private boolean \u01e1 = false;

    void O() {
        this.\u01e0 = true;
        this.repaint();
    }

    public void paint(Graphics g2) {
        this.cleanDirtyState();
        super.paint(g2);
    }

    public void cleanDirtyState() {
        if (this.\u01e0) {
            this.\u01e1 = true;
            this.tableModel.publishData();
            this.\u01e1 = false;
            this.\u01e0 = false;
        }
    }

    public boolean isPublishable() {
        if (this.tableModel.isLocked()) {
            return false;
        }
        if (!this.\u01e1 && this.isLazyPublishMode()) {
            this.O();
            return false;
        }
        return true;
    }

    public TTable() {
        this.N();
    }

    public TTable(String tableName) {
        this.N();
        this.tableModel.addColumns(M.J().B(tableName));
    }

    protected TTableModel createTTableModel() {
        return new TTableModel(this);
    }

    private void N() {
        this.tableModel = this.createTTableModel();
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        this.tableModel.publishColumn();
        this.setModel(this.tableModel);
        this.tableModel.A();
        this.tableModel.publishData();
        if (this.getTableHeader() != null) {
            this.getTableHeader().setDefaultRenderer(this.\u01e6);
        }
        this.setSelectionMode(2);
        this.\u01d9 = twaver.base.A.J.E.B;
        this.\u01df = twaver.base.A.J.F.A;
        AlarmSeverity.addAlarmSeverityChangeListener(this.\u01e7);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new twaver.base.A.J.B(this);
    }

    protected void initInputHandler() {
        new E(this);
        new B(this);
        new F(this);
        new A(this);
        new G(this);
        new C(this);
        new D(this);
    }

    public TTableModel getTableModel() {
        return this.tableModel;
    }

    protected boolean isEditable(int rowIndex) {
        return true;
    }

    public CellRendererManager getCellRendererManager() {
        return this.\u01eb;
    }

    public CellEditorManager getCellEditorManager() {
        return this.\u01ea;
    }

    public void packColumn(String columnName, boolean considerHeader) {
        TTableColumn column = this.getColumnByName(columnName);
        this.packColumn(column, considerHeader);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return Z.B(this, row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        return Z.A(this, row, column);
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.tableModel.getPublishedColumn().size() == 0) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public TTablePopupMenuFactory getTableBodyPopupMenuFactory() {
        return this.\u01df;
    }

    public void setTableBodyPopupMenuFactory(TTablePopupMenuFactory tableBodyPopupMenuFactory) {
        this.\u01df = tableBodyPopupMenuFactory;
    }

    public TTablePopupMenuFactory getTableHeaderPopupMenuFactory() {
        return this.\u01d9;
    }

    public void setTableHeaderPopupMenuFactory(TTablePopupMenuFactory tableHeadPopupMenuFactory) {
        this.\u01d9 = tableHeadPopupMenuFactory;
    }

    public boolean isSortable() {
        return this.\u01ed;
    }

    public void setSortable(boolean isSortable) {
        if (this.\u01ed == isSortable) {
            return;
        }
        this.\u01ed = isSortable;
        if (!this.\u01ed) {
            this.tableModel.reset();
        }
    }

    public void addColumns(List columnList) {
        this.tableModel.addColumns(columnList);
    }

    public void removeColumn(TableColumn column) {
        this.tableModel.removeColumn(column);
    }

    public void removeColumnByName(String columnName) {
        this.tableModel.removeColumnByName(columnName);
    }

    public TTableColumn getColumnByName(String name) {
        return this.tableModel.getColumnByName(name);
    }

    public TTableColumn getOIDColumn() {
        return this.tableModel.getColumnByName(OID_COLUMN);
    }

    public TTableColumn getCheckColumn() {
        return this.tableModel.getColumnByName(CHECK_COLUMN);
    }

    public TTableColumn getColumnByIndex(int columnIndex) {
        return (TTableColumn)this.getColumnModel().getColumn(columnIndex);
    }

    public Vector getRowDataByRowIndex(int rowIndex) {
        rowIndex = this.getTableModel().getFirstRowIndex() + rowIndex;
        Vector publishData = this.getTableModel().getPublishedData();
        if (rowIndex < 0 || rowIndex >= publishData.size()) {
            return null;
        }
        Vector rowData = (Vector)publishData.get(rowIndex);
        return rowData;
    }

    public boolean isMultiColumnSortable() {
        return this.\u01ec;
    }

    public void setMultiColumnSortable(boolean isMultiColumnSortable) {
        this.\u01ec = isMultiColumnSortable;
    }

    public void addRowFilter(TTableRowFilter rowFilter) {
        this.tableModel.addRowFilter(rowFilter);
    }

    public void removeRowFilter(TTableRowFilter rowFilter) {
        this.tableModel.removeRowFilter(rowFilter);
    }

    public void addTableListener(TTableListener l2) {
        this.tableModel.addTableListener(l2);
    }

    public void removeTableListener(TTableListener l2) {
        this.tableModel.removeTableListener(l2);
    }

    public boolean isSelectableOnRightClick() {
        return this.\u01ee;
    }

    public void setSelectableOnRightClick(boolean isSelectableOnRightClick) {
        this.\u01ee = isSelectableOnRightClick;
    }

    public boolean isClearSelectionOnMarginClicked() {
        return this.\u01e9;
    }

    public void setClearSelectionOnMarginClicked(boolean isClearSelectionOnMarginClicked) {
        this.\u01e9 = isClearSelectionOnMarginClicked;
    }

    public void ensureVisible(Vector rowData) {
        int page = this.tableModel.getPageIndex(rowData);
        if (page >= 0) {
            if (page != this.tableModel.getCurrentPageIndex()) {
                this.tableModel.setCurrentPageIndex(page);
            }
            int rowIndex = this.tableModel.getRowIndexAtPage(rowData);
            this.scrollRectToVisible(this.getCellRect(rowIndex, -1, false));
        }
    }

    public void ensureVisibleAtCurrentPage(Vector rowData) {
        int page = this.tableModel.getPageIndex(rowData);
        if (page == this.tableModel.getCurrentPageIndex()) {
            this.ensureVisible(rowData);
        }
    }

    public boolean isShowPredefinedColumnsInPopupMenu() {
        return this.\u01dd;
    }

    public void setShowPredefinedColumnsInPopupMenu(boolean showPredefinedColumnsInPopupMenu) {
        this.\u01dd = showPredefinedColumnsInPopupMenu;
    }

    public boolean isPredefinedColumn(TTableColumn column) {
        if (column == null) {
            return false;
        }
        return column.getName().equals(OID_COLUMN) || column.getName().equals(CHECK_COLUMN) || column.getName().equals(TREE_COLUMN);
    }

    public void updateUI() {
        if (this.\u01eb != null) {
            this.\u01eb.clearCache();
        }
        if (this.\u01ea != null) {
            this.\u01ea.clearCache();
        }
        super.updateUI();
    }

    public boolean isLocalSortable() {
        return this.\u01dc;
    }

    public void setLocalSortable(boolean isLocalSortable) {
        this.\u01dc = isLocalSortable;
    }

    public void setTableHeadHorizontalAlignment(int alignment) {
        this.\u01e6.setHorizontalAlignment(alignment);
    }

    public int getTableHeadHorizontalAlignment() {
        return this.\u01e6.getHorizontalAlignment();
    }

    public boolean isEnableTristateSorting() {
        return this.\u01e2;
    }

    public void setEnableTristateSorting(boolean enableTristateSorting) {
        this.\u01e2 = enableTristateSorting;
    }

    public boolean isShowTableHeaderIcon() {
        return this.\u01e5;
    }

    public void setShowTableHeaderIcon(boolean showTableHeaderIcon) {
        this.\u01e5 = showTableHeaderIcon;
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.repaint();
        }
    }

    public boolean isLazyPublishMode() {
        return this.\u01da;
    }

    public void setLazyPublishMode(boolean lazyPublishMode) {
        this.\u01da = lazyPublishMode;
    }

    public boolean isVisible(TTableColumn column) {
        if (column == null) {
            return false;
        }
        if (this.\u01e8 == null) {
            return column.isVisible();
        }
        return this.\u01e8.isVisible(column);
    }

    public ColumnVisibleFilter getColumnVisibleFilter() {
        return this.\u01e8;
    }

    public void setColumnVisibleFilter(ColumnVisibleFilter columnVisibleFilter) {
        if (this.\u01e8 != columnVisibleFilter) {
            this.\u01e8 = columnVisibleFilter;
            this.tableModel.reset();
        }
    }

    public List getSortColumnList() {
        return this.tableModel.getSortColumnList();
    }

    public void sortNoneColumn() {
        this.tableModel.sortNoneColumn();
    }

    public List filterTopRows(List publishedData) {
        return null;
    }

    public List filterBottomRows(List publishedData) {
        return null;
    }

    public void selectRowDatas(Collection selectedRowDatas) {
        if (selectedRowDatas instanceof List) {
            this.tableModel.setSelectedRows((List)selectedRowDatas);
        } else {
            this.tableModel.setSelectedRows(new ArrayList(selectedRowDatas));
        }
    }

    public boolean isDistinctSortableHeader() {
        return this.\u01de;
    }

    public void setDistinctSortableHeader(boolean distinctSortableHeader) {
        this.\u01de = distinctSortableHeader;
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.repaint();
        }
    }

    public void prepareTableHeaderRenderer(JLabel renderer, TTableColumn tableColumn) {
    }

    public MouseEvent getCurrentMouseEvent() {
        return this.\u01e3;
    }

    public void setCurrentMouseEvent(MouseEvent currentMouseEvent) {
        this.\u01e3 = currentMouseEvent;
    }

    public boolean isEnableRightClickEvent() {
        return this.\u01e4;
    }

    public void setEnableRightClickEvent(boolean isEnableRightClickEvent) {
        this.\u01e4 = isEnableRightClickEvent;
    }
}

