/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import twaver.PolySubNetwork;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.NodeSVGUI;

public class PolySubNetworkSVGUI
extends NodeSVGUI {
    private PolySubNetwork R;

    public PolySubNetworkSVGUI(TSVGNetwork network, PolySubNetwork polySubNetwork) {
        super(network, polySubNetwork);
        this.R = polySubNetwork;
    }

    protected SVGStruct toDefaultBodySVG(SVGContext context) {
        String stroke;
        StringBuffer sb = new StringBuffer();
        float alpha = this.getRenderAlpha();
        GeneralPath shape = this.R.getShape();
        String id = I.A(context, (Shape)shape);
        Color bodyColor = this.R.getBodyColor();
        bodyColor = this.getPaintBodyColor(bodyColor);
        Object fillObject = null;
        if (this.R.isPolyFill()) {
            fillObject = this.getFillObject(context, bodyColor);
        }
        boolean is3D = this.R.isPoly3D();
        int width = this.R.getPolyOutlineWidth();
        Color stateColor = this.getStateOutlineColor();
        if (stateColor != null) {
            stroke = String.valueOf(is3D ? width + 5 : width + 3);
            I.A(context, sb, shape, null, (Object)stateColor, (Object)stroke, 0.0f, 0.0, null);
        }
        stroke = null;
        Color outlineObject = null;
        if (width > 0) {
            outlineObject = bodyColor;
            stroke = String.valueOf(width);
            if (is3D) {
                I.A(sb, id);
                Color color = bodyColor.brighter().brighter();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, -1, -1).append("/>\n");
                I.A(sb, id);
                color = bodyColor.darker().darker();
                I.A(context, sb, null, (Object)color, stroke, alpha);
                I.A(sb, 1, 1).append("/>\n");
            }
        }
        I.A(sb, id);
        I.A(context, sb, fillObject, (Object)outlineObject, stroke, alpha).append("/>\n");
        return new SVGStruct(sb.toString(), shape.getBounds());
    }
}

