/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.network.NetworkPrinter;
import twaver.network.TNetwork;

public class NetworkPrintPreviewer
extends JDialog
implements ActionListener {
    private static final Color I = new Color(141, 141, 143);
    private static final int H = 300;
    private static final int F = 300;
    private static final double D = 0.98;
    private NetworkPrinter J = null;
    private JButton G = null;
    private JButton E = null;
    private JButton A = null;
    private _A B = null;
    private Image C = null;

    public NetworkPrintPreviewer(Frame parent, NetworkPrinter printer) {
        super(parent, true);
        this.A(printer);
    }

    public NetworkPrintPreviewer(Dialog parent, NetworkPrinter printer) {
        super(parent, true);
        this.A(printer);
    }

    private void A(NetworkPrinter printer) {
        this.setTitle(TWaverUtil.getString("NetworkPrintPreviewButton"));
        this.J = printer;
        this.G = new JButton(TWaverUtil.getString("NetworkPrintRefresh"));
        this.E = new JButton(TWaverUtil.getString("NetworkPrintSetup"));
        this.A = new JButton(TWaverUtil.getString("NetworkPrintButton"));
        this.G.addActionListener(this);
        this.E.addActionListener(this);
        this.A.addActionListener(this);
        this.B = new _A();
        JPanel buttons = new JPanel();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(2);
        layout.setHgap(10);
        layout.setVgap(5);
        buttons.setLayout(layout);
        buttons.add(this.G);
        buttons.add(this.E);
        buttons.add(this.A);
        this.getContentPane().add((Component)this.B, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        TWaverUtil.centerWindow(this);
        this.setVisible(true);
    }

    public void createImage() {
        double previewWidth;
        double previewHeight;
        PageFormat pageFormat = this.J.getPageFormat();
        double pageWidth = pageFormat.getWidth();
        double pageHeight = pageFormat.getHeight();
        if (pageHeight > pageWidth) {
            previewHeight = 294.0;
            previewWidth = previewHeight * (pageWidth / pageHeight);
        } else {
            previewWidth = 294.0;
            previewHeight = previewWidth * (pageHeight / pageWidth);
        }
        this.C = this.createImage((int)previewWidth, (int)previewHeight);
        this.A();
    }

    private void A() {
        double previewWidth;
        double previewHeight;
        PageFormat pageFormat = this.J.getPageFormat();
        double pageWidth = pageFormat.getWidth();
        double pageHeight = pageFormat.getHeight();
        if (pageHeight > pageWidth) {
            previewHeight = 294.0;
            previewWidth = previewHeight * (pageWidth / pageHeight);
        } else {
            previewWidth = 294.0;
            previewHeight = previewWidth * (pageHeight / pageWidth);
        }
        double rate = previewHeight / pageHeight;
        int imageableWidth = (int)(pageFormat.getImageableWidth() * rate);
        int imageableHeight = (int)(pageFormat.getImageableHeight() * rate);
        int imageableX = (int)(pageFormat.getImageableX() * rate);
        int imageableY = (int)(pageFormat.getImageableY() * rate);
        Graphics2D g2 = (Graphics2D)this.C.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, previewWidth, previewHeight));
        g2.setColor(Color.BLACK);
        g2.setStroke(TWaverConst.DASHED_STROKE);
        g2.drawRect(imageableX - 1, imageableY - 1, imageableWidth + 1, imageableHeight + 1);
        g2.setClip(imageableX, imageableY, imageableWidth, imageableHeight);
        TNetwork network = this.J.getNetwork();
        double zoom = network.getZoomer().getZoom();
        double networkWidth = (double)network.getCanvas().getWidth() / zoom;
        double networkHeight = (double)network.getCanvas().getHeight() / zoom;
        zoom = Math.min((double)imageableHeight / networkHeight, (double)imageableWidth / networkWidth);
        g2.translate(imageableX, imageableY);
        network.setPaintState(4);
        network.paintNetworkContent(g2, zoom, zoom, false);
        network.setPaintState(0);
        g2.scale(1.0 / zoom, 1.0 / zoom);
        g2.translate(-imageableX, -imageableY);
        Area area = new Area(new Rectangle(0, 0, (int)previewWidth, (int)previewHeight));
        area.exclusiveOr(new Area(new Rectangle(imageableX, imageableY, imageableWidth + 1, imageableHeight + 1)));
        g2.setColor(Color.WHITE);
        g2.fill(area);
        this.B.repaint();
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() == this.G) {
            this.A();
        } else if (e2.getSource() == this.E) {
            if (this.J.setup()) {
                this.createImage();
            }
        } else if (e2.getSource() == this.A) {
            this.J.print();
        }
    }

    class _A
    extends JComponent {
        public _A() {
            Dimension size = new Dimension(300, 300);
            this.setMaximumSize(size);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }

        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (!this.isShowing()) {
                return;
            }
            if (NetworkPrintPreviewer.this.C == null) {
                NetworkPrintPreviewer.this.createImage();
            }
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setColor(I);
            g2d.fill(new Rectangle2D.Double(0.0, 0.0, 300.0, 300.0));
            int width = NetworkPrintPreviewer.this.C.getWidth(this);
            int height = NetworkPrintPreviewer.this.C.getHeight(this);
            int x = (300 - width) / 2;
            int y = (300 - height) / 2;
            g2d.drawImage(NetworkPrintPreviewer.this.C, x, y, this);
        }
    }
}

