/*
 * Decompiled with CFR 0.152.
 */
package twaver.network;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import twaver.BaseElement;
import twaver.Element;
import twaver.ElementAttribute;
import twaver.Layer;
import twaver.LayerModel;
import twaver.LayerModelListener;
import twaver.TDataBox;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.E.P;
import twaver.base.A.E.b;
import twaver.network.A;
import twaver.network.TNetwork;
import twaver.table.TElementTable;

public class LayerManagerPane
extends JPanel {
    public static final List attributes = new ArrayList();
    private ActionListener E;
    private TDataBox H;
    private TElementTable N;
    private LayerModel C;
    private A L;
    protected JToolBar toolbar;
    private JButton J;
    private JButton F;
    private JButton I;
    private JButton B;
    private JButton A;
    private JButton M;
    private JCheckBox D;
    private LayerModelListener G;
    private PropertyChangeListener K;

    private static ElementAttribute A(String key, Class clazz) {
        ElementAttribute attribute = new ElementAttribute();
        attribute.setClientPropertyKey(key);
        attribute.setDisplayName(TWaverUtil.getString("layer." + key));
        attribute.setEditable(true);
        attribute.setJavaClass(clazz);
        attributes.add(attribute);
        return attribute;
    }

    protected JButton createButton(String image) {
        Icon icon = TWaverUtil.getIcon("/resource/image/table/" + image);
        JButton button = new JButton(icon);
        button.setMargin(TWaverConst.NONE_INSETS);
        button.addActionListener(this.E);
        return button;
    }

    protected void initToolBar() {
        this.toolbar.setMinimumSize(TWaverConst.EMPTY_DIMENSION);
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.toolbar.add(this.J);
        this.toolbar.add(this.F);
        this.toolbar.addSeparator();
        this.toolbar.add(this.I);
        this.toolbar.add(this.B);
        this.toolbar.add(this.A);
        this.toolbar.add(this.M);
        this.D.addActionListener(this.E);
        this.D.setFocusPainted(false);
        this.toolbar.addSeparator();
        this.toolbar.add(this.D);
    }

    public LayerManagerPane(LayerModel layerModel) {
        LayerManagerPane.A("id", null).setEditable(false);
        LayerManagerPane.A("name", String.class);
        LayerManagerPane.A("visible", Boolean.class);
        LayerManagerPane.A("selectable", Boolean.class);
        LayerManagerPane.A("movable", Boolean.class);
        LayerManagerPane.A("resizable", Boolean.class);
        LayerManagerPane.A("alpha", Float.class);
        LayerManagerPane.A("description", String.class);
        this.E = new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                Object source = e2.getSource();
                if (source == LayerManagerPane.this.J) {
                    LayerManagerPane.this.addLayer();
                } else if (source == LayerManagerPane.this.F) {
                    LayerManagerPane.this.deleteLayer();
                } else if (source == LayerManagerPane.this.I) {
                    LayerManagerPane.this.moveToTop();
                } else if (source == LayerManagerPane.this.B) {
                    LayerManagerPane.this.moveToUp();
                } else if (source == LayerManagerPane.this.A) {
                    LayerManagerPane.this.moveToDown();
                } else if (source == LayerManagerPane.this.M) {
                    LayerManagerPane.this.moveToBottom();
                } else if (source == LayerManagerPane.this.D) {
                    LayerManagerPane.this.N.setEditable(LayerManagerPane.this.D.isSelected());
                }
            }
        };
        this.H = new TDataBox();
        this.N = new TElementTable(this.H);
        this.C = null;
        this.L = null;
        this.toolbar = new JToolBar();
        this.J = this.createButton("add.png");
        this.F = this.createButton("delete.png");
        this.I = this.createButton("top.png");
        this.B = this.createButton("up.png");
        this.A = this.createButton("down.png");
        this.M = this.createButton("bottom.png");
        this.D = new JCheckBox(TWaverUtil.getString("EDITABLE"), false);
        this.G = new LayerModelListener(){

            public void layerAdded(Layer layer) {
                LayerManagerPane.this.A();
            }

            public void layerRemoved(Layer layer) {
                LayerManagerPane.this.A();
            }

            public void layerIndexChanged() {
                LayerManagerPane.this.A();
            }
        };
        this.K = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Layer layer = (Layer)evt.getSource();
                Element element = LayerManagerPane.this.H.getElementByID(layer);
                String propertyName = b.A(evt);
                if (propertyName.equals("name")) {
                    element.putClientProperty((Object)"name", layer.getName());
                } else if (propertyName.equals("visible")) {
                    element.putClientProperty((Object)"visible", (Object)layer.isVisible());
                } else if (propertyName.equals("description")) {
                    element.putClientProperty((Object)"description", layer.getDescription());
                } else if (propertyName.equals("alpha")) {
                    element.putClientProperty((Object)"alpha", new Float(layer.getAlpha()));
                } else if (propertyName.equals("selectable")) {
                    element.putClientProperty((Object)"selectable", (Object)layer.isSelectable());
                } else if (propertyName.equals("movable")) {
                    element.putClientProperty((Object)"movable", (Object)layer.isMovable());
                } else if (propertyName.equals("resizable")) {
                    element.putClientProperty((Object)"resizable", (Object)layer.isResizable());
                }
            }
        };
        this.B();
        this.setLayerModel(layerModel);
    }

    public LayerManagerPane(final TNetwork network) {
        LayerManagerPane.A("id", null).setEditable(false);
        LayerManagerPane.A("name", String.class);
        LayerManagerPane.A("visible", Boolean.class);
        LayerManagerPane.A("selectable", Boolean.class);
        LayerManagerPane.A("movable", Boolean.class);
        LayerManagerPane.A("resizable", Boolean.class);
        LayerManagerPane.A("alpha", Float.class);
        LayerManagerPane.A("description", String.class);
        this.E = new /* invalid duplicate definition of identical inner class */;
        this.H = new TDataBox();
        this.N = new TElementTable(this.H);
        this.C = null;
        this.L = null;
        this.toolbar = new JToolBar();
        this.J = this.createButton("add.png");
        this.F = this.createButton("delete.png");
        this.I = this.createButton("top.png");
        this.B = this.createButton("up.png");
        this.A = this.createButton("down.png");
        this.M = this.createButton("bottom.png");
        this.D = new JCheckBox(TWaverUtil.getString("EDITABLE"), false);
        this.G = new /* invalid duplicate definition of identical inner class */;
        this.K = new /* invalid duplicate definition of identical inner class */;
        this.B();
        this.setLayerModel(network.getDataBox().getLayerModel());
        network.addPropertyChangeListener("databox", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LayerManagerPane.this.setLayerModel(network.getDataBox().getLayerModel());
            }
        });
    }

    private void B() {
        this.initToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)new JScrollPane(this.N), "Center");
        this.N.getSelectionModel().setSelectionMode(0);
        this.N.setElementClass(BaseElement.class);
        this.N.registerElementClassAttributes(BaseElement.class, attributes);
        this.N.setEditable(this.D.isSelected());
        this.N.setShowPredefinedColumnsInPopupMenu(false);
        this.N.setTableBodyPopupMenuFactory(null);
        this.H.addElementPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Element element = (Element)evt.getSource();
                Layer layer = (Layer)element.getID();
                String propertyName = b.A(evt);
                if (propertyName.equals("name")) {
                    layer.setName((String)element.getClientProperty("name"));
                } else if (propertyName.equals("description")) {
                    layer.setDescription((String)element.getClientProperty("description"));
                } else if (propertyName.equals("visible")) {
                    layer.setVisible((Boolean)element.getClientProperty("visible"));
                } else if (propertyName.equals("selectable")) {
                    layer.setSelectable((Boolean)element.getClientProperty("selectable"));
                } else if (propertyName.equals("movable")) {
                    layer.setMovable((Boolean)element.getClientProperty("movable"));
                } else if (propertyName.equals("resizable")) {
                    layer.setResizable((Boolean)element.getClientProperty("resizable"));
                } else if (propertyName.equals("alpha")) {
                    layer.setAlpha(((Float)element.getClientProperty("alpha")).floatValue());
                }
            }
        });
    }

    public void setLayerModel(LayerModel layerModel) {
        if (this.C == layerModel) {
            return;
        }
        if (this.C != null) {
            this.C.removeLayerModelListener(this.G);
            this.C.removeLayerPropertyChangeListener(this.K);
        }
        this.C = layerModel;
        if (this.C != null) {
            this.C.addLayerModelListener(this.G);
            this.C.addLayerPropertyChangeListener(this.K);
        }
        this.A();
    }

    private void A() {
        Layer currentLayer = this.getCurrentSelectedLayer();
        this.H.clear();
        if (this.C == null) {
            return;
        }
        for (int i2 = 0; i2 < this.C.size(); ++i2) {
            Layer layer = this.C.getLayerByIndex(i2);
            BaseElement element = new BaseElement(layer){

                public void putClientProperty(Object key, Object value) {
                    if ("alpha".equals(key)) {
                        float alpha;
                        if (value instanceof Number && (alpha = ((Number)value).floatValue()) >= 0.0f && alpha <= 1.0f) {
                            super.putClientProperty(key, value);
                        }
                    } else {
                        super.putClientProperty(key, value);
                    }
                }
            };
            element.putClientProperty((Object)"id", layer.getID());
            element.putClientProperty((Object)"name", layer.getName());
            element.putClientProperty((Object)"visible", layer.isVisible());
            element.putClientProperty((Object)"selectable", layer.isSelectable());
            element.putClientProperty((Object)"movable", layer.isMovable());
            element.putClientProperty((Object)"resizable", layer.isResizable());
            element.putClientProperty((Object)"alpha", new Float(layer.getAlpha()));
            element.putClientProperty((Object)"description", layer.getDescription());
            this.H.addElement(element);
        }
        Element element = this.H.getElementByID(currentLayer);
        if (element != null) {
            this.H.getSelectionModel().setSelection(element);
        }
    }

    protected void addLayer() {
        if (this.C == null) {
            return;
        }
        if (this.L == null) {
            Window parent = P.B(this);
            this.L = parent instanceof Frame ? new A((Frame)parent, this.C) : new A((Dialog)parent, this.C);
        }
        this.L.setVisible(true);
    }

    protected Layer getCurrentSelectedLayer() {
        Element element = this.H.getLastSelectedElement();
        if (element == null) {
            return null;
        }
        return (Layer)element.getID();
    }

    protected void deleteLayer() {
        Layer layer = this.getCurrentSelectedLayer();
        if (layer != null && layer != this.C.getDefaultLayer()) {
            this.C.removeLayer(layer);
        }
    }

    protected void moveToTop() {
        Layer layer = this.getCurrentSelectedLayer();
        if (layer != null) {
            this.C.moveToTop(layer);
        }
    }

    protected void moveToUp() {
        Layer layer = this.getCurrentSelectedLayer();
        if (layer != null) {
            this.C.moveToUp(layer);
        }
    }

    protected void moveToDown() {
        Layer layer = this.getCurrentSelectedLayer();
        if (layer != null) {
            this.C.moveToDown(layer);
        }
    }

    protected void moveToBottom() {
        Layer layer = this.getCurrentSelectedLayer();
        if (layer != null) {
            this.C.moveToBottom(layer);
        }
    }
}

