/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import y.base.ListCell;
import y.io.BadVersionException;
import y.view.Bend;
import y.view.BendCursor;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.if;

public class BezierEdgeRealizer
extends EdgeRealizer {
    private static final int ar = 12;
    private Polygon at;
    private float[] as = new float[2];

    public BezierEdgeRealizer() {
    }

    public BezierEdgeRealizer(EdgeRealizer edgeRealizer) {
        super(edgeRealizer);
    }

    public EdgeRealizer createCopy(EdgeRealizer edgeRealizer) {
        return new BezierEdgeRealizer(edgeRealizer);
    }

    public Bend createBend(double d2, double d3, Bend bend, int n) {
        Bend bend2 = new Bend(this, d2, d3);
        this.reInsertBend(bend2, bend, n);
        return bend2;
    }

    public void reInsertBend(Bend bend, Bend bend2, int n) {
        if (n == 0) {
            this.bends.insertAfter(bend, this.bends.findCell(bend2));
        } else {
            this.bends.insertBefore(bend, this.bends.findCell(bend2));
        }
        this.setDirty();
    }

    public Bend insertBend(double d2, double d3) {
        int n = this.a(d2, d3);
        if (n >= 0) {
            return this.createBend(d2, d3, (Bend)this.bends.elementAt(n), 1);
        }
        return null;
    }

    public boolean contains(double d2, double d3) {
        if (!this.isSelected()) {
            return super.contains(d2, d3);
        }
        return this.a(d2, d3) > 0;
    }

    public Bend removeBend(Bend bend) {
        this.bends.remove(bend);
        this.setDirty();
        return bend;
    }

    private int a(double d2, double d3) {
        double d4;
        double d5;
        double d6 = this.getSourcePort().getX(this.getSourceRealizer());
        double d7 = this.getSourcePort().getY(this.getSourceRealizer());
        int n = 0;
        BendCursor bendCursor = this.bends();
        while (bendCursor.ok()) {
            Bend bend = bendCursor.bend();
            d5 = bend.getX();
            if (Line2D.ptSegDist(d6, d7, d5, d4 = bend.getY(), d2, d3) < 5.0) {
                return n;
            }
            d6 = d5;
            d7 = d4;
            bendCursor.next();
            ++n;
        }
        d5 = this.getTargetPort().getX(this.getTargetRealizer());
        if (Line2D.ptSegDist(d6, d7, d5, d4 = this.getTargetPort().getY(this.getTargetRealizer()), d2, d3) < 5.0) {
            return n;
        }
        return -1;
    }

    protected void calculatePath() {
        if (this.bendCount() == 0) {
            if.b(this, this.path);
        } else {
            Object object;
            int n = 2;
            n = (this.bendCount() & 1) == 1 ? (n += 3 * this.bendCount() + 1 >> 1) : (n += 3 * (this.bendCount() >> 1) - 1);
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            NodeRealizer nodeRealizer = this.getSourceRealizer();
            Port port = this.getSourcePort();
            nArray[0] = (int)port.getX(nodeRealizer);
            nArray2[0] = (int)port.getY(nodeRealizer);
            int n2 = 1;
            BendCursor bendCursor = this.bends();
            while (bendCursor.ok()) {
                object = bendCursor.bend();
                if (n2 % 3 == 0) {
                    nArray[n2] = (int)(((Bend)object).getX() + (double)nArray[n2 - 1]) / 2;
                    nArray2[n2] = (int)(((Bend)object).getY() + (double)nArray2[n2 - 1]) / 2;
                    ++n2;
                }
                nArray[n2] = (int)((Bend)object).getX();
                nArray2[n2] = (int)((Bend)object).getY();
                bendCursor.next();
                ++n2;
            }
            if (n2 % 3 == 2) {
                nArray[n2] = nArray[n2 - 1];
                nArray2[n2] = nArray2[n2 - 1];
            }
            nodeRealizer = this.getTargetRealizer();
            port = this.getTargetPort();
            nArray[n - 1] = (int)port.getX(nodeRealizer);
            nArray2[n - 1] = (int)port.getY(nodeRealizer);
            this.at = new Polygon(nArray, nArray2, n);
            this.path.reset();
            object = this.as;
            this.a(0, 0.0f, (float[])object);
            this.path.moveTo((float)object[0], (float)object[1]);
            int n3 = 0;
            while (n3 < this.at.npoints - 3) {
                int n4 = 1;
                while (n4 <= 12) {
                    this.a(n3, (float)n4 / 12.0f, (float[])object);
                    this.path.lineTo((float)object[0], (float)object[1]);
                    ++n4;
                }
                n3 += 3;
            }
            this.path = if.d(this, this.path);
        }
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        super.calcUnionRect(rectangle2D);
        if (this.isSelected()) {
            ListCell listCell = this.bends.firstCell();
            while (listCell != null) {
                Bend bend = (Bend)listCell.getInfo();
                rectangle2D.add(bend.getX(), bend.getY());
                listCell = listCell.succ();
            }
        }
    }

    protected void paintHighlightedBends(Graphics2D graphics2D) {
        super.paintSloppy(graphics2D);
        super.paintHighlightedBends(graphics2D);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(0);
        super.write(objectOutputStream);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }

    static float a(int n, float f2) {
        switch (n) {
            case 0: {
                return (1.0f - f2) * (1.0f - f2) * (1.0f - f2);
            }
            case 1: {
                return 3.0f * f2 * (1.0f - f2) * (1.0f - f2);
            }
            case 2: {
                return 3.0f * f2 * f2 * (1.0f - f2);
            }
            case 3: {
                return f2 * f2 * f2;
            }
        }
        return 0.0f;
    }

    void a(int n, float f2, float[] fArray) {
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        while (n2 <= 3) {
            f3 += BezierEdgeRealizer.a(n2, f2) * (float)this.at.xpoints[n + n2];
            f4 += BezierEdgeRealizer.a(n2, f2) * (float)this.at.ypoints[n + n2];
            ++n2;
        }
        fArray[0] = f3;
        fArray[1] = f4;
    }
}

