/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tween;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class VisibilityTweener
implements ActionListener {
    private Component component;
    private Dimension dimension;
    private boolean horizontalTweening = true;
    private boolean verticalTweening = true;
    private boolean visibleTweening = true;
    private int frameInterval = 1;
    private int frameCount = 20;
    private int frameIndex;
    private Timer timer;

    public VisibilityTweener(Component component) {
        this(component, true, true);
    }

    public VisibilityTweener(Component component, int frameInterval, int frameCount) {
        this(component, true, true, frameInterval, frameCount);
    }

    public VisibilityTweener(Component component, boolean horizontalTweening, boolean verticalTweening) {
        this(component, horizontalTweening, verticalTweening, 1, 20);
    }

    public VisibilityTweener(Component component, boolean horizontalTweening, boolean verticalTweening, int frameInterval, int frameCount) {
        this.component = component;
        this.dimension = component.getSize();
        this.horizontalTweening = horizontalTweening;
        this.verticalTweening = verticalTweening;
        this.frameInterval = frameInterval;
        this.frameCount = frameCount;
        this.timer = new Timer(this.frameInterval, this);
    }

    public void tween(boolean visibleTweening) {
        this.visibleTweening = visibleTweening;
        if (visibleTweening) {
            this.frameIndex = 0;
            this.component.setSize(0, 0);
            this.component.setVisible(true);
        } else {
            this.frameIndex = this.frameCount;
        }
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.visibleTweening) {
            this.component.setSize(this.horizontalTweening ? this.dimension.width * this.frameIndex / this.frameCount : this.dimension.width, this.verticalTweening ? this.dimension.height * this.frameIndex / this.frameCount : this.dimension.height);
            if (this.frameIndex == this.frameCount) {
                this.timer.stop();
            } else {
                ++this.frameIndex;
            }
        } else {
            this.component.setSize(this.horizontalTweening ? this.dimension.width * this.frameIndex / this.frameCount : this.dimension.width, this.verticalTweening ? this.dimension.height * this.frameIndex / this.frameCount : this.dimension.height);
            if (this.frameIndex == 0) {
                this.component.setVisible(false);
                this.timer.stop();
            } else {
                --this.frameIndex;
            }
        }
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public boolean isHorizontalTweening() {
        return this.horizontalTweening;
    }

    public void setHorizontalTweening(boolean horizontalTweening) {
        this.horizontalTweening = horizontalTweening;
    }

    public boolean isVerticalTweening() {
        return this.verticalTweening;
    }

    public void setVerticalTweening(boolean verticalTweening) {
        this.verticalTweening = verticalTweening;
    }

    public int getFrameInterval() {
        return this.frameInterval;
    }

    public void setFrameInterval(int frameInterval) {
        this.frameInterval = frameInterval;
        this.timer.setDelay(this.frameInterval);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }
}

