/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.shrinkbar;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.swing.style.button.lite.LiteButtonUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingConstants;

public class JShrinkShortcut
extends JPanel
implements SwingConstants {
    private JLabel label;
    private JBasicSeparator separator;
    private JPanel separatorPanel;
    private JPanel buttonPanel;

    public JShrinkShortcut() {
        this.initComponents();
    }

    private void initComponents() {
        this.separator = new JBasicSeparator(0, "LoweredStyle", -1);
        this.separatorPanel = new JPanel();
        this.separatorPanel.setLayout(new BorderLayout());
        this.separatorPanel.add((Component)this.separator, "Center");
        this.separatorPanel.setOpaque(false);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        JPanel labelPanel = new JPanel();
        labelPanel.setOpaque(false);
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        labelPanel.setLayout(new BorderLayout());
        labelPanel.add((Component)this.label, "West");
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        borderPanel.setLayout(new OverlayLayout(borderPanel));
        borderPanel.add(labelPanel);
        borderPanel.add(this.separatorPanel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.buttonPanel.setLayout(new FiledLayout(0, 2, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)borderPanel, "North");
        this.add((Component)this.buttonPanel, "Center");
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    @Override
    public String getToolTipText() {
        return this.label.getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.label.setToolTipText(toolTipText);
    }

    public Color getTitleColor() {
        return this.label.getForeground();
    }

    public void setTitleColor(Color color) {
        this.label.setForeground(color);
    }

    public Font getTitleFont() {
        return this.label.getFont();
    }

    public void setTitleFont(Font font) {
        this.label.setFont(font);
    }

    public void setSeparatorColor(Color[] colors) {
        if (colors != null) {
            this.separator.setBrightColor(colors[0]);
            this.separator.setDarkColor(colors[1]);
        } else {
            this.separator.setBrightColor(Color.white);
            this.separator.setDarkColor(Color.gray);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    protected void shrinkChanged(boolean shrinked) {
        this.label.setVisible(!shrinked);
        for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
            Component component = this.buttonPanel.getComponent(i);
            if (!(component instanceof JBasicButton)) continue;
            JBasicButton button = (JBasicButton)component;
            LiteButtonUI liteButtonUI = (LiteButtonUI)button.getUI();
            if (shrinked) {
                button.setText(null);
                liteButtonUI.setWidthOffset(0);
                liteButtonUI.setHeightOffset(0);
                ButtonManager.setButtonLayout(button, new int[]{0, 0});
                continue;
            }
            String text = (String)button.getClientProperty("shrinkText");
            button.setText(text);
            int widthOffset = (Integer)button.getClientProperty("shrinkWidthOffset");
            liteButtonUI.setWidthOffset(widthOffset);
            int heightOffset = (Integer)button.getClientProperty("shrinkHeightOffset");
            liteButtonUI.setHeightOffset(heightOffset);
            ButtonManager.setButtonLayout(button, new int[]{0, 2});
        }
    }

    public JBasicButton getButton(int index) {
        return (JBasicButton)this.buttonPanel.getComponent(index);
    }

    public void addButton(JBasicButton button) {
        LiteButtonUI liteButtonUI = (LiteButtonUI)button.getUI();
        String text = button.getText();
        button.putClientProperty("shrinkText", text);
        int widthOffset = liteButtonUI.getWidthOffset();
        button.putClientProperty("shrinkWidthOffset", widthOffset);
        int heightOffset = liteButtonUI.getHeightOffset();
        button.putClientProperty("shrinkHeightOffset", heightOffset);
        ButtonManager.setButtonLayout(button, new int[]{0, 2});
        this.buttonPanel.add(button);
    }

    public void deleteButton(JBasicButton button) {
        this.buttonPanel.remove(button);
    }

    public void deleteButton(int index) {
        this.buttonPanel.remove(index);
    }

    public void deleteAllButtons() {
        this.buttonPanel.removeAll();
    }

    public void setButtonList(List buttonList) {
        if (buttonList == null || buttonList.isEmpty()) {
            return;
        }
        for (JBasicButton button : buttonList) {
            this.addButton(button);
        }
    }
}

