/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class DialogResizer
extends ComponentAdapter {
    private Dimension dimension;
    private Dimension minimumDimension;
    private Dimension maximumDimension;

    public DialogResizer() {
        this(null);
    }

    public DialogResizer(Dimension dimension) {
        this(dimension, null, null);
    }

    public DialogResizer(Dimension dimension, Dimension minimumDimension, Dimension maximumDimension) {
        this.dimension = dimension;
        this.minimumDimension = minimumDimension;
        this.maximumDimension = maximumDimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public Dimension getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimumDimension(Dimension minimumDimension) {
        this.minimumDimension = minimumDimension;
    }

    public Dimension getMaximumDimension() {
        return this.maximumDimension;
    }

    public void setMaximumDimension(Dimension maximumDimension) {
        this.maximumDimension = maximumDimension;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component component = (Component)e.getSource();
        Dimension size = component.getSize();
        if (this.dimension == null) {
            return;
        }
        if (this.minimumDimension != null && (size.width < this.minimumDimension.width || size.height < this.minimumDimension.height)) {
            if (size.width < this.minimumDimension.width) {
                this.dimension.width = this.minimumDimension.width;
            }
            if (size.height < this.minimumDimension.height) {
                this.dimension.height = this.minimumDimension.height;
            }
            component.setSize(this.dimension);
        }
        if (this.maximumDimension != null && (size.width > this.maximumDimension.width || size.height > this.maximumDimension.height)) {
            if (size.width > this.maximumDimension.width) {
                this.dimension.width = this.maximumDimension.width;
            }
            if (size.height > this.maximumDimension.height) {
                this.dimension.height = this.maximumDimension.height;
            }
            component.setSize(this.dimension);
        }
        if (this.minimumDimension == null && this.maximumDimension == null) {
            component.setSize(this.dimension);
        }
    }
}

