/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.base.A.H.I;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public class SVGPercentChart
extends AbstractSVGChart {
    private int \u014a = TUIManager.getInt("tchart.percent.gap");
    private int \u013d = TUIManager.getInt("tchart.thickness");
    private int \u0146 = TUIManager.getInt("tchart.segment.count");
    private Color \u013f = TUIManager.getColor("tchart.percent.label.color");
    private Font \u0145 = TUIManager.getFont("tchart.percent.label.font");
    private boolean \u0140 = TUIManager.getBoolean("tchart.percent.label.visible");
    private boolean \u0141 = TUIManager.getBoolean("tchart.percent.label.center");
    private boolean \u0149 = TUIManager.getBoolean("tchart.percent.spare.fill");
    private Color \u0143 = TUIManager.getColor("tchart.spare.color");
    private Color \u0144 = TUIManager.getColor("tchart.percent.spare.gradient.color");
    private Color \u014b = TUIManager.getColor("tchart.outline.color");
    private int \u013e = TUIManager.getInt("tchart.percent.type");
    private int \u0147 = TUIManager.getInt("tchart.percent.marker.start.position");
    private double \u0142 = TUIManager.getDouble("tchart.segment.section.prorate");
    private int \u0148 = TUIManager.getInt("tchart.percent.marker.position");
    public static final JLabel renderer = new JLabel(){
        {
            this.setOpaque(false);
            this.setDoubleBuffered(false);
        }
    };

    public SVGPercentChart() {
        this(new TDataBox());
    }

    public SVGPercentChart(TDataBox box) {
        this(box, null, null);
    }

    public SVGPercentChart(TDataBox box, String title, Color backgroundColor) {
        this(box, title, backgroundColor, null);
    }

    public SVGPercentChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
        this.init();
    }

    protected void init() {
        if (this.selectedColor == null) {
            this.selectedColor = TWaverConst.COLOR_DARK;
        }
        this.setXGap(1);
        this.setYGap(1);
    }

    protected void calculate() {
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        this.backgroundBounds.x = this.xGap;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = width - 2 * this.xGap;
        this.backgroundBounds.height = height - 2 * this.yGap;
        this.paintBackground(context, result);
        int count = this.publishedElements.size();
        if (count == 0) {
            return;
        }
        if (this.\u013e == 2) {
            this.D(context, result, width, height);
        } else if (this.\u013e == 1) {
            this.C(context, result, width, height);
        }
    }

    private void D(SVGContext context, StringBuffer result, int width, int height) {
        int count = this.publishedElements.size();
        int span = (width - 2 * this.xGap) / count;
        if (span < 4) {
            span = 4;
        }
        int thick = this.\u013d > span - 4 ? span - 4 : this.\u013d;
        int lableHeight = 0;
        if (this.\u0140 && !this.\u0141) {
            renderer.setFont(this.\u0145);
            renderer.setForeground(this.\u013f);
            for (int i2 = 0; i2 < count; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                if (size.height <= lableHeight) continue;
                lableHeight = size.height;
            }
        }
        int gradientType = 19;
        for (int i3 = 0; i3 < count; ++i3) {
            Element element = (Element)this.publishedElements.get(i3);
            double percent = this.A(element);
            Stroke stroke = this.getStroke(element);
            int x = this.xGap + i3 * span + span / 2 - thick / 2;
            int y = height - this.yGap - this.\u014a - lableHeight;
            int w = thick;
            int h2 = height - 2 * this.yGap - lableHeight - this.\u014a * 2;
            if (this.\u0140 && !this.\u0141) {
                renderer.setFont(this.\u0145);
                renderer.setForeground(this.\u013f);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                int labelwidth = 0;
                labelwidth = size.width > span ? span : size.width;
                I.A(context, result, this.getPercentLabel(element), this.\u013f, this.\u0145, x + w / 2 - labelwidth / 2, y, 9);
            }
            Rectangle selectShape = new Rectangle(x - 1, y - h2 - 1, w + 2, h2 + 2);
            boolean spareFill = this.getSpareFill(element);
            Color spareCoverColor = this.getSpareCoverColor(element);
            Color spareColorx = this.getSpareColor(element);
            Color color = this.getPercentColor(element);
            int percentStyle = element.getChartPercentStyle();
            Color gradientColor = this.getGradientColor(element);
            Color spareGradientColor = this.getSpareGradientColor(element);
            if (percentStyle == 2) {
                Object fillObject;
                int r = w / 4;
                int solidy = y - r;
                int solidh = h2 - 2 * r;
                int length = (int)((double)solidh * percent);
                Ellipse2D.Float bottoms = new Ellipse2D.Float(x, solidy - r, w, r * 2);
                Ellipse2D.Float tops = new Ellipse2D.Float(x, solidy - solidh - r, w, r * 2);
                Ellipse2D.Float percents = new Ellipse2D.Float(x, solidy - length - r, w, r * 2);
                Rectangle rect = new Rectangle(x, solidy - solidh, w, solidh);
                Area area = new Area(rect);
                area.add(new Area(bottoms));
                area.add(new Area(tops));
                if (spareFill) {
                    fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                    I.A(context, result, area, fillObject);
                    fillObject = percent == 1.0 ? color : spareCoverColor;
                    I.A(context, result, tops, fillObject);
                    if (percent != 0.0) {
                        fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                        area = new Area(new Rectangle(x, solidy - length, w, length));
                        area.add(new Area(bottoms));
                        area.subtract(new Area(percents));
                        I.A(context, result, area, fillObject);
                    }
                    if (percent != 1.0) {
                        I.A(context, result, tops, this.\u014b, stroke);
                    }
                } else {
                    if (percent != 0.0) {
                        fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                        area = new Area(new Rectangle(x, solidy - length, w, length));
                        area.add(new Area(bottoms));
                        area.add(new Area(percents));
                        I.A(context, result, area, fillObject);
                        if (this.gradient) {
                            I.A(context, result, percents, color);
                        }
                        I.A(context, result, percents, color.darker(), stroke);
                    }
                    if (percent != 1.0) {
                        I.A(context, result, tops, this.\u014b, stroke);
                    }
                }
                if (this.\u0147 == 2) {
                    y -= r;
                    h2 -= 2 * r;
                }
                rect = new Rectangle(x, solidy - solidh, w, solidh);
                area = new Area(rect);
                area.add(new Area(tops));
                area.add(new Area(bottoms));
                I.A(context, result, area, this.\u014b, stroke);
            } else if (percentStyle == 3) {
                Rectangle2D.Double rec;
                int k2;
                double divider = percent * (double)this.\u0146;
                double proportionGap = (double)h2 / ((double)(this.\u0146 - 1) + this.\u0142);
                double valueGap = proportionGap * this.\u0142;
                Object fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                for (k2 = (int)divider; k2 < this.\u0146; ++k2) {
                    rec = new Rectangle2D.Double(x, (double)y - proportionGap * (double)k2 - valueGap, w, valueGap);
                    I.A(context, result, rec, fillObject);
                }
                fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                k2 = 0;
                while ((double)k2 <= divider - 1.0) {
                    rec = new Rectangle2D.Double(x, (double)y - proportionGap * (double)k2 - valueGap, w, valueGap);
                    I.A(context, result, rec, fillObject);
                    ++k2;
                }
                double startY = (double)y - proportionGap * (double)((int)divider) - valueGap * (divider % 1.0);
                Rectangle2D.Double rec2 = new Rectangle2D.Double(x, startY, w, valueGap * (divider % 1.0));
                I.A(context, result, rec2, fillObject);
            } else {
                if (spareFill) {
                    Object fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                    I.A(context, result, new Rectangle(x, y - h2, w, h2), fillObject);
                }
                I.A(context, result, (Shape)new Rectangle(x, y - h2, w, h2), this.\u014b, stroke);
                Object fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                I.A(context, result, new Rectangle(x + 1, (int)((double)y - (double)h2 * percent), w - 1, (int)((double)h2 * percent + 1.0)), fillObject);
            }
            this.A(context, result, x, y, w, h2, element);
            if (!element.isSelected()) continue;
            I.A(context, result, (Shape)selectShape, this.getSelectedColor(element), this.getSelectedStroke(element));
        }
    }

    private void C(SVGContext context, StringBuffer result, int width, int height) {
        int count = this.publishedElements.size();
        int span = (height - 2 * this.yGap) / count;
        if (span < 4) {
            span = 4;
        }
        int thick = this.\u013d > span - 4 ? span - 4 : this.\u013d;
        int maxLabelWidth = 0;
        if (this.\u0140 && !this.\u0141) {
            renderer.setFont(this.\u0145);
            renderer.setForeground(this.\u013f);
            for (int i2 = 0; i2 < count; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                I.A(context, result, this.getPercentLabel(element), this.\u013f, this.\u0145, this.xGap + this.\u014a, this.yGap + i2 * span + span / 2 - size.height / 2, 9);
                if (size.width + this.\u014a <= maxLabelWidth) continue;
                maxLabelWidth = size.width + this.\u014a;
            }
        }
        int gradientType = 20;
        for (int i3 = 0; i3 < count; ++i3) {
            Object fillObject;
            Element element = (Element)this.publishedElements.get(i3);
            double percent = this.A(element);
            Stroke stroke = this.getStroke(element);
            int x = this.xGap + maxLabelWidth + this.\u014a;
            int y = this.yGap + i3 * span + span / 2 - thick / 2;
            int w = width - maxLabelWidth - 2 * this.xGap - this.\u014a * 2;
            int h2 = thick;
            Rectangle selectShape = new Rectangle(x - 1, y - 1, w + 2, h2 + 2);
            Color color = this.getPercentColor(element);
            int percentStyle = element.getChartPercentStyle();
            boolean spareFill = this.getSpareFill(element);
            Color spareCoverColor = this.getSpareCoverColor(element);
            Color spareColorx = this.getSpareColor(element);
            Color gradientColor = this.getGradientColor(element);
            Color spareGradientColor = this.getSpareGradientColor(element);
            if (percentStyle == 2) {
                int r = h2 / 4;
                int solidx = x + r;
                int solidw = w - 2 * r;
                int length = (int)((double)solidw * percent);
                Ellipse2D.Float sleft = new Ellipse2D.Float(solidx - r, y, r * 2, h2);
                Ellipse2D.Float spercent = new Ellipse2D.Float(solidx - r + length, y, r * 2, h2);
                Ellipse2D.Float sright = new Ellipse2D.Float(solidx - r + solidw, y, r * 2, h2);
                Rectangle rect = new Rectangle(solidx, y, length, h2);
                Area area = new Area(rect);
                area.add(new Area(sleft));
                area.add(new Area(spercent));
                if (spareFill) {
                    Rectangle wholeRect = new Rectangle(solidx, y, solidw, h2);
                    Area wholeArea = new Area(wholeRect);
                    wholeArea.add(new Area(sleft));
                    fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                    I.A(context, result, wholeArea, fillObject);
                    fillObject = percent == 1.0 ? color : spareCoverColor;
                    I.A(context, result, sright, fillObject);
                    if (percent != 0.0) {
                        fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                        area.subtract(new Area(spercent));
                        I.A(context, result, area, fillObject);
                    }
                    if (percent != 1.0) {
                        I.A(context, result, sright, this.\u014b, stroke);
                    }
                } else {
                    if (percent != 0.0) {
                        fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                        I.A(context, result, area, fillObject);
                        if (this.gradient) {
                            I.A(context, result, spercent, color);
                        }
                        I.A(context, result, spercent, color.darker(), stroke);
                    }
                    if (percent != 1.0) {
                        I.A(context, result, sright, this.\u014b, stroke);
                    }
                }
                if (this.\u0147 == 2) {
                    x += r;
                    w -= 2 * r;
                }
                rect = new Rectangle(solidx, y, solidw, h2);
                area = new Area(rect);
                area.add(new Area(sleft));
                area.add(new Area(sright));
                I.A(context, result, area, this.\u014b, stroke);
            } else if (percentStyle == 3) {
                Rectangle2D.Double rec;
                int k2;
                double divider = percent * (double)this.\u0146;
                double proportionGap = (double)w / ((double)(this.\u0146 - 1) + this.\u0142);
                double valueGap = proportionGap * this.\u0142;
                fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                for (k2 = (int)divider; k2 < this.\u0146; ++k2) {
                    rec = new Rectangle2D.Double((double)x + proportionGap * (double)k2, y, valueGap, h2);
                    I.A(context, result, rec, fillObject);
                }
                fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                k2 = 0;
                while ((double)k2 <= divider - 1.0) {
                    rec = new Rectangle2D.Double((double)x + proportionGap * (double)k2, y, valueGap, h2);
                    I.A(context, result, rec, fillObject);
                    ++k2;
                }
                double startX = (double)x + proportionGap * (double)((int)divider);
                Rectangle2D.Double rec2 = new Rectangle2D.Double(startX, y, valueGap * (divider % 1.0), h2);
                I.A(context, result, rec2, fillObject);
            } else {
                if (spareFill) {
                    fillObject = this.gradient ? this.getGradientID(context, gradientType, spareGradientColor, spareColorx) : spareColorx;
                    I.A(context, result, new Rectangle(x, y, w, h2), fillObject);
                }
                I.A(context, result, (Shape)new Rectangle(x, y, w, h2), this.\u014b, stroke);
                fillObject = this.gradient ? this.getGradientID(context, gradientType, gradientColor, color) : color;
                I.A(context, result, new Rectangle(x + 1, y + 1, (int)((double)w * percent) - 1, h2 - 1), fillObject);
            }
            this.A(context, result, x, y, w, h2, element);
            if (this.\u0140 && this.\u0141) {
                renderer.setFont(this.\u0145);
                renderer.setForeground(this.\u013f);
                renderer.setText(this.getPercentLabel(element));
                Dimension size = renderer.getPreferredSize();
                I.A(context, result, this.getPercentLabel(element), this.\u013f, this.\u0145, x + w / 2 - size.width / 2, y + h2 / 2 - size.height / 2, 9);
            }
            if (!element.isSelected()) continue;
            I.A(context, result, (Shape)selectShape, this.getSelectedColor(element), this.getSelectedStroke(element));
        }
    }

    protected Color getSpareGradientColor(Element element) {
        return this.\u0144;
    }

    protected double getMarkerSize(Marker marker, int w, int h2) {
        if (this.\u013e == 1) {
            return (double)h2 / 4.0;
        }
        return (double)w / 4.0;
    }

    private void A(SVGContext context, StringBuffer result, int x, int y, int w, int h2, Element element) {
        List markers = element.getChartMarkers();
        if (markers != null) {
            for (int k2 = 0; k2 < markers.size(); ++k2) {
                double offset;
                Point2D.Double point;
                double divider;
                double spaceGap;
                double valueGap;
                Marker marker = (Marker)markers.get(k2);
                double markerOffset = marker.getYOffset();
                double percent = this.A(marker, element);
                renderer.setFont(marker.getTextFont());
                renderer.setForeground(marker.getTextColor());
                renderer.setText(marker.getText());
                Dimension size = renderer.getPreferredSize();
                double lineLength = 0.0;
                Point2D.Double startPoint = null;
                Point2D.Double endPoint = null;
                int markerPosition = this.getMarkerPosition(element);
                if (this.\u013e == 1) {
                    double textX = 0.0;
                    if (element.getChartPercentStyle() == 3) {
                        double proportionGap = (double)w / ((double)(this.\u0146 - 1) + this.\u0142);
                        valueGap = proportionGap * this.\u0142;
                        spaceGap = proportionGap * (1.0 - this.\u0142);
                        divider = percent * (double)this.\u0146;
                        double xValue = (double)x + proportionGap * (double)((int)divider) + valueGap * (divider % 1.0);
                        if (percent != 0.0 && divider % 1.0 == 0.0) {
                            xValue -= spaceGap;
                        }
                        textX = xValue - (double)(size.width / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(xValue, y + h2);
                                    endPoint = new Point2D.Double(xValue, (double)(y + h2) + lineLength);
                                } else {
                                    startPoint = new Point2D.Double(xValue, y);
                                    endPoint = new Point2D.Double(xValue, (double)y - lineLength);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(xValue, y + h2);
                                    endPoint = new Point2D.Double(xValue, (double)(y + h2) - lineLength);
                                } else {
                                    startPoint = new Point2D.Double(xValue, y);
                                    endPoint = new Point2D.Double(xValue, (double)y + lineLength);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(xValue, y);
                                endPoint = new Point2D.Double(xValue, (double)y - lineLength);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(xValue, y);
                                endPoint = new Point2D.Double(xValue, (double)y + lineLength);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(xValue, y + h2);
                                endPoint = new Point2D.Double(xValue, (double)(y + h2) - lineLength);
                            } else {
                                startPoint = new Point2D.Double(xValue, y + h2);
                                endPoint = new Point2D.Double(xValue, (double)(y + h2) + lineLength);
                            }
                        }
                    } else {
                        textX = (double)x + (double)w * percent - (double)(size.width / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) + lineLength);
                                } else {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y - lineLength);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) - lineLength);
                                } else {
                                    startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                    endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y + lineLength);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y - lineLength);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)y + lineLength);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) - lineLength);
                            } else {
                                startPoint = new Point2D.Double((double)x + (double)w * percent, y + h2);
                                endPoint = new Point2D.Double((double)x + (double)w * percent, (double)(y + h2) + lineLength);
                            }
                        }
                    }
                    point = startPoint;
                    if (startPoint != null) {
                        startPoint = new Point2D.Double(point.getX(), point.getY() + markerOffset);
                    }
                    if (endPoint != null) {
                        point = endPoint;
                        endPoint = new Point2D.Double(point.getX(), point.getY() + markerOffset);
                    }
                    offset = markerPosition == 1 ? (k2 % 2 == 1 ? (double)(-size.height) - lineLength - 2.0 : (double)h2 + lineLength + 2.0) : (markerPosition == 10 ? (k2 % 2 == 1 ? lineLength + 2.0 : (double)(h2 - size.height) - lineLength - 2.0) : (markerPosition == 2 || markerPosition == 6 ? (double)(-size.height) - lineLength - 2.0 : (markerPosition == 3 || markerPosition == 7 ? lineLength + 2.0 : (markerPosition == 5 || markerPosition == 9 ? (double)h2 - lineLength - (double)size.height - 2.0 : (double)h2 + lineLength + 2.0))));
                    I.A(context, result, marker.getText(), marker.getTextColor(), marker.getTextFont(), (int)textX, (int)((double)y + (offset += markerOffset)), 9);
                } else if (this.\u013e == 2) {
                    double textY = 0.0;
                    if (element.getChartPercentStyle() == 3) {
                        double proportionGap = (double)h2 / ((double)(this.\u0146 - 1) + this.\u0142);
                        valueGap = proportionGap * this.\u0142;
                        spaceGap = proportionGap * (1.0 - this.\u0142);
                        divider = percent * (double)this.\u0146;
                        double yValue = (double)y - proportionGap * (double)((int)divider) - (double)((int)(valueGap * (divider % 1.0)));
                        if (percent != 0.0 && divider % 1.0 == 0.0) {
                            yValue += spaceGap;
                        }
                        textY = yValue - (double)(size.height / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, yValue);
                                    endPoint = new Point2D.Double((double)(x + w) + lineLength, yValue);
                                } else {
                                    startPoint = new Point2D.Double(x, yValue);
                                    endPoint = new Point2D.Double((double)x - lineLength, yValue);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, yValue);
                                    endPoint = new Point2D.Double((double)(x + w) - lineLength, yValue);
                                } else {
                                    startPoint = new Point2D.Double(x, yValue);
                                    endPoint = new Point2D.Double((double)x + lineLength, yValue);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(x, yValue);
                                endPoint = new Point2D.Double((double)x - lineLength, yValue);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(x, yValue);
                                endPoint = new Point2D.Double((double)x + lineLength, yValue);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(x + w, yValue);
                                endPoint = new Point2D.Double((double)(x + w) - lineLength, yValue);
                            } else {
                                startPoint = new Point2D.Double(x + w, yValue);
                                endPoint = new Point2D.Double((double)(x + w) + lineLength, yValue);
                            }
                        }
                    } else {
                        textY = (double)y - (double)h2 * percent - (double)(size.height / 2);
                        if (marker.getShape() != 0) {
                            lineLength = this.getMarkerSize(marker, w, h2);
                            if (markerPosition == 1) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)(x + w) + lineLength, (double)y - (double)h2 * percent);
                                } else {
                                    startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)x - lineLength, (double)y - (double)h2 * percent);
                                }
                            } else if (markerPosition == 10) {
                                if (k2 % 2 == 0) {
                                    startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)(x + w) - lineLength, (double)y - (double)h2 * percent);
                                } else {
                                    startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                    endPoint = new Point2D.Double((double)x + lineLength, (double)y - (double)h2 * percent);
                                }
                            } else if (markerPosition == 2 || markerPosition == 6) {
                                startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)x - lineLength, (double)y - (double)h2 * percent);
                            } else if (markerPosition == 3 || markerPosition == 7) {
                                startPoint = new Point2D.Double(x, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)x + lineLength, (double)y - (double)h2 * percent);
                            } else if (markerPosition == 5 || markerPosition == 9) {
                                startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)(x + w) - lineLength, (double)y - (double)h2 * percent);
                            } else {
                                startPoint = new Point2D.Double(x + w, (double)y - (double)h2 * percent);
                                endPoint = new Point2D.Double((double)(x + w) + lineLength, (double)y - (double)h2 * percent);
                            }
                        }
                    }
                    point = startPoint;
                    if (startPoint != null) {
                        startPoint = new Point2D.Double(point.getX() + markerOffset, point.getY());
                    }
                    if (endPoint != null) {
                        point = endPoint;
                        endPoint = new Point2D.Double(point.getX() + markerOffset, point.getY());
                    }
                    offset = markerPosition == 1 ? (k2 % 2 == 1 ? (double)(-size.width - 2) - lineLength : (double)(w + 2) + lineLength) : (markerPosition == 10 ? (k2 % 2 == 1 ? 2.0 + lineLength : (double)(w - 2) - lineLength - (double)size.width) : (markerPosition == 2 || markerPosition == 6 ? (double)(-size.width - 2) - lineLength : (markerPosition == 3 || markerPosition == 7 ? lineLength + 2.0 : (markerPosition == 5 || markerPosition == 9 ? (double)w - lineLength - (double)size.width - 2.0 : (double)(w + 2) + lineLength))));
                    I.A(context, result, marker.getText(), marker.getTextColor(), marker.getTextFont(), (int)((double)x + (offset += markerOffset)), (int)textY, 9);
                }
                this.paintMarkerScale(context, result, marker, startPoint, endPoint);
            }
        }
    }

    protected int getMarkerPosition(Element element) {
        Object object = element.getClientProperty("chart.percent.marker.position");
        if (object != null && Integer.class.isAssignableFrom(object.getClass())) {
            return (Integer)object;
        }
        return this.\u0148;
    }

    private double A(Element element) {
        double value = this.getValue(element);
        double min = this.getMin(element);
        double max = this.getMax(element);
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return (value - min) / (max - min);
    }

    private double A(Marker marker, Element element) {
        double min = this.getMin(element);
        double max = this.getMax(element);
        return (marker.getValue() - min) / (max - min);
    }

    protected void paintMarkerScale(SVGContext context, StringBuffer result, Marker marker, Point2D.Double startPoint, Point2D.Double endPoint) {
        if (marker.getShape() == 1) {
            Line2D.Double line = new Line2D.Double(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
            I.A(context, result, line, marker.getTextColor(), TUIManager.getStrokeByType("solid.1"));
        } else if (marker.getShape() == 2) {
            Point2D.Double p1 = null;
            Point2D.Double p2 = null;
            double distance = TWaverUtil.getDistance(startPoint, endPoint);
            if (this.\u013e == 2) {
                p1 = new Point2D.Double(endPoint.x, endPoint.y - Math.tan(0.5235987755982988) * distance);
                p2 = new Point2D.Double(endPoint.x, endPoint.y + Math.tan(0.5235987755982988) * distance);
            } else if (this.\u013e == 1) {
                p1 = new Point2D.Double(endPoint.x - Math.tan(0.5235987755982988) * distance, endPoint.y);
                p2 = new Point2D.Double(endPoint.x + Math.tan(0.5235987755982988) * distance, endPoint.y);
            }
            GeneralPath path = new GeneralPath();
            path.moveTo((float)startPoint.x, (float)startPoint.y);
            path.lineTo((float)p1.x, (float)p1.y);
            path.lineTo((float)p2.x, (float)p2.y);
            path.closePath();
            I.A(context, result, path, marker.getTextColor());
        }
    }

    public Color getSpareColor(Element element) {
        Object object = element.getClientProperty("chart.percent.spare.color");
        if (object != null && Color.class.isAssignableFrom(object.getClass())) {
            return (Color)object;
        }
        if (this.\u0143 == null) {
            return TUIManager.getColor("chart.percent.spare.color");
        }
        return this.\u0143;
    }

    public Color getSpareCoverColor(Element element) {
        return element.getChartPercentSpareCoverColor();
    }

    public boolean getSpareFill(Element element) {
        Object object = element.getClientProperty("chart.percent.spare.fill");
        if (object != null && Boolean.class.isAssignableFrom(object.getClass())) {
            return (Boolean)object;
        }
        return this.\u0149;
    }

    public Color getPercentColor(Element element) {
        Color color = this.getColor(element);
        List markers = element.getChartMarkers();
        if (markers == null) {
            return color;
        }
        Collections.sort(markers);
        double value = this.getValue(element);
        int count = markers.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Marker marker = (Marker)markers.get(i2);
            if (i2 == 0 && value < marker.getValue()) {
                return color;
            }
            if (i2 < count - 1 && marker.getValue() <= value && value < ((Marker)markers.get(i2 + 1)).getValue()) {
                color = marker.getColor();
                break;
            }
            if (i2 != count - 1) continue;
            color = marker.getColor();
        }
        return color;
    }

    public String getPercentLabel(Element element) {
        double value = this.getValue(element);
        double min = this.getMin(element);
        double max = this.getMax(element);
        String name = this.getLegendLabel(element);
        int percent = (int)((value - min) / (max - min) * 100.0);
        if (name != null) {
            return name + " " + this.getFormat().format(percent) + "%";
        }
        return percent + "%";
    }

    public int getThickness() {
        return this.\u013d;
    }

    public void setThickness(int thickness) {
        this.\u013d = thickness;
    }

    public boolean isShowLabel() {
        return this.\u0140;
    }

    public void setShowLabel(boolean showLabel) {
        this.\u0140 = showLabel;
    }

    public Color getSpareColor() {
        return this.\u0143;
    }

    public void setSpareColor(Color spareColor) {
        this.\u0143 = spareColor;
    }

    public Color getOutlineColor() {
        return this.\u014b;
    }

    public void setOutlineColor(Color outlineColor) {
        this.\u014b = outlineColor;
    }

    public int getSegmentCount() {
        return this.\u0146;
    }

    public void setSegmentCount(int segmentCount) {
        this.\u0146 = segmentCount;
    }

    public int getPercentGap() {
        return this.\u014a;
    }

    public void setPercentGap(int percentGap) {
        this.\u014a = percentGap;
    }

    public boolean isPercentLabelCenter() {
        return this.\u0141;
    }

    public void setPercentLabelCenter(boolean percentLabelCenter) {
        this.\u0141 = percentLabelCenter;
    }

    public Color getPercentLabelColor() {
        return this.\u013f;
    }

    public void setPercentLabelColor(Color percentLabelColor) {
        this.\u013f = percentLabelColor;
    }

    public Font getPercentLabelFont() {
        return this.\u0145;
    }

    public void setPercentLabelFont(Font percentLabelFont) {
        this.\u0145 = percentLabelFont;
    }

    public boolean isPercentLabelVisible() {
        return this.\u0140;
    }

    public void setPercentLabelVisible(boolean percentLabelVisible) {
        this.\u0140 = percentLabelVisible;
    }

    public int getPercentType() {
        return this.\u013e;
    }

    public void setPercentType(int percentType) {
        this.\u013e = percentType;
    }

    public int getMarkerStartPosition() {
        return this.\u0147;
    }

    public void setMarkerStartPosition(int markStartPosition) {
        this.\u0147 = markStartPosition;
    }

    public double getSegmentSectionProrate() {
        return this.\u0142;
    }

    public void setSegmentSectionProrate(double segmentSectionProrate) {
        this.\u0142 = segmentSectionProrate;
    }

    public int getMarkerPosition() {
        return this.\u0148;
    }

    public void setMarkerPosition(int markerPosition) {
        this.\u0148 = markerPosition;
    }

    public Color getSpareGradientColor() {
        return this.\u0144;
    }

    public void setSpareGradientColor(Color spareGradientColor) {
        this.\u0144 = spareGradientColor;
    }

    public boolean isSpareFill() {
        return this.\u0149;
    }

    public void setSpareFill(boolean spareFill) {
        this.\u0149 = spareFill;
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }
}

