/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tabbedpane;

import com.nepxion.swing.icon.paint.CloseIcon;
import com.nepxion.swing.icon.paint.CloseTabIcon;
import com.nepxion.swing.tabbedpane.ITabbedPane;
import com.nepxion.swing.tabbedpane.TabbedPaneManager;
import com.nepxion.swing.tabbedpane.TabbedPanePopupMenuAdapter;
import com.nepxion.swing.tooltip.snap.JSnapToolTip;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class JBasicTabbedPane
extends JTabbedPane
implements ITabbedPane,
MouseListener {
    private JPopupMenu popupMenu;
    private TabbedPanePopupMenuAdapter popupMenuAdapter;
    private CloseIcon closeIcon;
    private boolean isDrawBorder = true;
    private boolean isDrawCenter = true;
    private boolean isHint = false;
    private boolean isSnapToolTip = false;
    private Map snapComponentMap;

    public JBasicTabbedPane() {
        this.initComponents();
    }

    public JBasicTabbedPane(int tabPlacement) {
        super(tabPlacement);
        this.initComponents();
    }

    public JBasicTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
        this.initComponents();
    }

    private void initComponents() {
        TabbedPaneManager.setPreferenceStyle(this);
        this.addMouseListener(this);
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    @Override
    public void addTab(String title, Component component, String toolTipText) {
        this.addTab(title, null, component, toolTipText);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        this.addTab(title, icon, component, null);
    }

    @Override
    public void addTab(String title, Component component, boolean isClosable) {
        this.addTab(title, null, component, isClosable);
    }

    @Override
    public void addTab(String title, Component component, String toolTipText, boolean isClosable) {
        this.addTab(title, null, component, toolTipText, isClosable);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String toolTipText) {
        this.addTab(title, icon, component, toolTipText, false);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, boolean isClosable) {
        this.addTab(title, icon, component, null, isClosable);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String toolTipText, boolean isClosable) {
        if (isClosable) {
            super.addTab(title, new CloseTabIcon(icon, this.isDrawBorder, this.isDrawCenter, this.isHint), component, toolTipText);
        } else {
            super.addTab(title, icon, component, toolTipText);
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String toolTipText, int index) {
        if (this.snapComponentMap != null) {
            toolTipText = "tab" + component.hashCode();
            this.snapComponentMap.put(toolTipText, component);
        }
        super.insertTab(title, icon, component, toolTipText, index);
    }

    @Override
    public JToolTip createToolTip() {
        if (this.snapComponentMap != null) {
            JSnapToolTip snapTooltip = new JSnapToolTip(this.snapComponentMap);
            snapTooltip.setComponent(this);
            return snapTooltip;
        }
        return super.createToolTip();
    }

    @Override
    public boolean isSnapToolTip() {
        return this.isSnapToolTip;
    }

    @Override
    public void setSnapToolTip(boolean isSnapToolTip) {
        this.isSnapToolTip = isSnapToolTip;
        this.snapComponentMap = isSnapToolTip ? new HashMap() : null;
    }

    public CloseIcon getCloseIcon(int index) {
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null) {
            return closeTabIcon.getCloseIcon();
        }
        return null;
    }

    public CloseTabIcon getCloseTabIcon(int index) {
        Icon icon = this.getIconAt(index);
        if (icon instanceof CloseTabIcon) {
            return (CloseTabIcon)icon;
        }
        return null;
    }

    public boolean isDrawBorder() {
        return this.isDrawBorder;
    }

    public void setDrawBorder(boolean isDrawBorder) {
        this.isDrawBorder = isDrawBorder;
    }

    public boolean isDrawBorder(int index) {
        CloseIcon closeIcon = this.getCloseIcon(index);
        if (closeIcon != null) {
            return closeIcon.isDrawBorder();
        }
        return false;
    }

    public void setDrawBorder(int index, boolean isDrawBorder) {
        CloseIcon closeIcon = this.getCloseIcon(index);
        if (closeIcon != null) {
            closeIcon.setDrawBorder(isDrawBorder);
            this.repaint();
        }
    }

    public boolean isDrawCenter() {
        return this.isDrawCenter;
    }

    public void setDrawCenter(boolean isDrawCenter) {
        this.isDrawCenter = isDrawCenter;
    }

    public boolean isDrawCenter(int index) {
        CloseIcon closeIcon = this.getCloseIcon(index);
        if (closeIcon != null) {
            return closeIcon.isDrawCenter();
        }
        return false;
    }

    public void setDrawCenter(int index, boolean isDrawCenter) {
        CloseIcon closeIcon = this.getCloseIcon(index);
        if (closeIcon != null) {
            closeIcon.setDrawCenter(isDrawCenter);
            this.repaint();
        }
    }

    public boolean isHint() {
        return this.isHint;
    }

    public void setHint(boolean isHint) {
        this.isHint = isHint;
    }

    public boolean isHint(int index) {
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null) {
            return closeTabIcon.isHint();
        }
        return false;
    }

    public void setHint(int index, boolean isHint) {
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null) {
            closeTabIcon.setHint(isHint);
            this.repaint();
        }
    }

    @Override
    public String getSelectedTitle() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getTitleAt(index);
    }

    @Override
    public Icon getIcon(int index) {
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null) {
            return closeTabIcon.getIcon();
        }
        return this.getIconAt(index);
    }

    @Override
    public boolean isTabClosableAt(int index) {
        CloseIcon closeIcon = this.getCloseIcon(index);
        return closeIcon != null;
    }

    @Override
    public void setTabClosableAt(int index, boolean isClosable) {
        if (isClosable) {
            CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
            if (closeTabIcon == null) {
                this.setIconAt(index, new CloseTabIcon(this.getIconAt(index), this.isDrawBorder, this.isDrawCenter, this.isHint));
            }
        } else {
            CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
            if (closeTabIcon != null) {
                this.setIconAt(index, closeTabIcon.getIcon());
            }
        }
    }

    @Override
    public Component getTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            return this.getComponentAt(i);
        }
        return null;
    }

    @Override
    public List getClosableTabs() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        return components;
    }

    @Override
    public void removeTabAt(int index) {
        if (this.snapComponentMap != null) {
            Component component = this.getComponentAt(index);
            this.snapComponentMap.remove("tab" + component.hashCode());
        }
        super.removeTabAt(index);
    }

    public void removeTabAt(String title) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            this.removeTabAt(i);
            break;
        }
    }

    @Override
    public void removeTabs(List closedComponents) {
        for (int i = 0; i < closedComponents.size(); ++i) {
            Component closedComponent = (Component)closedComponents.get(i);
            super.removeTabAt(this.indexOfComponent(closedComponent));
        }
    }

    @Override
    public void removeReverseTabsAt(int index) {
        ArrayList<Component> closedComponents = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (i == index || !this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            closedComponents.add(component);
        }
        this.removeTabs(closedComponents);
    }

    @Override
    public void removeAllTabs() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.isTabClosableAt(i)) continue;
            Component component = this.getComponentAt(i);
            components.add(component);
        }
        this.removeTabs(components);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu, boolean isClosable) {
        this.popupMenu = popupMenu;
        if (isClosable) {
            this.popupMenuAdapter = new TabbedPanePopupMenuAdapter(this, popupMenu);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Rectangle rect;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        int index = this.indexAtLocation(e.getX(), e.getY());
        if (index < 0) {
            return;
        }
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null && (rect = closeTabIcon.getBounds()).contains(e.getX(), e.getY())) {
            this.removeTabAt(index);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Rectangle rect;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        int index = this.indexAtLocation(e.getX(), e.getY());
        if (index < 0) {
            return;
        }
        CloseTabIcon closeTabIcon = this.getCloseTabIcon(index);
        if (closeTabIcon != null && (rect = closeTabIcon.getBounds()).contains(e.getX(), e.getY())) {
            this.closeIcon = closeTabIcon.getCloseIcon();
            this.closeIcon.setPressed(true);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.closeIcon != null) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.closeIcon.setPressed(false);
            this.repaint();
            this.closeIcon = null;
        }
        if (this.popupMenu != null) {
            int index = this.indexAtLocation(e.getX(), e.getY());
            if (index < 0) {
                return;
            }
            if (!e.isPopupTrigger()) {
                return;
            }
            this.setSelectedIndex(index);
            if (this.popupMenuAdapter != null) {
                this.popupMenuAdapter.adaptClosableItem(index);
            }
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

