/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TLayoutType;
import java.awt.Dimension;
import twaver.Element;
import twaver.Generator;
import twaver.Group;
import twaver.SpringLayouter;

public class TLayouter {
    public static final int MINIMUM_FORCE_SIZE = 10;
    public static final int MAXIMUM_FORCE_SIZE = 500;
    public static final int DEFAULT_FORCE_SIZE = 100;
    public static final int MINIMUM_STEP_SIZE = 1;
    public static final int MAXIMUM_STEP_SIZE = 1000;
    public static final int DEFAULT_STEP_SIZE = 500;
    public static final int MINIMUM_UPDATE_DURATION = 1;
    public static final int MAXIMUM_UPDATE_DURATION = 500;
    public static final int DEFAULT_UPDATE_DURATION = 10;
    public static final int MINIMUM_X_OFFSET = 0;
    public static final int MAXIMUM_X_OFFSET = 2000;
    public static final int DEFAULT_X_OFFSET = 150;
    public static final int MINIMUM_Y_OFFSET = 0;
    public static final int MAXIMUM_Y_OFFSET = 2000;
    public static final int DEFAULT_Y_OFFSET = 50;
    public static final int MINIMUM_X_GAP = 1;
    public static final int MAXIMUM_X_GAP = 500;
    public static final int DEFAULT_X_GAP = 50;
    public static final int MINIMUM_Y_GAP = 1;
    public static final int MAXIMUM_Y_GAP = 500;
    public static final int DEFAULT_Y_GAP = 50;
    private TGraph graph;
    private SpringLayouter layouter;

    public TLayouter(TGraph graph) {
        this.graph = graph;
        this.layouter = graph.getSpringLayouter();
        this.setForceSize(100);
        this.setStepSize(500);
        this.setUpdateDuration(10);
    }

    public int getForceSize() {
        return this.layouter.getForceSize();
    }

    public void setForceSize(int forceSize) {
        this.layouter.setForceSize(forceSize);
    }

    public int getStepSize() {
        return this.layouter.getStepSize();
    }

    public void setStepSize(int stepSize) {
        this.layouter.setStepSize(stepSize);
    }

    public int getUpdateDuration() {
        return this.layouter.getUpdateDuration();
    }

    public void setUpdateDuration(int updateDuration) {
        this.layouter.setUpdateDuration(updateDuration);
    }

    public TGraph getGraph() {
        return this.graph;
    }

    public SpringLayouter getSpringLayouter() {
        return this.layouter;
    }

    public void start() {
        this.layouter.start();
    }

    public void stop() {
        this.layouter.stop();
    }

    public void doLayout(TLayoutType layoutType) {
        this.doLayout(layoutType, 150, 50, 50, 50);
    }

    public void doLayout(TLayoutType layoutType, int xOffset, int yOffset, int xGap, int yGap) {
        this.doLayout(layoutType, true, true, xOffset, yOffset, xGap, yGap);
    }

    public void doLayout(TLayoutType layoutType, boolean isAllElementsLayouted, boolean isAnimated, int xOffset, int yOffset, final int xGap, final int yGap) {
        if (layoutType.equals(TLayoutType.SPRING_LAYOUT_TYPE)) {
            this.layouter.start();
        } else if (layoutType.equals(TLayoutType.RANDOM_LAYOUT_TYPE)) {
            this.layouter.stop();
            this.layouter.random(0, 600);
        } else {
            this.layouter.stop();
            this.graph.doLayout(isAllElementsLayouted ? this.graph.getDataBox().getAllElements().iterator() : this.graph.getDataBox().getSelectionModel().getAllSelectedElement().iterator(), layoutType.getType(), isAnimated, null, xOffset, yOffset, new Generator(){

                public Object generate(Object object) {
                    Element element = (Element)object;
                    if (element instanceof Group) {
                        return null;
                    }
                    return new Dimension(xGap, yGap);
                }
            });
        }
    }
}

