/*
 * Decompiled with CFR 0.152.
 */
package twaver.gis.gadget.inputhandler;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import twaver.Element;
import twaver.gis.GeographyMap;
import twaver.gis.GisBackground;
import twaver.network.TNetwork;
import twaver.network.background.Background;
import twaver.network.inputhandler.InputAdapter;

public class DefaultGisInterHandler
extends InputAdapter {
    protected GeographyMap map;
    private Point F;
    private Point B;
    private GisBackground E;
    private boolean D;
    private TNetwork C;
    private Element A;

    public DefaultGisInterHandler(TNetwork network, GeographyMap map) {
        this.map = map;
        this.C = network;
        Background bk = network.getCurrentBackground();
        if (bk instanceof GisBackground) {
            this.E = (GisBackground)bk;
        }
    }

    public DefaultGisInterHandler(GeographyMap map) {
        this.map = map;
    }

    protected boolean shouldPan() {
        return this.map.canPan() && this.A == null;
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.map != null && this.C != null) {
            this.F = e.getPoint();
            this.A = this.C.getElementPhysicalAt(e.getPoint());
            this.D = true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.shouldPan() || this.F == null) {
            return;
        }
        if (this.E != null) {
            if (this.D) {
                this.E.grab(e.getPoint());
                this.D = false;
            }
            this.E.drag(e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.shouldPan()) {
            if (this.E != null) {
                this.E.goBack();
            }
            return;
        }
        this.A = null;
        if (this.E != null) {
            int mode;
            this.map = this.E.getMap();
            if (this.map != null && (3 == (mode = this.map.getMapMode()) || -1 == mode)) {
                this.A(e);
            }
            this.E.releaseGrabbing();
        }
    }

    private void A(MouseEvent e) {
        this.B = e.getPoint();
        if (this.F != null && this.B.distance(this.F) > 5.0) {
            this.map.addBackAndForwardTask();
            this.E.panMap(this.F, this.B);
        }
        this.F = null;
        this.B = null;
    }
}

