/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import y.algo.Dfs;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YList;
import y.base.if;
import y.util.BoundedStack;
import y.util.Maps;

public class GraphConnectivity {
    public static NodeList[] connectedComponents(Graph graph) {
        NodeMap nodeMap = Maps.createIndexNodeMap(new int[graph.N()]);
        return GraphConnectivity.toNodeListArray(graph, nodeMap, GraphConnectivity.connectedComponents(graph, nodeMap));
    }

    public static int connectedComponents(Graph graph, NodeMap nodeMap) {
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            nodeMap.setInt(nodeCursor.node(), -1);
            nodeCursor.next();
        }
        int n = 0;
        BoundedStack boundedStack = new BoundedStack(graph.N());
        NodeCursor nodeCursor2 = graph.nodes();
        while (nodeCursor2.ok()) {
            Node node = nodeCursor2.node();
            if (nodeMap.getInt(node) == -1) {
                GraphConnectivity.a(node, boundedStack, nodeMap, n++);
            }
            nodeCursor2.next();
        }
        return n;
    }

    public static EdgeList makeConnected(Graph graph) {
        EdgeList edgeList = new EdgeList();
        NodeList[] nodeListArray = GraphConnectivity.connectedComponents(graph);
        int n = 0;
        while (n < nodeListArray.length - 1) {
            Edge edge = graph.createEdge(nodeListArray[n].firstNode(), nodeListArray[n + 1].lastNode());
            edgeList.add(edge);
            ++n;
        }
        return edgeList;
    }

    public static NodeList[] toNodeListArray(Graph graph, NodeMap nodeMap, int n) {
        NodeList[] nodeListArray = new NodeList[n];
        int n2 = 0;
        while (n2 < n) {
            nodeListArray[n2] = new NodeList();
            ++n2;
        }
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            nodeListArray[nodeMap.getInt(nodeCursor.node())].addLast(nodeCursor.node());
            nodeCursor.next();
        }
        return nodeListArray;
    }

    public static boolean isConnected(Graph graph) {
        return GraphConnectivity.connectedComponents(graph, Maps.createIndexNodeMap(new int[graph.N()])) <= 1;
    }

    private static void a(Node node, BoundedStack boundedStack, NodeMap nodeMap, int n) {
        boundedStack.push(node);
        nodeMap.setInt(node, n);
        while (!boundedStack.isEmpty()) {
            if if_;
            node = (Node)boundedStack.pop();
            Edge edge = node.firstOutEdge();
            while (edge != null) {
                if_ = edge.target();
                if (nodeMap.getInt(if_) == -1) {
                    nodeMap.setInt(if_, n);
                    boundedStack.push(if_);
                }
                edge = edge.nextOutEdge();
            }
            if_ = node.firstInEdge();
            while (if_ != null) {
                Node node2 = ((Edge)if_).source();
                if (nodeMap.getInt(node2) == -1) {
                    nodeMap.setInt(node2, n);
                    boundedStack.push(node2);
                }
                if_ = ((Edge)if_).nextInEdge();
            }
        }
    }

    public static EdgeList[] biconnectedComponents(Graph graph) {
        EdgeMap edgeMap = Maps.createIndexEdgeMap(new int[graph.E()]);
        int n = GraphConnectivity.biconnectedComponents(graph, edgeMap);
        return GraphConnectivity.toEdgeListArray(graph, edgeMap, n);
    }

    public static int biconnectedComponents(Graph graph, EdgeMap edgeMap) {
        return GraphConnectivity.biconnectedComponents(graph, edgeMap, Maps.createIndexNodeMap(new boolean[graph.N()]));
    }

    public static int biconnectedComponents(Graph graph, EdgeMap edgeMap, NodeMap nodeMap) {
        _a _a2 = new _a(edgeMap, nodeMap);
        _a2.start(graph);
        return _a2.i;
    }

    public static EdgeList[] toEdgeListArray(Graph graph, EdgeMap edgeMap, int n) {
        EdgeList[] edgeListArray = new EdgeList[n];
        int n2 = 0;
        while (n2 < n) {
            edgeListArray[n2] = new EdgeList();
            ++n2;
        }
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            edgeListArray[edgeMap.getInt(edgeCursor.edge())].add(edgeCursor.edge());
            edgeCursor.next();
        }
        return edgeListArray;
    }

    public static EdgeList makeBiconnected(Graph graph) {
        int n;
        EdgeList edgeList = new EdgeList();
        NodeMap nodeMap = Maps.createIndexNodeMap(new boolean[graph.N()]);
        EdgeMap edgeMap = Maps.createIndexEdgeMap(new int[graph.E()]);
        EdgeList[] edgeListArray = GraphConnectivity.toEdgeListArray(graph, edgeMap, n = GraphConnectivity.biconnectedComponents(graph, edgeMap, nodeMap));
        if (edgeListArray.length > 1) {
            if if_;
            Object object;
            NodeList nodeList = new NodeList();
            int n2 = 0;
            while (n2 < edgeListArray.length) {
                object = edgeListArray[n2];
                Node node = null;
                if (((YList)object).size() == 1) {
                    if_ = ((EdgeList)object).firstEdge();
                    if (((Edge)if_).source().degree() == 1) {
                        node = ((Edge)if_).source();
                    } else if (((Edge)if_).target().degree() == 1) {
                        node = ((Edge)if_).target();
                    }
                } else {
                    EdgeCursor edgeCursor = ((EdgeList)object).edges();
                    while (edgeCursor.ok()) {
                        if_ = edgeCursor.edge();
                        if (nodeMap.getBool(((Edge)if_).source())) {
                            if (node == null) {
                                node = ((Edge)if_).source();
                            } else if (node != ((Edge)if_).source()) {
                                node = null;
                                break;
                            }
                        }
                        if (nodeMap.getBool(((Edge)if_).target())) {
                            if (node == null) {
                                node = ((Edge)if_).target();
                            } else if (node != ((Edge)if_).target()) {
                                node = null;
                                break;
                            }
                        }
                        edgeCursor.next();
                    }
                    if (node != null) {
                        if_ = ((EdgeList)object).firstEdge();
                        node = ((Edge)if_).source() != node ? ((Edge)if_).source() : ((Edge)if_).target();
                    }
                }
                if (node != null) {
                    nodeList.add(node);
                }
                ++n2;
            }
            object = nodeList.popNode();
            while (!nodeList.isEmpty()) {
                if_ = nodeList.popNode();
                edgeList.push(graph.createEdge((Node)object, (Node)if_));
                object = if_;
            }
        }
        return edgeList;
    }

    public static boolean isBiconnected(Graph graph) {
        return GraphConnectivity.biconnectedComponents(graph, Maps.createIndexEdgeMap(new int[graph.E()])) <= 1;
    }

    public static void reachable(Graph graph, Node node, boolean bl, boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        GraphConnectivity.a(node, bl, blArray);
    }

    public static void reachable(Graph graph, Node node, boolean bl, boolean[] blArray, boolean[] blArray2) {
        int n = 0;
        while (n < blArray2.length) {
            blArray2[n] = false;
            ++n;
        }
        GraphConnectivity.a(node, bl, blArray, blArray2);
    }

    private static void a(Node node, boolean bl, boolean[] blArray, boolean[] blArray2) {
        blArray2[node.index()] = true;
        EdgeCursor edgeCursor = bl ? node.outEdges() : node.edges();
        while (edgeCursor.ok()) {
            Node node2;
            int n;
            Edge edge = edgeCursor.edge();
            if (!blArray[edge.index()] && !blArray2[n = (node2 = edge.opposite(node)).index()]) {
                GraphConnectivity.a(node2, bl, blArray, blArray2);
            }
            edgeCursor.next();
        }
    }

    private static void a(Node node, boolean bl, boolean[] blArray) {
        blArray[node.index()] = true;
        NodeCursor nodeCursor = bl ? node.successors() : node.neighbors();
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            int n = node2.index();
            if (!blArray[n]) {
                GraphConnectivity.a(node2, bl, blArray);
            }
            nodeCursor.next();
        }
    }

    static class _a
    extends Dfs {
        int[] h;
        int[] k;
        BoundedStack g;
        EdgeMap j;
        NodeMap m;
        boolean l;
        int i;

        _a(EdgeMap edgeMap, NodeMap nodeMap) {
            this.m = nodeMap;
            this.j = edgeMap;
            this.l = false;
        }

        public void start(Graph graph) {
            this.h = new int[graph.nodeCount()];
            this.k = new int[graph.nodeCount()];
            this.g = new BoundedStack(graph.E());
            super.start(graph);
        }

        protected void preVisit(Node node, int n) {
            int n2 = n;
            this.h[node.index()] = n2;
            this.k[node.index()] = n2;
        }

        protected void preTraverse(Edge edge, Node node, boolean bl) {
            this.g.push(edge);
            if (!bl) {
                Node node2 = edge.opposite(node);
                this.h[node2.index()] = Math.min(this.h[node2.index()], this.k[node.index()]);
            }
        }

        protected void lookFurther(Node node) {
            this.l = false;
        }

        protected void postTraverse(Edge edge, Node node) {
            Node node2 = edge.opposite(node);
            if (this.h[node.index()] >= this.k[node2.index()]) {
                while (this.g.top() != edge) {
                    this.j.setInt(this.g.pop(), this.i);
                }
                this.j.setInt(this.g.pop(), this.i);
                ++this.i;
                if (this.g.isEmpty()) {
                    if (this.l) {
                        this.m.setBool(node2, true);
                    } else {
                        this.l = true;
                    }
                } else {
                    this.m.setBool(node2, true);
                }
            }
            this.h[node2.index()] = Math.min(this.h[node2.index()], this.h[node.index()]);
        }
    }
}

