/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.network.CanvasMarker;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public class MagnifierInputHandler
extends InputAdapter
implements CanvasMarker {
    private TNetwork H = null;
    private Point G = null;
    private Shape J = null;
    private boolean F = false;
    private boolean I = false;

    public MagnifierInputHandler(TNetwork network) {
        this.H = network;
    }

    public void init() {
        this.H.getCanvas().setCursor(this.H.getDefaultCursor());
    }

    public void cleanup() {
        this.A(null);
    }

    public void mousePressed(MouseEvent e2) {
        this.F = true;
        this.A(null);
        if (SwingUtilities.isRightMouseButton(e2)) {
            JMenuItem item;
            String name;
            JPopupMenu popMenu = new JPopupMenu();
            JMenu menu = new JMenu(TWaverUtil.getString("Magnifier.Shape"));
            Map map = this.H.getMagnifier().getShapeMapper();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                name = it.next().toString();
                final Shape shape = (Shape)map.get(name);
                item = new JMenuItem(TWaverUtil.getString(name));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        MagnifierInputHandler.this.H.getMagnifier().setShape(shape);
                        MagnifierInputHandler.this.A(null);
                        MagnifierInputHandler.this.H.getCanvas().repaint();
                    }
                });
                menu.add(item);
            }
            popMenu.add(menu);
            menu = new JMenu(TWaverUtil.getString("Magnifier.Factor"));
            map = this.H.getMagnifier().getFactorMapper();
            it = map.keySet().iterator();
            while (it.hasNext()) {
                name = it.next().toString();
                final Double factor = (Double)map.get(name);
                item = new JMenuItem(TWaverUtil.getString(name));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e2) {
                        MagnifierInputHandler.this.H.getMagnifier().setZoomFactor(factor);
                        MagnifierInputHandler.this.A(null);
                        MagnifierInputHandler.this.H.getCanvas().repaint();
                    }
                });
                menu.add(item);
            }
            popMenu.add(menu);
            popMenu.show(this.H.getCanvas(), e2.getPoint().x, e2.getPoint().y);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e2) {
    }

    public void mouseMoved(MouseEvent e2) {
        if (this.F) {
            return;
        }
        this.A(e2.getPoint());
    }

    public void mouseReleased(MouseEvent e2) {
        this.F = false;
        this.A(e2.getPoint());
    }

    public void mouseExited(MouseEvent e2) {
        this.F = false;
        this.A(null);
    }

    private void A(Point point) {
        if (this.J != null) {
            Rectangle bounds = this.J.getBounds();
            bounds.grow(6, 6);
            this.H.getRenderer().repaintLogicalBounds(bounds);
        }
        if (point != null) {
            if (this.G == null) {
                this.H.addCanvasMarker(this);
            }
            double zoom = this.H.getZoomer().getZoom();
            this.G = new Point((int)(point.getX() / zoom), (int)(point.getY() / zoom));
            Rectangle rect = this.H.getMagnifier().getShape().getBounds();
            double magnifierX = this.G.getX() - rect.getWidth() / zoom / 2.0;
            double magnifierY = this.G.getY() - rect.getHeight() / zoom / 2.0;
            AffineTransform at = AffineTransform.getTranslateInstance(magnifierX, magnifierY);
            at.scale(1.0 / zoom, 1.0 / zoom);
            this.J = at.createTransformedShape(this.H.getMagnifier().getShape());
        } else {
            this.G = null;
            this.J = null;
            this.H.removeCanvasMarker(this);
        }
        if (this.J != null) {
            Rectangle bounds = this.J.getBounds();
            bounds.grow(6, 6);
            this.H.getRenderer().repaintLogicalBounds(bounds);
        }
    }

    public void mark(Graphics2D g2) {
        if (this.I) {
            return;
        }
        this.I = true;
        if (this.G != null) {
            Shape oldClip = g2.getClip();
            g2.setColor(this.H.getCanvas().getBackground());
            g2.fill(this.J);
            g2.setColor(Color.BLACK);
            g2.setStroke(TWaverConst.THINNEST_STROKE);
            g2.draw(this.J);
            double zoomFactor = this.H.getMagnifier().getZoomFactor();
            double xTranslate = this.G.getX() * zoomFactor - this.G.getX();
            double yTranslate = this.G.getY() * zoomFactor - this.G.getY();
            g2.clip(this.J);
            g2.translate(-xTranslate, -yTranslate);
            this.H.paintNetworkContent(g2, zoomFactor, zoomFactor, true);
            g2.translate(xTranslate, yTranslate);
            if (oldClip != null) {
                g2.setClip(oldClip);
            }
        }
        this.I = false;
    }
}

