/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import twaver.AlarmState;
import twaver.Element;
import twaver.ExportValuesInterceptor;
import twaver.GeoCoordinate;
import twaver.TDataBox;
import twaver.TPropertyDescriptor;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.C;
import twaver.base.A.E.H;
import twaver.base.A.E.Q;
import twaver.base.A.E.b;
import twaver.chart.Bubble;

public abstract class AbstractElement
implements Element {
    protected final Object id;
    protected String name = null;
    protected String displayName = null;
    protected String toolTipText = null;
    protected Object userObject = null;
    protected Object businessObject = null;
    protected boolean selected = false;
    protected AlarmState alarmState = this.createAlarmState();
    protected boolean visible = true;
    protected Element parent = null;
    protected String iconUrl = null;
    protected String imageUrl = null;
    private Object A = null;
    private boolean C = false;
    private GeoCoordinate B = null;
    protected Map delegate = this.createChildrenMap();
    protected List elements = this.createChildrenList();
    protected transient Map clientProperties = new LinkedHashMap();
    protected transient Map userProperties = new LinkedHashMap();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected AlarmState createAlarmState() {
        return new AlarmState(this);
    }

    protected List createChildrenList() {
        return new LinkedList();
    }

    protected Map createChildrenMap() {
        return new HashMap();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, TWaverUtil.valueOf(oldValue), TWaverUtil.valueOf(newValue));
    }

    public AbstractElement() {
        this.id = TWaverUtil.getIdentifier(this);
    }

    public AbstractElement(Object id) {
        this.id = id;
    }

    public Object getID() {
        return this.id;
    }

    public GeoCoordinate getGeoCoordinate() {
        return this.B;
    }

    public void setGeoCoordinate(GeoCoordinate geoCoordinate) {
        GeoCoordinate oldValue = this.B;
        this.B = geoCoordinate;
        this.firePropertyChange("geoCoordinate", oldValue, geoCoordinate);
    }

    public boolean isAdjustToBottom() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        String oldValue = this.displayName;
        this.displayName = displayName;
        this.firePropertyChange("displayName", oldValue, displayName);
    }

    public Object getClientProperty(Object key) {
        return this.clientProperties.get(key);
    }

    public Map getClientProperties() {
        return this.clientProperties;
    }

    public Element getParent() {
        return this.parent;
    }

    public void putClientProperty(Object key, Object value) {
        Object oldValue = this.clientProperties.get(key);
        if (value != null) {
            this.clientProperties.put(key, value);
        } else if (oldValue != null) {
            this.clientProperties.remove(key);
        }
        String propertyName = "CP:" + key.toString();
        this.firePropertyChange(propertyName, oldValue, value);
    }

    public void putClientProperty(Object key, int value) {
        this.putClientProperty(key, TWaverUtil.valueOf(value));
    }

    public void putClientProperty(Object key, boolean value) {
        this.putClientProperty(key, (Object)value);
    }

    public void setUserObject(Object userObject) {
        Object oldValue = this.userObject;
        this.userObject = userObject;
        this.firePropertyChange("userObject", oldValue, userObject);
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDescendantOf(Element element) {
        if (element == null) {
            return false;
        }
        if (element.isEmpty()) {
            return false;
        }
        for (Element tempParent = this.getParent(); tempParent != null; tempParent = tempParent.getParent()) {
            if (element != tempParent) continue;
            return true;
        }
        return false;
    }

    public void setSelected(boolean selected) {
        boolean oldValue = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldValue, selected);
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    public void removeFromParent() {
        this.setParent(null);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String tip) {
        String oldValue = this.toolTipText;
        this.toolTipText = tip;
        this.firePropertyChange("toolTipText", oldValue, this.toolTipText);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public AlarmState getAlarmState() {
        return this.alarmState;
    }

    public void setAlarmState(AlarmState newAlarmState) {
        if (newAlarmState == null) {
            throw new NullPointerException("alarm state can't be null.");
        }
        AlarmState oldAlarmState = this.alarmState;
        if (oldAlarmState != newAlarmState) {
            oldAlarmState.A((Element)null);
            this.alarmState = newAlarmState;
            this.alarmState.A(this);
        }
    }

    public Iterator children() {
        return this.elements.iterator();
    }

    public List getChildren() {
        return this.elements;
    }

    public void addChild(int index, Element element) {
        if (element == null) {
            return;
        }
        if (element == this) {
            return;
        }
        if (this.delegate.containsKey(element.getID())) {
            return;
        }
        if (this.isDescendantOf(element)) {
            return;
        }
        if (element.getParent() != null) {
            element.getParent().removeChild(element);
        }
        this.elements.add(index, element);
        this.delegate.put(element.getID(), element);
        element.setParent(this);
        this.firePropertyChange("children", null, element);
    }

    public void addChild(Element element) {
        this.addChild(this.elements.size(), element);
    }

    public void setParent(Element parent) {
        if (this.C || this.parent == parent || this == parent) {
            return;
        }
        if (parent != null && parent.isDescendantOf(this)) {
            return;
        }
        Element oldValue = this.parent;
        this.parent = parent;
        this.C = true;
        if (oldValue != null) {
            oldValue.removeChild(this);
        }
        if (parent != null) {
            parent.addChild(this);
        }
        this.C = false;
        this.firePropertyChange("parent", oldValue, parent);
    }

    public void removeChild(Element element) {
        if (element == null) {
            return;
        }
        if (!this.delegate.containsKey(element.getID())) {
            return;
        }
        this.elements.remove(element);
        this.delegate.remove(element.getID());
        this.firePropertyChange("children", this.elements, element);
        element.setParent(null);
    }

    public boolean isParentOf(Element element) {
        if (element == null) {
            return false;
        }
        return this.delegate.containsKey(element.getID());
    }

    public Element getChildrenByID(Object id) {
        return (Element)this.delegate.get(id);
    }

    public int childrenSize() {
        return this.elements.size();
    }

    public void clearChildren() {
        while (!this.elements.isEmpty()) {
            Element child = (Element)this.elements.get(0);
            this.removeChild(child);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    protected void exportValues(Element element, TDataBox box) {
        ExportValuesInterceptor interceptor = TWaverUtil.getExportValuesInterceptor();
        interceptor.exportValues(this, element, box);
    }

    public Element copy() {
        return this.copy(null);
    }

    public Element copy(Object id) {
        return this.copy(id, null);
    }

    public Element copy(TDataBox box) {
        try {
            Element newElement = (Element)this.getClass().newInstance();
            this.exportValues(newElement, box);
            return newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public Element copy(Object id, TDataBox box) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Object.class);
            Element newElement = (Element)constructor.newInstance(id);
            this.exportValues(newElement, box);
            return newElement;
        }
        catch (Exception ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public String getIconURL() {
        if (this.iconUrl != null) {
            return this.iconUrl;
        }
        return TUIManager.getIconUrl(this.getClass());
    }

    public ImageIcon getIcon() {
        String url = this.getIconURL();
        if (url != null) {
            return twaver.base.A.E.C.B(url);
        }
        return TUIManager.getIcon(this.getClass());
    }

    public void setIcon(String url) {
        if (url == null || url.trim().equals("")) {
            url = null;
        }
        String oldIconUrl = this.iconUrl;
        this.iconUrl = url;
        this.firePropertyChange("icon", oldIconUrl, this.iconUrl);
    }

    public String getImageURL() {
        if (this.imageUrl != null) {
            return this.imageUrl;
        }
        return TUIManager.getImageUrl(this.getClass());
    }

    public ImageIcon getImage() {
        String url = this.getImageURL();
        if (url != null) {
            return twaver.base.A.E.C.B(url);
        }
        return TUIManager.getImage(this.getClass());
    }

    public void setImage(String url) {
        if (url == null || url.trim().equals("")) {
            url = null;
        }
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        String oldUrl = this.imageUrl;
        this.imageUrl = url;
        this.firePropertyChange("image", oldUrl, this.imageUrl);
        this.firePropertyChange("width", oldWidth, this.getWidth());
        this.firePropertyChange("height", oldHeight, this.getHeight());
    }

    public void updateUI() {
        this.firePropertyChange("element.update.ui", Boolean.FALSE, Boolean.TRUE);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object value;
        Object key;
        Iterator it = this.clientProperties.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            value = this.clientProperties.get(key);
            if (!(key instanceof Serializable) || !(value instanceof Serializable)) continue;
            s.writeObject(key);
            s.writeObject(value);
        }
        s.writeObject(null);
        it = this.userProperties.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            value = this.userProperties.get(key);
            if (!(key instanceof Serializable) || !(value instanceof Serializable)) continue;
            s.writeObject(key);
            s.writeObject(value);
        }
        s.writeObject(null);
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object value;
        Object key;
        this.clientProperties = new LinkedHashMap();
        while (null != (key = s.readObject())) {
            value = s.readObject();
            this.clientProperties.put(key, value);
        }
        this.userProperties = new LinkedHashMap();
        while (null != (key = s.readObject())) {
            value = s.readObject();
            this.userProperties.put(key, value);
        }
        s.defaultReadObject();
    }

    public boolean isEnableAlarmPropagationFromChildren() {
        return this.alarmState.isEnablePropagationFromChildren();
    }

    public void setPropertyValue(TPropertyDescriptor property, Object newValue) {
        try {
            H.A(this, property, newValue);
        }
        catch (Exception e2) {
            TWaverUtil.handleError("can not write key:" + property.getElementAttribute().getKey(), e2);
        }
    }

    public Object getPropertyValue(TPropertyDescriptor property) {
        try {
            return H.A(this, property);
        }
        catch (Exception e2) {
            TWaverUtil.handleError("can not read key:" + property.getElementAttribute().getKey(), e2);
            return null;
        }
    }

    public Object getBusinessObject() {
        return this.businessObject;
    }

    public void setBusinessObject(Object businessObject) {
        Object oldValue = this.businessObject;
        this.businessObject = businessObject;
        this.firePropertyChange("businessObject", oldValue, businessObject);
    }

    public Object getUserProperty(Object key) {
        return this.userProperties.get(key);
    }

    public Map getUserProperties() {
        return this.userProperties;
    }

    public void putUserProperty(Object key, Object value) {
        Object oldValue = this.userProperties.get(key);
        if (value != null) {
            this.userProperties.put(key, value);
        } else if (oldValue != null) {
            this.userProperties.remove(key);
        }
        String propertyName = "UP:" + key.toString();
        this.firePropertyChange(propertyName, oldValue, value);
    }

    public void putUserProperty(Object key, int value) {
        this.putUserProperty(key, TWaverUtil.valueOf(value));
    }

    public void putUserProperty(Object key, boolean value) {
        this.putUserProperty(key, (Object)value);
    }

    public void setEnableAlarmPropagationFromChildren(boolean enableAlarmPropagationFromChildren) {
        this.alarmState.setEnablePropagationFromChildren(enableAlarmPropagationFromChildren);
    }

    public void addAttachment(String attachmentName) {
        this.putClientProperty((Object)("StateIcon:" + attachmentName), Boolean.TRUE);
    }

    public void removeAttachment(String attachmentName) {
        this.putClientProperty((Object)("StateIcon:" + attachmentName), null);
    }

    public boolean containsAttachment(String attachmentName) {
        return Boolean.TRUE.equals(this.getClientProperty("StateIcon:" + attachmentName));
    }

    public void putLabelIcon(String labelIcon) {
        this.putClientProperty((Object)"label.icon", labelIcon);
    }

    public void putLabelFont(Font labelFont) {
        this.putClientProperty((Object)"label.font", labelFont);
    }

    public void putLabelColor(Color labelColor) {
        this.putClientProperty((Object)"label.color", labelColor);
    }

    public void putLabelBackground(Color labelBackground) {
        this.putClientProperty((Object)"label.background", labelBackground);
    }

    public void putLabelVisible(boolean labelVisible) {
        this.putClientProperty((Object)"label.visible", labelVisible);
    }

    public void putLabelBorder(boolean labelBorder) {
        this.putClientProperty((Object)"label.border", labelBorder);
    }

    public void putLabelUnderline(boolean labelUnderline) {
        this.putClientProperty((Object)"label.underline", labelUnderline);
    }

    public void putLabelPosition(int labelPosition) {
        this.putClientProperty((Object)"label.position", labelPosition);
    }

    public void putLabelOrientation(int labelOrientation) {
        this.putClientProperty((Object)"label.orientation", labelOrientation);
    }

    public void putLabelXOffset(int labelXOffset) {
        this.putClientProperty((Object)"label.xoffset", labelXOffset);
    }

    public void putLabelYOffset(int labelYOffset) {
        this.putClientProperty((Object)"label.yoffset", labelYOffset);
    }

    public void putLabelXGap(int labelXGap) {
        this.putClientProperty((Object)"label.xgap", labelXGap);
    }

    public void putLabelYGap(int labelYGap) {
        this.putClientProperty((Object)"label.ygap", labelYGap);
    }

    public void putLabelBorderStroke(String labelBorderStroke) {
        this.putClientProperty((Object)"label.border.stroke", labelBorderStroke);
    }

    public void putLabelBorderColor(Color labelBorderColor) {
        this.putClientProperty((Object)"label.border.color", labelBorderColor);
    }

    public void putLabelUnderlineStroke(String labelUnderlineStroke) {
        this.putClientProperty((Object)"label.underline.stroke", labelUnderlineStroke);
    }

    public void putLabelUnderlineColor(Color labelUnderlineColor) {
        this.putClientProperty((Object)"label.underline.color", labelUnderlineColor);
    }

    public void putLabelSelectable(boolean labelSelectable) {
        this.putClientProperty((Object)"label.selectable", labelSelectable);
    }

    public void putLabelHighlightable(boolean labelHighlightable) {
        this.putClientProperty((Object)"label.highlightable", labelHighlightable);
    }

    public void putLabelHighlightBackground(Color labelHighlightBackground) {
        this.putClientProperty((Object)"label.highlight.background", labelHighlightBackground);
    }

    public void putLabelHighlightForeground(Color labelHighlightForeground) {
        this.putClientProperty((Object)"label.highlight.foreground", labelHighlightForeground);
    }

    public void putLabelMaxLength(int labelMaxLength) {
        this.putClientProperty((Object)"label.maxlength", labelMaxLength);
    }

    public void putDrawIconShape(boolean drawIconShape) {
        this.putClientProperty((Object)"draw.icon.shape", drawIconShape);
    }

    public void putRenderAlpha(float renderAlpha) {
        this.putClientProperty((Object)"render.alpha", new Float(renderAlpha));
    }

    public void putElementTreeIcon(Icon elementTreeIcon) {
        this.putClientProperty((Object)"element.tree.icon", elementTreeIcon);
    }

    public void putRenderColor(Color renderColor) {
        this.putClientProperty((Object)"render.color", renderColor);
    }

    public void putStateOutlineColor(Color stateOutlineColor) {
        this.putClientProperty((Object)"state.outline.color", stateOutlineColor);
    }

    public void putStateOutlineWidth(int stateOutlineWidth) {
        this.putClientProperty((Object)"state.outline.width", stateOutlineWidth);
    }

    public void putAttachmentPosition(int attachmentPosition) {
        this.putClientProperty((Object)"attachment.position", attachmentPosition);
    }

    public void putAttachmentOrientation(int attachmentOrientation) {
        this.putClientProperty((Object)"attachment.orientation", attachmentOrientation);
    }

    public void putAttachmentXOffset(int attachmentXOffset) {
        this.putClientProperty((Object)"attachment.xoffset", attachmentXOffset);
    }

    public void putAttachmentYOffset(int attachmentYOffset) {
        this.putClientProperty((Object)"attachment.yoffset", attachmentYOffset);
    }

    public void putAttachmentXGap(int attachmentXGap) {
        this.putClientProperty((Object)"attachment.xgap", attachmentXGap);
    }

    public void putAttachmentYGap(int attachmentYGap) {
        this.putClientProperty((Object)"attachment.ygap", attachmentYGap);
    }

    public void putAlarmBalloonPosition(int alarmBalloonPosition) {
        this.putClientProperty((Object)"alarm.balloon.position", alarmBalloonPosition);
    }

    public void putAlarmBalloonDirection(int alarmBalloonDirection) {
        this.putClientProperty((Object)"alarm.balloon.direction", alarmBalloonDirection);
    }

    public void putAlarmBalloonXoffset(int alarmBalloonXoffset) {
        this.putClientProperty((Object)"alarm.balloon.xoffset", alarmBalloonXoffset);
    }

    public void putAlarmBalloonYoffset(int alarmBalloonYoffset) {
        this.putClientProperty((Object)"alarm.balloon.yoffset", alarmBalloonYoffset);
    }

    public void putAlarmBalloonVisible(boolean alarmBalloonVisible) {
        this.putClientProperty((Object)"alarm.balloon.visible", alarmBalloonVisible);
    }

    public void putAlarmBalloonAlpha(float alarmBalloonAlpha) {
        this.putClientProperty((Object)"alarm.balloon.alpha", new Float(alarmBalloonAlpha));
    }

    public void putAlarmBalloonTextFont(Font alarmBalloonTextFont) {
        this.putClientProperty((Object)"alarm.balloon.text.font", alarmBalloonTextFont);
    }

    public void putAlarmBalloonTextColor(Color alarmBalloonTextColor) {
        this.putClientProperty((Object)"alarm.balloon.text.color", alarmBalloonTextColor);
    }

    public void putAlarmBalloonTextBlinkable(boolean alarmBalloonTextBlinkable) {
        this.putClientProperty((Object)"alarm.balloon.text.blinkable", alarmBalloonTextBlinkable);
    }

    public void putAlarmBalloonOutlineColor(Color alarmBalloonOutlineColor) {
        this.putClientProperty((Object)"alarm.balloon.outline.color", alarmBalloonOutlineColor);
    }

    public void putAlarmBalloonShadowColor(Color alarmBalloonShadowColor) {
        this.putClientProperty((Object)"alarm.balloon.shadow.color", alarmBalloonShadowColor);
    }

    public void putAlarmBalloonShadowOffset(int alarmBalloonShadowOffset) {
        this.putClientProperty((Object)"alarm.balloon.shadow.offset", alarmBalloonShadowOffset);
    }

    public void putTextureFactory(String textureFactory) {
        this.putClientProperty((Object)"texture.factory", textureFactory);
    }

    public void putBorderAntialias(boolean borderAntialias) {
        this.putClientProperty((Object)"border.antialias", (Object)borderAntialias);
    }

    public void putBorderVisible(boolean borderVisible) {
        this.putClientProperty((Object)"border.visible", (Object)borderVisible);
    }

    public void putBorderFill(boolean borderFill) {
        this.putClientProperty((Object)"border.fill", (Object)borderFill);
    }

    public void putBorderUnderneath(boolean borderUnderneath) {
        this.putClientProperty((Object)"border.underneath", (Object)borderUnderneath);
    }

    public void putBorderXormode(boolean borderXormode) {
        this.putClientProperty((Object)"border.xormode", (Object)borderXormode);
    }

    public void putBorderStroke(String borderStroke) {
        this.putClientProperty((Object)"border.stroke", borderStroke);
    }

    public void putBorderColor(Color borderColor) {
        this.putClientProperty((Object)"border.color", borderColor);
    }

    public void putBorderFillColor(Color borderFillColor) {
        this.putClientProperty((Object)"border.fill.color", borderFillColor);
    }

    public void putBorderInsets(int borderInsets) {
        this.putClientProperty((Object)"border.insets", borderInsets);
    }

    public void putBorderType(int borderType) {
        this.putClientProperty((Object)"border.type", borderType);
    }

    public void putBorderShapeFactory(int borderShapeFactory) {
        this.putClientProperty((Object)"border.shape.factory", borderShapeFactory);
    }

    public void putStateOutlineInsets(int stateOutlineInsets) {
        this.putClientProperty((Object)"state.outline.insets", stateOutlineInsets);
    }

    public void putMessageContent(String messageContent) {
        this.putClientProperty((Object)"message.content", messageContent);
    }

    public void putMessageGradient(boolean gradient) {
        this.putClientProperty((Object)"message.gradient", gradient);
    }

    public void putMessageGradientColor(Color color) {
        this.putClientProperty((Object)"message.gradient.color", color);
    }

    public void putMessageGradientFactory(int factory) {
        this.putClientProperty((Object)"message.gradient.factory", factory);
    }

    public boolean isMessageGradient() {
        return b.K(this, "message.gradient");
    }

    public Color getMessageGradientColor() {
        return b.P(this, "message.gradient.color");
    }

    public int getMessageGradientFactory() {
        return b.J(this, "message.gradient.factory");
    }

    public void putMessageStyle(int messageStyle) {
        this.putClientProperty((Object)"message.style", messageStyle);
    }

    public void putMessageComponent(int messageComponent) {
        this.putClientProperty((Object)"message.component", messageComponent);
    }

    public void putMessageWidth(int messageWidth) {
        this.putClientProperty((Object)"message.width", messageWidth);
    }

    public void putMessageHeight(int messageHeight) {
        this.putClientProperty((Object)"message.height", messageHeight);
    }

    public void putMessageTail(int messageTail) {
        this.putClientProperty((Object)"message.tail", messageTail);
    }

    public void putMessageArc(int messageArc) {
        this.putClientProperty((Object)"message.arc", messageArc);
    }

    public void putMessageShrinkable(boolean messageShrinkable) {
        this.putClientProperty((Object)"message.shrinkable", messageShrinkable);
    }

    public void putMessageMinimized(boolean minimized) {
        this.putClientProperty((Object)"message.minimized", minimized);
    }

    public void putMessageShrinked(boolean shrinked) {
        this.putClientProperty((Object)"message.shrinked", shrinked);
    }

    public void putMessageClosable(boolean messageClosable) {
        this.putClientProperty((Object)"message.closable", messageClosable);
    }

    public void putMessageMinimizable(boolean messageMinimizable) {
        this.putClientProperty((Object)"message.minimizable", messageMinimizable);
    }

    public void putMessageAutoAdjustDirection(boolean messageAutoAdjustDirection) {
        this.putClientProperty((Object)"message.auto.adjust.direction", messageAutoAdjustDirection);
    }

    public void putMessagePosition(int messagePosition) {
        this.putClientProperty((Object)"message.position", messagePosition);
    }

    public void putMessageDirection(int messageDirection) {
        this.putClientProperty((Object)"message.direction", messageDirection);
    }

    public void putMessageFont(Font messageFont) {
        this.putClientProperty((Object)"message.font", messageFont);
    }

    public void putMessageForeground(Color messageForeground) {
        this.putClientProperty((Object)"message.foreground", messageForeground);
    }

    public void putMessageBackground(Color messageBackground) {
        this.putClientProperty((Object)"message.background", messageBackground);
    }

    public void putMessageOpaque(boolean messageOpaque) {
        this.putClientProperty((Object)"message.opaque", messageOpaque);
    }

    public void putMessageXOffset(int messageXOffset) {
        this.putClientProperty((Object)"message.xoffset", messageXOffset);
    }

    public void putMessageYOffset(int messageYOffset) {
        this.putClientProperty((Object)"message.yoffset", messageYOffset);
    }

    public void putMessageXGap(int messageXGap) {
        this.putClientProperty((Object)"message.xgap", messageXGap);
    }

    public void putMessageYGap(int messageYGap) {
        this.putClientProperty((Object)"message.ygap", messageYGap);
    }

    public void putMessageMinimizedIcon(String messageMinimizedIcon) {
        this.putClientProperty((Object)"message.minimized.icon", messageMinimizedIcon);
    }

    public void putMessageShadowVisible(boolean messageShadowVisible) {
        this.putClientProperty((Object)"message.shadow.visible", messageShadowVisible);
    }

    public void putMessageShadowColor(Color messageShadowColor) {
        this.putClientProperty((Object)"message.shadow.color", messageShadowColor);
    }

    public void putMessageBorderColor(Color messageBorderColor) {
        this.putClientProperty((Object)"message.border.color", messageBorderColor);
    }

    public void putMessageBorderVisible(boolean messageBorderVisible) {
        this.putClientProperty((Object)"message.border.visible", messageBorderVisible);
    }

    public void putMessageBorderStroke(String messageBorderStroke) {
        this.putClientProperty((Object)"message.border.stroke", messageBorderStroke);
    }

    public void putChartColor(Color color) {
        this.putClientProperty((Object)"chart.color", color);
    }

    public void putChartValue(double value) {
        this.putClientProperty((Object)"chart.value", new Double(value));
    }

    public void putChartMin(double value) {
        this.putClientProperty((Object)"chart.min", new Double(value));
    }

    public void putChartMax(double value) {
        this.putClientProperty((Object)"chart.max", new Double(value));
    }

    public void putChartFormat(NumberFormat format) {
        this.putClientProperty((Object)"chart.format", format);
    }

    public void putChartValues(List values) {
        this.putClientProperty((Object)"chart.values", values);
    }

    public void putChartStroke(String stroke) {
        this.putClientProperty((Object)"chart.stroke", stroke);
    }

    public void putChartPercentStyle(int percentStyle) {
        this.putClientProperty((Object)"chart.percent.style", percentStyle);
    }

    public void putChartMarkers(List markers) {
        this.putClientProperty((Object)"chart.markers", markers);
    }

    public Icon getElementTreeIcon() {
        return b.A(this, "element.tree.icon");
    }

    public boolean isDrawIconShape() {
        return b.K(this, "draw.icon.shape");
    }

    public float getRenderAlpha() {
        return b.O(this, "render.alpha");
    }

    public Color getRenderColor() {
        return b.P(this, "render.color");
    }

    public Color getStateOutlineColor() {
        return b.P(this, "state.outline.color");
    }

    public int getStateOutlineWidth() {
        return b.J(this, "state.outline.width");
    }

    public String getTextureFactory() {
        return b.Q(this, "texture.factory");
    }

    public boolean getBorderAntialias() {
        return b.K(this, "border.antialias");
    }

    public boolean isBorderVisible() {
        return b.K(this, "border.visible");
    }

    public boolean isBorderFill() {
        return b.K(this, "border.fill");
    }

    public boolean isBorderUnderneath() {
        return b.K(this, "border.underneath");
    }

    public boolean isBorderXormode() {
        return b.K(this, "border.xormode");
    }

    public String getBorderStroke() {
        return b.Q(this, "border.stroke");
    }

    public Color getBorderColor() {
        return b.P(this, "border.color");
    }

    public Color getBorderFillColor() {
        return b.P(this, "border.fill.color");
    }

    public int getBorderInsets() {
        return b.J(this, "border.insets");
    }

    public int getBorderType() {
        return b.J(this, "border.type");
    }

    public int getBorderShapeFactory() {
        return b.J(this, "border.shape.factory");
    }

    public int getStateOutlineInsets() {
        return b.J(this, "state.outline.insets");
    }

    public String getLabelIcon() {
        return b.Q(this, "label.icon");
    }

    public Font getLabelFont() {
        return b.D(this, "label.font");
    }

    public Color getLabelColor() {
        return b.P(this, "label.color");
    }

    public Color getLabelBackground() {
        return b.P(this, "label.background");
    }

    public boolean isLabelVisible() {
        return b.K(this, "label.visible");
    }

    public boolean isLabelBorder() {
        return b.K(this, "label.border");
    }

    public boolean isLabelUnderline() {
        return b.K(this, "label.underline");
    }

    public int getLabelPosition() {
        return b.J(this, "label.position");
    }

    public int getLabelXOffset() {
        return b.J(this, "label.xoffset");
    }

    public int getLabelYOffset() {
        return b.J(this, "label.yoffset");
    }

    public int getLabelXGap() {
        return b.J(this, "label.xgap");
    }

    public int getLabelYGap() {
        return b.J(this, "label.ygap");
    }

    public int getLabelOrientation() {
        return b.J(this, "label.orientation");
    }

    public String getLabelBorderStroke() {
        return b.Q(this, "label.border.stroke");
    }

    public String getLabelUnderlineStroke() {
        return b.Q(this, "label.underline.stroke");
    }

    public boolean isLabelSelectable() {
        return b.K(this, "label.selectable");
    }

    public Color getLabelBorderColor() {
        return b.P(this, "label.border.color");
    }

    public Color getLabelUnderlineColor() {
        return b.P(this, "label.underline.color");
    }

    public boolean isLabelHighlightable() {
        return b.K(this, "label.highlightable");
    }

    public Color getLabelHighlightBackground() {
        return b.P(this, "label.highlight.background");
    }

    public Color getLabelHighlightForeground() {
        return b.P(this, "label.highlight.foreground");
    }

    public int getLabelMaxLength() {
        return b.J(this, "label.maxlength");
    }

    public int getAttachmentPosition() {
        return b.J(this, "attachment.position");
    }

    public int getAttachmentOrientation() {
        return b.J(this, "attachment.orientation");
    }

    public int getAttachmentXOffset() {
        return b.J(this, "attachment.xoffset");
    }

    public int getAttachmentYOffset() {
        return b.J(this, "attachment.yoffset");
    }

    public int getAttachmentXGap() {
        return b.J(this, "attachment.xgap");
    }

    public int getAttachmentYGap() {
        return b.J(this, "attachment.ygap");
    }

    public int getAlarmBalloonPosition() {
        return b.J(this, "alarm.balloon.position");
    }

    public int getAlarmBalloonDirection() {
        return b.J(this, "alarm.balloon.direction");
    }

    public int getAlarmBalloonXOffset() {
        return b.J(this, "alarm.balloon.xoffset");
    }

    public int getAlarmBalloonYOffset() {
        return b.J(this, "alarm.balloon.yoffset");
    }

    public boolean isAlarmBalloonVisible() {
        return b.K(this, "alarm.balloon.visible");
    }

    public float getAlarmBalloonAlpha() {
        return b.O(this, "alarm.balloon.alpha");
    }

    public Font getAlarmBalloonTextFont() {
        return b.D(this, "alarm.balloon.text.font");
    }

    public Color getAlarmBalloonTextColor() {
        return b.P(this, "alarm.balloon.text.color");
    }

    public boolean isAlarmBalloonTextBlinkable() {
        return b.K(this, "alarm.balloon.text.blinkable");
    }

    public Color getAlarmBalloonOutlineColor() {
        return b.P(this, "alarm.balloon.outline.color");
    }

    public Color getAlarmBalloonShadowColor() {
        return b.P(this, "alarm.balloon.shadow.color");
    }

    public int getAlarmBalloonShadowOffset() {
        return b.J(this, "alarm.balloon.shadow.offset");
    }

    public String getMessageContent() {
        return b.Q(this, "message.content");
    }

    public int getMessageWidth() {
        return b.J(this, "message.width");
    }

    public int getMessageHeight() {
        return b.J(this, "message.height");
    }

    public int getMessageComponent() {
        return b.J(this, "message.component");
    }

    public int getMessageStyle() {
        return b.J(this, "message.style");
    }

    public int getMessageTail() {
        return b.J(this, "message.tail");
    }

    public int getMessageArc() {
        return b.J(this, "message.arc");
    }

    public boolean isMessageShrinkable() {
        return b.K(this, "message.shrinkable");
    }

    public boolean isMessageShrinked() {
        return b.K(this, "message.shrinked");
    }

    public boolean isMessageClosable() {
        return b.K(this, "message.closable");
    }

    public boolean isMessageAutoAdjustDirection() {
        return b.K(this, "message.auto.adjust.direction");
    }

    public boolean isMessageMinimized() {
        return b.K(this, "message.minimized");
    }

    public boolean isMessageMinimizable() {
        return b.K(this, "message.minimizable");
    }

    public int getMessagePosition() {
        return b.J(this, "message.position");
    }

    public int getMessageDirection() {
        return b.J(this, "message.direction");
    }

    public Font getMessageFont() {
        return b.D(this, "message.font");
    }

    public Color getMessageForeground() {
        return b.P(this, "message.foreground");
    }

    public Color getMessageBackground() {
        return b.P(this, "message.background");
    }

    public boolean isMessageOpaque() {
        return b.K(this, "message.opaque");
    }

    public int getMessageXOffset() {
        return b.J(this, "message.xoffset");
    }

    public int getMessageYOffset() {
        return b.J(this, "message.yoffset");
    }

    public int getMessageXGap() {
        return b.J(this, "message.xgap");
    }

    public int getMessageYGap() {
        return b.J(this, "message.ygap");
    }

    public String getMessageMinimizedIcon() {
        return b.Q(this, "message.minimized.icon");
    }

    public boolean isMessageShadowVisible() {
        return b.K(this, "message.shadow.visible");
    }

    public Color getMessageShadowColor() {
        return b.P(this, "message.shadow.color");
    }

    public boolean isMessageBorderVisible() {
        return b.K(this, "message.border.visible");
    }

    public Color getMessageBorderColor() {
        return b.P(this, "message.border.color");
    }

    public String getMessageBorderStroke() {
        return b.Q(this, "message.border.stroke");
    }

    public Color getChartColor() {
        return b.P(this, "chart.color");
    }

    public double getChartValue() {
        return b.M(this, "chart.value");
    }

    public double getChartMin() {
        return b.M(this, "chart.min");
    }

    public double getChartMax() {
        return b.M(this, "chart.max");
    }

    public NumberFormat getChartFormat() {
        return b.G(this, "chart.format");
    }

    public void setChartValues(List values) {
        this.putClientProperty((Object)"chart.values", values);
    }

    public List getChartValues() {
        ArrayList values = (ArrayList)this.getClientProperty("chart.values");
        if (values == null && !Q.A()) {
            values = new ArrayList();
            this.putClientProperty((Object)"chart.values", values);
        }
        return values;
    }

    public String getChartStroke() {
        return b.Q(this, "chart.stroke");
    }

    public int getChartPercentStyle() {
        return b.J(this, "chart.percent.style");
    }

    public List getChartMarkers() {
        return b.L(this, "chart.markers");
    }

    public void putChartInflexionStyle(int inflexionStyle) {
        this.putClientProperty((Object)"chart.inflexion.style", inflexionStyle);
    }

    public int getChartInflexionStyle() {
        return b.J(this, "chart.inflexion.style");
    }

    public Object getLayerID() {
        return this.A;
    }

    public void setLayerID(Object layerID) {
        Object oldValue = this.A;
        this.A = layerID;
        this.firePropertyChange("layerID", oldValue, layerID);
    }

    public void addChartValue(double value) {
        List list = this.getChartValues();
        list.add(new Double(value));
        this.firePropertyChange("chart.values", null, list);
    }

    public void clearChartValues() {
        this.putClientProperty((Object)"chart.values", null);
    }

    public void addChartValue(Double value) {
        List list = this.getChartValues();
        list.add(value);
        this.firePropertyChange("chart.values", null, list);
    }

    public void putAlarmBalloonShownOnTop(boolean alarmBalloonShownOnTop) {
        this.putClientProperty((Object)"alarm.balloon.shown.on.top", alarmBalloonShownOnTop);
    }

    public void putMessageShownOnTop(boolean messageShownOnTop) {
        this.putClientProperty((Object)"message.shown.on.top", messageShownOnTop);
    }

    public boolean isAlarmBalloonShownOnTop() {
        return b.K(this, "alarm.balloon.shown.on.top");
    }

    public boolean isMessageShownOnTop() {
        return b.K(this, "message.shown.on.top");
    }

    public void putChartDialHandLength(double chartDialHandLength) {
        this.putClientProperty((Object)"chart.dial.hand.length", new Double(chartDialHandLength));
    }

    public double getChartDialHandLength() {
        return b.M(this, "chart.dial.hand.length");
    }

    public void putChartDialHandStyle(int chartDialHandStyle) {
        this.putClientProperty((Object)"chart.dial.hand.style", chartDialHandStyle);
    }

    public int getChartDialHandStyle() {
        return b.J(this, "chart.dial.hand.style");
    }

    public void putChartPercentSpareFill(boolean spareFill) {
        this.putClientProperty((Object)"chart.percent.spare.fill", spareFill);
    }

    public boolean getChartPercentSpareFill() {
        return b.K(this, "chart.percent.spare.fill");
    }

    public void putChartPercentSpareColor(Color spareColor) {
        this.putClientProperty((Object)"chart.percent.spare.color", spareColor);
    }

    public Color getChartPercentSpareColor() {
        return b.P(this, "chart.percent.spare.color");
    }

    public void putChartPercentSpareCoverColor(Color spareCoverColor) {
        this.putClientProperty((Object)"chart.percent.spare.cover.color", spareCoverColor);
    }

    public Color getChartPercentSpareCoverColor() {
        return b.P(this, "chart.percent.spare.cover.color");
    }

    public void putChartPercentMarkerPostion(int position) {
        this.putClientProperty((Object)"chart.percent.marker.position", position);
    }

    public int getChartPercentMarkerPostion() {
        return b.J(this, "chart.percent.marker.position");
    }

    public void addChartBubble(Bubble bubble) {
        List list = this.getChartValues();
        list.add(bubble);
        this.firePropertyChange("chart.values", null, list);
    }

    public void putChartBubbleStyle(int style) {
        this.putClientProperty((Object)"chart.bubble.style", style);
    }

    public int getChartBubbleStyle() {
        return b.J(this, "chart.bubble.style");
    }

    public void putChartBubbleShapeLineVisible(boolean visible) {
        this.putClientProperty((Object)"chart.bubble.shape.line.visible", visible);
    }

    public boolean getChartBubbleShapeLineVisible() {
        return b.K(this, "chart.bubble.shape.line.visible");
    }

    public void putChartBubbleShapeBubbleVisible(boolean visible) {
        this.putClientProperty((Object)"chart.bubble.shape.bubble.visible", visible);
    }

    public boolean getChartBubbleShapeBubbleVisible() {
        return b.K(this, "chart.bubble.shape.bubble.visible");
    }

    public void putChartValueTextPosition(int position) {
        this.putClientProperty((Object)"chart.value.text.position", position);
    }

    public int getChartValueTextPosition() {
        return b.J(this, "chart.value.text.position");
    }
}

