/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tooltip.polygon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class JPolygonToolTip
extends JPanel
implements MouseListener,
SwingConstants {
    private JFrame frame = null;
    private Color background = null;
    private Color foreground = null;
    private Color borderColor = null;
    private String content = null;
    private int direction = 4;

    public JPolygonToolTip(JFrame frame, Color backGround, Color foreground, Color borderColor, String content) {
        this.frame = frame;
        this.background = backGround;
        this.foreground = foreground;
        this.borderColor = borderColor;
        this.content = content;
        int firstRowIndex = content.indexOf("\n");
        String tooltip = "";
        tooltip = firstRowIndex > 0 ? content.substring(0, content.indexOf("\n")) : content;
        this.setSize(tooltip.length() * this.getFont().getSize() + 20, new StringTokenizer(content, "\n").countTokens() * 20 + 20);
        this.setOpaque(false);
        this.setVisible(false);
        frame.getLayeredPane().add((Component)this, JLayeredPane.POPUP_LAYER);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.background);
        AlphaComposite composite = AlphaComposite.getInstance(3, 0.7f);
        g2d.setComposite(composite);
        Area area = this.getArea();
        g2d.fill(area);
        g2d.setColor(this.foreground);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        StringTokenizer contentTokenizer = new StringTokenizer(this.content, "\n");
        int index = 20;
        while (contentTokenizer.hasMoreElements()) {
            g2d.drawString(contentTokenizer.nextToken(), 10, index);
            index += 20;
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.borderColor);
        Area area = this.getArea();
        g2d.draw(area);
    }

    private Area getArea() {
        if (this.direction == 2) {
            return this.getLeftArea();
        }
        return this.getRightArea();
    }

    private Area getLeftArea() {
        int width = this.getWidth();
        int height = this.getHeight();
        Area area = new Area(new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 10, 10.0f, 10.0f));
        Polygon polygon = new Polygon();
        polygon.addPoint(width - 25, height - 10);
        polygon.addPoint(width - 10, height - 10);
        polygon.addPoint(width, height);
        area.add(new Area(polygon));
        return area;
    }

    private Area getRightArea() {
        int width = this.getWidth();
        int height = this.getHeight();
        Area area = new Area(new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 10, 10.0f, 10.0f));
        Polygon polygon = new Polygon();
        polygon.addPoint(25, height - 10);
        polygon.addPoint(10, height - 10);
        polygon.addPoint(0, height);
        area.add(new Area(polygon));
        return area;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        Point p = e.getComponent().getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(p, e.getComponent().getParent());
        if (p.x + width > this.frame.getX()) {
            this.direction = 2;
            this.setLocation(new Point(p.x - width + 10, p.y - height + 10));
        } else {
            this.direction = 4;
            this.setLocation(new Point(p.x + e.getComponent().getWidth(), p.y - height + 10));
        }
        this.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

