/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.container;

import com.nepxion.swing.container.JContainer;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.panel.JInformationPanel;
import com.nepxion.swing.thread.container.AbstractThreadPanel;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public abstract class AbstractThreadContainer
extends JContainer {
    private String informationText;
    private Icon informationIcon;
    private String errorText;
    private Icon errorIcon;
    private JInformationPanel informationPanel = new JInformationPanel();
    private AbstractThreadPanel threadPanel;

    public AbstractThreadContainer(JLabel animationLabel, String information) {
        this.informationPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbstractThreadContainer.this.fireHidden();
            }
        });
        this.threadPanel = new AbstractThreadPanel(animationLabel, information){

            @Override
            public void fireHidden() {
                AbstractThreadContainer.this.fireHidden();
            }

            @Override
            public void fireCancelled() {
                AbstractThreadContainer.this.fireCancelled();
            }
        };
        this.setLayout(new BorderLayout());
    }

    public void reset() {
        this.threadPanel.reset();
    }

    public void start() {
        this.threadPanel.start();
    }

    public void start(int delayTime) {
        this.threadPanel.start(delayTime);
    }

    public void restart() {
        this.threadPanel.restart();
    }

    public void restart(int delayTime) {
        this.threadPanel.restart(delayTime);
    }

    public void stop() {
        this.threadPanel.stop();
    }

    public void finish() {
        this.threadPanel.finish();
    }

    public void showThread() {
        this.addComponent(this.threadPanel, "Center");
    }

    public void showInformation() {
        this.informationPanel.getLabel().setText(this.informationText);
        this.informationPanel.getLabel().setIcon(this.informationIcon);
        this.addComponent(this.informationPanel, "Center");
    }

    public void showError() {
        this.informationPanel.getLabel().setText(this.errorText + SwingLocale.getString("period") + SwingLocale.getString("return_to_result_page"));
        this.informationPanel.getLabel().setIcon(this.errorIcon);
        this.addComponent(this.informationPanel, "Center");
    }

    public AbstractThreadPanel getThreadPanel() {
        return this.threadPanel;
    }

    public JInformationPanel getInformationPanel() {
        return this.informationPanel;
    }

    public String getInformationText() {
        return this.informationText;
    }

    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    public Icon getInformationIcon() {
        return this.informationIcon;
    }

    public void setInformationIcon(Icon informationIcon) {
        this.informationIcon = informationIcon;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public Icon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(Icon errorIcon) {
        this.errorIcon = errorIcon;
    }

    public void setThreadPanelWidth(int width) {
        this.threadPanel.setWidth(width);
    }

    public void setThreadPanelHeight(int height) {
        this.threadPanel.setHeight(height);
    }

    public abstract void execute();

    protected abstract void fireHidden();

    protected abstract void fireCancelled();
}

