/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon;

import com.nepxion.swing.border.LineBorder;
import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.panel.JReflectionPanel;
import com.nepxion.swing.shrinkbar.JShrinkHeader;
import com.nepxion.swing.style.texture.shrink.IHeaderTextureStyle;
import com.nepxion.swing.style.texture.shrink.JBlueHeaderTextureStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JRibbonTweenPanel
extends JReflectionPanel {
    private JPanel contentBar;
    private JComponent contentPane;
    private int widthOffset;
    private int heightOffset;
    private IHeaderTextureStyle headerTextureStyle;
    private JShrinkHeader shrinkHeader;

    public JRibbonTweenPanel() {
        this(new JBlueHeaderTextureStyle());
    }

    public JRibbonTweenPanel(IHeaderTextureStyle headerTextureStyle) {
        this(20, 20, headerTextureStyle);
    }

    public JRibbonTweenPanel(int widthOffset, int heightOffset) {
        this(widthOffset, heightOffset, new JBlueHeaderTextureStyle());
    }

    public JRibbonTweenPanel(int widthOffset, int heightOffset, IHeaderTextureStyle headerTextureStyle) {
        this.widthOffset = widthOffset;
        this.heightOffset = heightOffset;
        this.headerTextureStyle = headerTextureStyle;
        this.shrinkHeader = new JShrinkHeader(1, headerTextureStyle);
        this.shrinkHeader.setShrinkable(false);
        this.contentBar = new JPanel();
        this.contentBar.setLayout(new BorderLayout());
        this.contentBar.add((Component)this.shrinkHeader, "North");
        this.setContent(this.contentBar);
    }

    public int getWidthOffset() {
        return this.widthOffset;
    }

    public int getHeightOffset() {
        return this.heightOffset;
    }

    public String getTitle() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getText();
    }

    public void setTitle(String title) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setText(title);
    }

    public Icon getIcon() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setIcon(icon);
    }

    @Override
    public String getToolTipText() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getToolTipText();
    }

    @Override
    public void setToolTipText(String toolTipText) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setToolTipText(toolTipText);
    }

    public Color getTitleColor() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getForeground();
    }

    public void setTitleColor(Color color) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setForeground(color);
    }

    public Font getTitleFont() {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        return this.shrinkHeader.getLabel().getFont();
    }

    public void setTitleFont(Font font) {
        if (this.shrinkHeader.getLabel() == null) {
            throw new IllegalArgumentException("It should be set content pane type with CONTENT_PANE_TYPE_LABEL");
        }
        this.shrinkHeader.getLabel().setFont(font);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(JComponent contentPane) {
        if (this.contentPane == contentPane) {
            return;
        }
        if (this.contentPane != null) {
            this.contentBar.remove(this.contentPane);
        }
        LineBorder lineBorder = new LineBorder(this.headerTextureStyle.getBorderColor());
        lineBorder.setColor(null, 1);
        this.contentPane = contentPane;
        this.contentPane.setBorder(BorderFactory.createCompoundBorder(lineBorder, this.contentPane.getBorder()));
        this.contentBar.add((Component)this.contentPane, "Center");
        ContainerManager.update(this.contentBar);
    }
}

