/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import twaver.RoundRect;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.base.A.E.b;
import twaver.base.A.E.d;
import twaver.base.A.E.m;
import twaver.base.A.I.B;
import twaver.network.TNetwork;
import twaver.network.ui.Attachment;
import twaver.network.ui.BorderUI;
import twaver.network.ui.LabelAttachment;
import twaver.network.ui.NodeUI;

public class RoundRectUI
extends NodeUI {
    private RoundRectangle2D.Float p = null;
    private Font o = null;
    private String q = null;

    public RoundRectUI(TNetwork network, RoundRect element) {
        super(network, element);
        this.removeAttachment(this.labelAttachment);
    }

    private void H() {
        this.o = this.labelAttachment != null ? this.labelAttachment.getFont() : TUIManager.getFont("label.font");
        this.q = m.A((B)this.network, this.element);
        if (this.q == null) {
            this.q = " ";
        }
        Rectangle bounds = d.A(this.q, this.o);
        this.p = new RoundRectangle2D.Float(this.element.getLocation().x - bounds.height, this.element.getLocation().y, bounds.width + bounds.height * 2, bounds.height, bounds.height, bounds.height);
    }

    public void paintStateOutline(Graphics2D g2d) {
    }

    public void paintBody(Graphics2D g2d) {
        Color outlineColor;
        this.H();
        Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (b.K(this.element, "border.antialias")) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isBodyFill()) {
            this.setBodyPaint(g2d, this.getPaintBodyColor(this.color));
            g2d.fill(this.p);
        }
        if ((outlineColor = this.getStateOutlineColor()) == null) {
            outlineColor = this.color.darker().darker();
        }
        g2d.setColor(outlineColor);
        g2d.setStroke(TWaverConst.BASIC_STROKE);
        g2d.draw(this.p);
        if (this.labelAttachment != null) {
            g2d.setColor(this.labelAttachment.getColor());
        } else {
            g2d.setColor(TUIManager.getColor("label.color"));
        }
        g2d.setFont(this.o);
        g2d.drawString(this.q, this.p.x + this.p.arcwidth, (float)(this.element.getLocation().y + 1 + this.o.getSize()));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
    }

    public Rectangle getUIBounds() {
        Rectangle borderRect;
        this.H();
        if (this.p == null) {
            return null;
        }
        Rectangle result = this.p.getBounds();
        BorderUI borderUI = this.getBorder();
        if (borderUI != null && (borderRect = borderUI.getBounds()) != null) {
            result.add(borderRect);
        }
        Iterator it = this.attachments();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            Rectangle attchmentBounds = attachment.getBounds();
            if (attchmentBounds == null) continue;
            result.add(attchmentBounds);
        }
        return result;
    }

    public boolean contains(int x, int y) {
        this.H();
        if (this.p == null) {
            return false;
        }
        return this.p.contains(x, y);
    }

    public void paintAttachments(Graphics2D g2d) {
        Iterator it = this.attachments.iterator();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            if (!this.network.isPaintable(attachment) || attachment instanceof LabelAttachment) continue;
            attachment.paint(g2d);
        }
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        super.elementPropertyChange(evt);
        this.labelAttachment.elementPropertyChange(evt);
    }

    public void paintBorder(Graphics2D g2d) {
        if (this.element.isSelected() && this.network.isSelectedStatePaintable(this.element)) {
            Object oldHinds = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (b.K(this.element, "border.antialias")) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g2d.setStroke(b.F(this.element, "border.stroke"));
            g2d.setColor(this.network.getElementSelectColor(this.element));
            g2d.draw(this.p);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHinds);
        }
    }
}

