/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.E.a;
import twaver.chart.AbstractScaleChart;
import twaver.chart.C;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGLineChart;
import twaver.web.svg.network.SVGContext;

public class LineChart
extends AbstractScaleChart {
    private boolean \u045a = TUIManager.getBoolean("tchart.interrupted.when.null.value");
    private int \u045b = TUIManager.getInt("tchart.line.type");
    private int \u045c = TUIManager.getInt("tchart.inflexion.style");
    private boolean \u0456 = TUIManager.getBoolean("tchart.inflexion.visible");
    private String \u0455 = TUIManager.getString("tchart.xscale.line.stroke");
    private Color \u0458 = TUIManager.getColor("tchart.xscale.line.color");
    private boolean \u0457 = TUIManager.getBoolean("tchart.xscale.line.visible");
    private double \u0459 = 0.0;
    private double \u045e = 0.0;

    public LineChart() {
        this(new TDataBox());
    }

    public LineChart(TDataBox box) {
        super(box, null, null);
        this.init();
    }

    public LineChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
        this.init();
    }

    public LineChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
        this.init();
    }

    public LineChart(List items) {
        super(items);
        this.init();
    }

    public LineChart(List items, String title) {
        super(items, title);
        this.init();
    }

    public LineChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
        this.init();
    }

    public LineChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
        this.init();
    }

    protected void init() {
        this.valueTextVisible = false;
        this.shadowOffset = 0;
    }

    protected int getXAxisExtraGap(Graphics2D g2d) {
        int gap = 0;
        if (this.xScaleTextVisible && this.xScaleTextList != null) {
            int count = this.xScaleTextList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String text = this.getXScaleText(i2);
                int h2 = this.B((int)this.xScaleTextOrientation, (String)text, (Font)this.xScaleTextFont).height;
                if (h2 <= gap) continue;
                gap = h2;
            }
        }
        if (gap > 0) {
            gap += this.textGap;
        }
        return gap;
    }

    protected void paintContent(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, int baseLine, double pixelGap, double valueGap) {
        this.\u0459 = 0.0;
        this.\u045e = 0.0;
        if (this.publishedElements.size() > 0 && this.proportions != null) {
            int i2;
            Element element = (Element)this.publishedElements.get(0);
            List list = (List)this.proportions.get(element);
            if (list == null) {
                return;
            }
            int count = list.size();
            if (this.endIndex < count) {
                count = this.endIndex;
            }
            if (this.startIndex != 0) {
                count -= this.startIndex;
            }
            if ((count = (count - 1) / this.valueSpanCount + 1) <= 0) {
                return;
            }
            double zeroLine = (double)baseLine + this.min / valueGap * pixelGap;
            double pillarWidth = (double)xAxisWidth / (double)count;
            if (pillarWidth == 0.0) {
                pillarWidth = 0.1;
            }
            this.\u0459 = (double)(this.xGap + this.shadowOffset + yAxisTextGap) + pillarWidth / 2.0;
            int end = list.size();
            if (this.endIndex < end) {
                end = this.endIndex;
            }
            for (i2 = 0; i2 < this.publishedElements.size(); ++i2) {
                element = (Element)this.publishedElements.get(i2);
                if (element.isSelected()) continue;
                this.A(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, baseLine, pixelGap, valueGap, element, i2, end, zeroLine, pillarWidth);
            }
            for (i2 = 0; i2 < this.publishedElements.size(); ++i2) {
                element = (Element)this.publishedElements.get(i2);
                if (!element.isSelected()) continue;
                this.A(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, baseLine, pixelGap, valueGap, element, i2, end, zeroLine, pillarWidth);
            }
        }
    }

    private void A(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, int baseLine, double pixelGap, double valueGap, Element element, int index, int end, double zeroLine, double pillarWidth) {
        double x = this.\u0459;
        ArrayList<Point> points = new ArrayList<Point>();
        ArrayList<Double> pointValues = new ArrayList<Double>();
        ArrayList<String> values = new ArrayList<String>();
        List list = (List)this.proportions.get(element);
        Point lastPoint = null;
        Stroke stroke = this.getStroke(element);
        for (int j2 = this.startIndex; j2 < end; j2 += this.valueSpanCount) {
            Double proportion;
            boolean drawXScale = true;
            if (this.xScaleTextSpanCount > 0 && (j2 - this.startIndex) % this.xScaleTextSpanCount != 0) {
                drawXScale = false;
            }
            if (drawXScale) {
                if (index == 0 && this.\u0457) {
                    g2d.setStroke(TUIManager.getStrokeByType(this.\u0455));
                    g2d.setColor(this.\u0458);
                    g2d.drawLine((int)x, this.yGap, (int)x, height - this.yGap - xAxisTextGap - this.shadowOffset);
                }
                if (index == 0 && this.xScaleTextVisible) {
                    this.A(g2d, this.xScaleTextOrientation, this.getXScaleText(j2), this.xScaleTextColor, this.xScaleTextFont, (int)x, height - this.yGap - xAxisTextGap + 2, 3);
                }
            }
            if ((proportion = (Double)list.get(j2)) != null) {
                Color color;
                double y = (double)baseLine - proportion * this.toValidHeight(yAxisHeight);
                Point currentPoint = new Point((int)x, (int)y);
                Shape segment = null;
                if (this.\u045b == 3) {
                    Line2D.Double line = new Line2D.Double(currentPoint.x, currentPoint.y, currentPoint.x, zeroLine);
                    segment = stroke.createStrokedShape(line);
                    if (element.isSelected()) {
                        g2d.setStroke(this.getSelectedStroke(element));
                        g2d.setColor(this.getSelectedColor(element));
                        g2d.draw(segment);
                    }
                    color = this.getColor(element);
                    g2d.setColor(color);
                    g2d.fill(segment);
                } else if (lastPoint != null) {
                    Color areaColor;
                    Line2D.Double line = new Line2D.Double(lastPoint, currentPoint);
                    segment = stroke.createStrokedShape(line);
                    if (element.isSelected()) {
                        g2d.setStroke(this.getSelectedStroke(element));
                        g2d.setColor(this.getSelectedColor(element));
                        g2d.draw(segment);
                    }
                    color = this.getColor(element);
                    g2d.setColor(color);
                    g2d.fill(segment);
                    if (this.\u045b == 2 && (areaColor = this.getAreaColor(element)) != null) {
                        GeneralPath path = new GeneralPath();
                        path.moveTo(lastPoint.x, (int)zeroLine);
                        path.lineTo(lastPoint.x, lastPoint.y);
                        path.lineTo(currentPoint.x, currentPoint.y);
                        path.lineTo(currentPoint.x, (int)zeroLine);
                        path.closePath();
                        g2d.setColor(areaColor);
                        g2d.fill(path);
                    }
                }
                points.add(currentPoint);
                double value = (Double)this.getValues(element).get(j2);
                pointValues.add(new Double(value));
                if (this.valueTextVisible) {
                    values.add(this.getFormatedText(element, value, j2));
                }
                if (segment != null) {
                    String lineToolTip = this.getLineToolTip(element, j2);
                    this.shapeStructs.add(0, new C(segment, element, lineToolTip, segment, -1));
                }
                lastPoint = currentPoint;
            } else if (this.\u045a) {
                lastPoint = null;
            }
            x += pillarWidth;
        }
        this.\u045e = x - pillarWidth;
        int count = points.size();
        for (int j3 = 0; j3 < count; ++j3) {
            Point point = (Point)points.get(j3);
            double value = Double.parseDouble(pointValues.get(j3).toString());
            Rectangle bounds = this.getInflexionBounds(element, point);
            String toolTipText = this.getToolTipText(element, value, j3);
            Rectangle shape = bounds;
            this.shapeStructs.add(0, new C(shape, element, toolTipText, shape, j3));
            if (this.\u0456) {
                this.paintInflexion(g2d, element, point);
            }
            if (!this.valueTextVisible) continue;
            String text = (String)values.get(j3);
            this.A(g2d, text, this.valueTextColor, this.valueTextFont, point.x + this.textGap + 1, point.y, this.getValueTextPosition(element, j3));
        }
    }

    protected String getLineToolTip(Element element, int nextIndex) {
        return null;
    }

    protected int getValueTextPosition(Element element, int index) {
        Object value = element.getClientProperty("chart.value.text.position");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (this.isValueTextCenter()) {
            return 1;
        }
        return this.valueTextPosition;
    }

    public Color getAreaColor(Element element) {
        Color color = this.getColor(element);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected void paintInflexion(Graphics2D g2d, Element element, Point point) {
        int inflexionStyle = this.getInflexionStyle(element);
        Rectangle bounds = this.getInflexionBounds(element, point);
        Shape shape = null;
        if (inflexionStyle == 1) {
            int x = bounds.x;
            int y = bounds.y;
            int width = bounds.width;
            int height = bounds.height;
            shape = new Ellipse2D.Float(x, y, width, height);
        } else if (inflexionStyle == 2) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height / 2);
            path.lineTo(bounds.x + bounds.width / 2, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height / 2);
            path.closePath();
            shape = path;
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            --bounds.x;
            --bounds.y;
            GeneralPath path = new GeneralPath();
            path.moveTo(bounds.x + bounds.width / 2, bounds.y);
            path.lineTo(bounds.x, bounds.y + bounds.height);
            path.lineTo(bounds.x + bounds.width, bounds.y + bounds.height);
            path.closePath();
            shape = path;
        }
        if (shape != null) {
            Color color = this.getColor(element);
            g2d.setColor(color);
            g2d.fill(shape);
        }
    }

    protected Rectangle getInflexionBounds(Element element, Point point) {
        Stroke stroke = this.getStroke(element);
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        Rectangle bounds = new Rectangle(point.x - w, point.y - w, w * 2 + 1, w * 2 + 1);
        if (this.getInflexionStyle(element) == 2) {
            if (bounds.width % 2 == 1) {
                ++bounds.width;
            }
            if (bounds.height % 2 == 1) {
                ++bounds.height;
            }
        }
        return bounds;
    }

    public boolean isInflexionVisible() {
        return this.\u0456;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u0456 = inflexionVisible;
        this.chartPane.repaint();
    }

    public void removeHead(int count) {
        int size = this.publishedElements.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Element element = (Element)this.publishedElements.get(i2);
            List valueList = this.getValues(element);
            for (int remain = count; remain > 0; --remain) {
                valueList.remove(0);
                if (i2 != 0 || this.xScaleTextList == null || this.xScaleTextList.size() <= 0) continue;
                this.xScaleTextList.remove(0);
            }
        }
        this.publishData(false);
    }

    public int valueCount() {
        if (this.publishedElements.size() == 0) {
            return 0;
        }
        Element element = (Element)this.publishedElements.get(0);
        return this.getValues(element).size();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.publishedElements.size(); ++i2) {
            Element element = (Element)this.publishedElements.get(i2);
            this.getValues(element).clear();
        }
        this.publishData(false);
    }

    protected void calculate() {
        this.calculateValuesProportionsOfRange(true, -1);
        this.calculateYScaleValueGap();
    }

    public boolean isXScaleLineVisible() {
        return this.\u0457;
    }

    public void setXScaleLineVisible(boolean scaleLineVisible) {
        this.\u0457 = scaleLineVisible;
        this.chartPane.repaint();
    }

    public int getInflexionStyle(Element element) {
        Object value = element.getClientProperty("chart.inflexion.style");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.\u045c;
    }

    public int getInflexionStyle() {
        return this.\u045c;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u045c = inflexionStyle;
        this.chartPane.repaint();
    }

    public String getXScaleLineStroke() {
        return this.\u0455;
    }

    public void setXScaleLineStroke(String xScaleLineStroke) {
        this.\u0455 = xScaleLineStroke;
        this.chartPane.repaint();
    }

    public Color getXScaleLineColor() {
        return this.\u0458;
    }

    public void setXScaleLineColor(Color scaleLineColor) {
        this.\u0458 = scaleLineColor;
        this.chartPane.repaint();
    }

    public int getLineType() {
        return this.\u045b;
    }

    public void setLineType(int lineType) {
        this.\u045b = lineType;
        this.chartPane.repaint();
    }

    public boolean isInterruptedWhenNullValue() {
        return this.\u045a;
    }

    public void setInterruptedWhenNullValue(boolean interruptedWhenNullValue) {
        this.\u045a = interruptedWhenNullValue;
        this.chartPane.repaint();
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        if (endIndex >= 0 && this.endIndex != endIndex) {
            this.endIndex = endIndex;
            this.publishData();
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        if (startIndex >= 0 && this.startIndex != startIndex) {
            this.startIndex = startIndex;
            this.publishData();
        }
    }

    public int getValueSpanCount() {
        return this.valueSpanCount;
    }

    public void setValueSpanCount(int valueSpanCount) {
        if (valueSpanCount >= 1) {
            this.valueSpanCount = valueSpanCount;
            this.publishData();
        }
    }

    public int getXScaleTextSpanCount() {
        return this.xScaleTextSpanCount;
    }

    public void setXScaleTextSpanCount(int scaleTextSpanCount) {
        this.xScaleTextSpanCount = scaleTextSpanCount;
        this.chartPane.repaint();
    }

    public double getEndX() {
        return this.\u045e;
    }

    public double getStartX() {
        return this.\u0459;
    }

    public void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        SVGLineChart chart = (SVGLineChart)abschart;
        chart.setInflexionVisible(this.isInflexionVisible());
        chart.setXScaleLineVisible(this.isXScaleLineVisible());
        chart.setInflexionStyle(this.getInflexionStyle());
        chart.setXScaleLineStroke(this.getXScaleLineStroke());
        chart.setXScaleLineColor(this.getXScaleLineColor());
        chart.setLineType(this.getLineType());
        chart.setInterruptedWhenNullValue(this.isInterruptedWhenNullValue());
        chart.setEndIndex(this.getEndIndex());
        chart.setStartIndex(this.getStartIndex());
        chart.setValueSpanCount(this.getValueSpanCount());
        chart.setXScaleTextSpanCount(this.getXScaleTextSpanCount());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGLineChart chart = new SVGLineChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

