/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.list;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.list.BasicListModel;
import com.nepxion.swing.list.IListAdapter;
import com.nepxion.swing.list.JBasicList;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import com.nepxion.util.data.CollectionUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;

public class ListController {
    public static void add(JBasicList list, IListAdapter listAdapter) {
        if (!listAdapter.addRowPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list") + SwingLocale.getString("add_record_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        Object rowData = listAdapter.addRow();
        if (rowData == null) {
            return;
        }
        BasicListModel listModel = (BasicListModel)list.getModel();
        listModel.addElement(rowData);
    }

    public static void modify(JBasicList list, IListAdapter listAdapter) {
        boolean isSingleSelection = ListController.isSingleSelection(list, SwingLocale.getString("modify") + SwingLocale.getString("record"));
        if (!isSingleSelection) {
            return;
        }
        int selectedRow = list.getSelectedIndex();
        if (!listAdapter.modifyRowPermitted(selectedRow)) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list_row_selection") + SwingLocale.getString("modify_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        Object rowData = listAdapter.modifyRow(selectedRow);
        if (rowData == null) {
            return;
        }
        BasicListModel listModel = (BasicListModel)list.getModel();
        listModel.setElementAt(rowData, selectedRow);
    }

    public static void delete(final JBasicList list, final IListAdapter listAdapter) {
        boolean isMultiSelection = ListController.isMultiSelection(list, SwingLocale.getString("delete") + SwingLocale.getString("record"));
        if (!isMultiSelection) {
            return;
        }
        final int[] selectedRows = list.getSelectedIndexes();
        if (selectedRows.length == 1) {
            final int selectedRow = selectedRows[0];
            if (!listAdapter.deleteRowPermitted(selectedRow)) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list_row_selection") + SwingLocale.getString("delete_no_permission"), SwingLocale.getString("warning"), 2);
                return;
            }
            int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(list), SwingLocale.getString("confirm_to_delete_selected_records"), SwingLocale.getString("confirm"), 0);
            if (selectedValue != 0) {
                return;
            }
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(list), SwingLocale.getString("clear"), SwingLocale.getString("clear_and_wait")){

                @Override
                protected void loadForeground(Object data) throws Exception {
                    Boolean flag = (Boolean)data;
                    if (flag.booleanValue()) {
                        BasicListModel listModel = (BasicListModel)list.getModel();
                        listModel.remove(selectedRow);
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("delete_record_success"), SwingLocale.getString("information"), 1);
                    }
                }

                @Override
                protected Object loadBackground() throws Exception {
                    return listAdapter.deleteRow(selectedRow);
                }
            };
            dialog.execute();
        } else {
            if (!listAdapter.deleteRowsPermitted(selectedRows)) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list_row_selection") + SwingLocale.getString("delete_no_permission"), SwingLocale.getString("warning"), 2);
                return;
            }
            int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(list), SwingLocale.getString("confirm_to_delete_selected_records"), SwingLocale.getString("confirm"), 0);
            if (selectedValue != 0) {
                return;
            }
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(list), SwingLocale.getString("clear"), SwingLocale.getString("clear_and_wait")){

                @Override
                protected void loadForeground(Object data) throws Exception {
                    Boolean flag = (Boolean)data;
                    if (flag.booleanValue()) {
                        BasicListModel listModel = (BasicListModel)list.getModel();
                        listModel.removeElements(selectedRows);
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("delete_record_success"), SwingLocale.getString("information"), 1);
                    }
                }

                @Override
                protected Object loadBackground() throws Exception {
                    return listAdapter.deleteRows(selectedRows);
                }
            };
            dialog.execute();
        }
    }

    public static void refresh(final JBasicList list, final IListAdapter listAdapter) {
        if (!listAdapter.refreshPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list") + SwingLocale.getString("refresh_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (list.getListData().size() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("no_refresh_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(list), SwingLocale.getString("confirm_to_refresh"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(list), SwingLocale.getString("refresh"), SwingLocale.getString("refresh_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                List rowDatas = (List)data;
                list.setListData(CollectionUtil.parseVector((List)rowDatas));
            }

            @Override
            protected Object loadBackground() throws Exception {
                List rowDatas = listAdapter.refresh();
                return rowDatas;
            }
        };
        dialog.execute();
    }

    public static void clear(final JBasicList list, final IListAdapter listAdapter) {
        if (!listAdapter.clearPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list") + SwingLocale.getString("clear_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (list.getListData().size() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("no_clear_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(list), SwingLocale.getString("confirm_to_clear"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(list), SwingLocale.getString("clear"), SwingLocale.getString("clear_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                Boolean flag = (Boolean)data;
                if (flag.booleanValue()) {
                    BasicListModel listModel = (BasicListModel)list.getModel();
                    listModel.clear();
                }
            }

            @Override
            protected Object loadBackground() throws Exception {
                return listAdapter.clear();
            }
        };
        dialog.execute();
    }

    public static void save(final JBasicList list, final IListAdapter listAdapter) {
        if (!listAdapter.savePermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("list") + SwingLocale.getString("save_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (list.getListData().size() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("no_save_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(list), SwingLocale.getString("confirm_to_save"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(list), SwingLocale.getString("save"), SwingLocale.getString("save_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                List rowDatas = (List)data;
                list.setListData(CollectionUtil.parseVector((List)rowDatas));
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("save_record_success"), SwingLocale.getString("information"), 1);
            }

            @Override
            protected Object loadBackground() throws Exception {
                List rowDatas = listAdapter.save();
                return rowDatas;
            }
        };
        dialog.execute();
    }

    public static boolean isSingleSelection(JBasicList list, String operationName) {
        int[] selectedRows = list.getSelectedIndexes();
        if (selectedRows == null || selectedRows.length == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("select_records_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (selectedRows.length != 1) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("select_one_node_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static boolean isMultiSelection(JBasicList list, String operationName) {
        int[] selectedRows = list.getSelectedIndexes();
        if (selectedRows == null || selectedRows.length == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(list), SwingLocale.getString("select_records_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static JSecurityAction getAddAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("add"), IconFactory.getSwingIcon("stereo/add_16.png"), SwingLocale.getString("add") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.add(list, listAdapter);
            }
        };
        KeyStrokeManager.registerComponent(list, action, 78, 2);
        return action;
    }

    public static JSecurityAction getModifyAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("modify"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("modify") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.modify(list, listAdapter);
            }
        };
        KeyStrokeManager.registerComponent(list, action, 73, 2);
        return action;
    }

    public static JSecurityAction getDeleteAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("delete"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("delete") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.delete(list, listAdapter);
            }
        };
        KeyStrokeManager.registerComponent((JComponent)list, (ActionListener)action, 127);
        return action;
    }

    public static JSecurityAction getRefreshAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("refresh"), IconFactory.getSwingIcon("stereo/refresh_16.png"), SwingLocale.getString("refresh") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.refresh(list, listAdapter);
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.clear(list, listAdapter);
            }
        };
        return action;
    }

    public static JSecurityAction getSaveAction(final JBasicList list, final IListAdapter listAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("save"), IconFactory.getSwingIcon("solid_save.png"), SwingLocale.getString("save") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                ListController.save(list, listAdapter);
            }
        };
        return action;
    }
}

