/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.YList;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.io.BadVersionException;
import y.layout.NodeLayout;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.LineType;
import y.view.NodeLabel;
import y.view.new;

public abstract class NodeRealizer
implements NodeLayout {
    private static final int o = 2;
    private static final int i = 4;
    private static final Color v = new Color(255, 255, 204);
    private static final Color k = new Color(212, 241, 236);
    private static final Color c = new Color(204, 240, 180);
    private static final Color p = new Color(204, 204, 255);
    private static final Color l = new Color(199, 236, 252);
    public static final byte HOTSPOT_NW = 0;
    public static final byte HOTSPOT_N = 1;
    public static final byte HOTSPOT_NE = 2;
    public static final byte HOTSPOT_SW = 3;
    public static final byte HOTSPOT_S = 4;
    public static final byte HOTSPOT_SE = 5;
    public static final byte HOTSPOT_W = 6;
    public static final byte HOTSPOT_E = 7;
    public static final byte HOTSPOT_NONE = 8;
    private Color j;
    private Color e;
    private Color b;
    private LineType r;
    private Stroke f;
    private boolean s;
    private ArrayList q;
    private boolean m;
    private int d;
    private byte u;
    private static Color a = Color.lightGray;
    private static Color t = Color.gray;
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    Node n;
    private static Rectangle2D.Double g = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);

    public NodeRealizer() {
        this(0.0, 0.0, "");
    }

    public NodeRealizer(double d2, double d3) {
        this(d2, d3, "");
    }

    public NodeRealizer(double d2, double d3, String string) {
        this.e = p;
        this.s = false;
        this.b = Color.black;
        this.r = LineType.LINE_1;
        this.width = 30.0;
        this.height = 30.0;
        this.x = d2 - this.width / 2.0;
        this.y = d3 - this.height / 2.0;
        this.f = LineType.LINE_1;
        this.q = new ArrayList(1);
        this.setLabel(new NodeLabel(string));
        this.a();
    }

    public NodeRealizer(NodeRealizer nodeRealizer) {
        this.e = nodeRealizer.e;
        this.j = nodeRealizer.j;
        this.s = nodeRealizer.s;
        this.b = nodeRealizer.b;
        this.width = nodeRealizer.width;
        this.height = nodeRealizer.height;
        this.x = nodeRealizer.x;
        this.y = nodeRealizer.y;
        this.r = nodeRealizer.r;
        this.f = nodeRealizer.f;
        int n = nodeRealizer.labelCount();
        this.q = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.addLabel((NodeLabel)nodeRealizer.getLabel(n2).clone());
            ++n2;
        }
        this.m = nodeRealizer.isSelected();
        this.a();
    }

    public NodeRealizer createCopy() {
        return this.createCopy(this);
    }

    public abstract NodeRealizer createCopy(NodeRealizer var1);

    public Node getNode() {
        return this.n;
    }

    public void setFillColor(Color color) {
        this.e = color;
    }

    public Color getFillColor() {
        return this.e;
    }

    public void setFillColor2(Color color) {
        this.j = color;
    }

    public Color getFillColor2() {
        return this.j;
    }

    public void setLineColor(Color color) {
        this.b = color;
    }

    public Color getLineColor() {
        return this.b;
    }

    public void setLineType(LineType lineType) {
        this.r = lineType;
    }

    public LineType getLineType() {
        return this.r;
    }

    public void setTransparent(boolean bl) {
        this.s = bl;
    }

    public boolean isTransparent() {
        return this.s;
    }

    public void setLabelText(String string) {
        this.getLabel().setText(string);
    }

    public String getLabelText() {
        return this.getLabel().getText();
    }

    public void setLabel(NodeLabel nodeLabel) {
        if (this.q.size() == 0) {
            this.q.add(nodeLabel);
        } else {
            this.q.set(0, nodeLabel);
        }
        nodeLabel.bindRealizer(this);
    }

    public void addLabel(NodeLabel nodeLabel) {
        this.q.add(nodeLabel);
        nodeLabel.bindRealizer(this);
    }

    public void removeLabel(NodeLabel nodeLabel) {
        this.q.remove(nodeLabel);
    }

    public NodeLabel getLabel() {
        return (NodeLabel)this.q.get(0);
    }

    public NodeLabel getLabel(int n) {
        return (NodeLabel)this.q.get(n);
    }

    public int labelCount() {
        return this.q.size();
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public void setCenter(double d2, double d3) {
        this.x = d2 - this.width / 2.0;
        this.y = d3 - this.height / 2.0;
        this.setEdgesDirty();
    }

    public void setCenterX(double d2) {
        this.setCenter(d2, this.getCenterY());
    }

    public void setCenterY(double d2) {
        this.setCenter(this.getCenterX(), d2);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double d2, double d3) {
        this.x = d2;
        this.y = d3;
        this.setEdgesDirty();
    }

    public void setX(double d2) {
        this.setLocation(d2, this.y);
    }

    public void setY(double d2) {
        this.setLocation(this.x, d2);
    }

    public void moveBy(double d2, double d3) {
        this.x += d2;
        this.y += d3;
        this.setEdgesDirty();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setFrame(double d2, double d3, double d4, double d5) {
        this.setSize(d4, d5);
        this.setLocation(d2, d3);
    }

    public void setFrame(Rectangle2D rectangle2D) {
        this.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.setLocation(rectangle2D.getX(), rectangle2D.getY());
    }

    public void setSize(double d2, double d3) {
        double d4 = (this.width - d2) / 2.0;
        double d5 = (this.height - d3) / 2.0;
        this.x += d4;
        this.y += d5;
        this.width = d2;
        this.height = d3;
        int n = 0;
        while (n < this.q.size()) {
            this.getLabel(n).setOffsetDirty();
            ++n;
        }
        this.setEdgesDirty();
    }

    public void setWidth(double d2) {
        this.setSize(d2, this.height);
    }

    public void setHeight(double d2) {
        this.setSize(this.width, d2);
    }

    public void setVisible(boolean bl) {
        this.d = !bl ? (this.d |= 4) : (this.d &= 0xFFFFFFFB);
    }

    public boolean isVisible() {
        return (this.d & 4) == 0;
    }

    public void setLayer(byte by) {
        this.u = by;
    }

    public byte getLayer() {
        return this.u;
    }

    public void setLayer(byte by, boolean bl) {
        if (bl && this.getNode() != null) {
            Graph2D graph2D = (Graph2D)this.getNode().getGraph();
            EdgeCursor edgeCursor = this.getNode().edges();
            while (edgeCursor.ok()) {
                graph2D.getRealizer(edgeCursor.edge()).setLayer(by);
                edgeCursor.next();
            }
        }
        this.setLayer(by);
    }

    public void setSelected(boolean bl) {
        if (bl != this.m) {
            this.m = bl;
            Graph2D graph2D = this.b();
            if (graph2D != null) {
                graph2D.fireGraph2DSelectionEvent(this.getNode());
            }
        }
    }

    public boolean isSelected() {
        return this.m;
    }

    public static void setHotSpotColor(Color color) {
        a = color;
    }

    public static Color getHotSpotColor() {
        return a;
    }

    public static void setSloppySelectionColor(Color color) {
        t = color;
    }

    public static Color getSloppySelectionColor() {
        return t;
    }

    public Rectangle2D.Double getBoundingBox() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public byte hotSpotHit(double d2, double d3) {
        if (!this.isSelected()) {
            return 8;
        }
        if (d2 < this.x - 6.0 || d2 > this.x + this.width + 7.0 || d3 < this.y - 6.0 || d3 > this.y + this.height + 7.0) {
            return 8;
        }
        if (d2 >= this.x && d2 <= this.x + this.width && d3 >= this.y && d3 <= this.y + this.height) {
            return 8;
        }
        if (d2 > this.x + this.width) {
            if (d3 < this.y) {
                return 2;
            }
            if (d3 > this.y + this.height) {
                return 5;
            }
            if (d3 >= this.y + this.height / 2.0 - 3.0 && d3 < this.y + this.height / 2.0 + 3.0) {
                return 7;
            }
        } else if (d2 < this.x) {
            if (d3 < this.y) {
                return 0;
            }
            if (d3 > this.y + this.height) {
                return 3;
            }
            if (d3 >= this.y + this.height / 2.0 - 3.0 && d3 < this.y + this.height / 2.0 + 3.0) {
                return 6;
            }
        } else if (d2 > this.x + this.width / 2.0 - 3.0 && d2 < this.x + this.width / 2.0 + 3.0) {
            if (d3 > this.y + this.height) {
                return 4;
            }
            if (d3 < this.y) {
                return 1;
            }
        }
        return 8;
    }

    public boolean findBBIntersection(double d2, double d3, double d4, double d5, Point2D point2D) {
        if (this.getCenterX() != d2 || this.getCenterY() != d3) {
            return false;
        }
        double d6 = d4 - this.getCenterX();
        double d7 = d5 - this.getCenterY();
        if (this.height < 1.0E-6 || this.width < 1.0E-6) {
            point2D.setLocation(this.getCenterX(), this.getCenterY());
        } else {
            double d8 = d7 > 0.0 ? 1.0 : -1.0;
            double d9 = this.height / 2.0 * d6 / (d7 = d8 * d7);
            if (Math.abs(d9) < this.width / 2.0) {
                point2D.setLocation(this.getCenterX() + d9, this.getCenterY() + d8 * this.height / 2.0);
            } else {
                d7 = d8 * d7;
                d8 = d6 > 0.0 ? 1.0 : -1.0;
                d6 = d8 * d6;
                double d10 = this.width / 2.0 * d7 / d6;
                point2D.setLocation(this.getCenterX() + d8 * this.width / 2.0, this.getCenterY() + d10);
            }
        }
        return true;
    }

    public boolean findIntersection(double d2, double d3, double d4, double d5, Point2D point2D) {
        double d6 = Math.sqrt((d4 - d2) * (d4 - d2) + (d5 - d3) * (d5 - d3));
        double d7 = (d4 - d2) / 2.0;
        double d8 = (d5 - d3) / 2.0;
        double d9 = d2 + d7;
        double d10 = d3 + d8;
        while (d6 > 0.1) {
            d6 /= 2.0;
            d7 /= 2.0;
            d8 /= 2.0;
            if (this.contains(d9, d10)) {
                d9 += d7;
                d10 += d8;
                continue;
            }
            d9 -= d7;
            d10 -= d8;
        }
        point2D.setLocation(d9, d10);
        return true;
    }

    public void calcUnionRect(Rectangle2D rectangle2D, byte by) {
        if (by == this.getLayer()) {
            this.calcUnionRect(rectangle2D);
        }
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (rectangle2D.getWidth() <= 0.0) {
            d5 = this.x;
            d4 = this.x + this.width;
            d3 = this.y;
            d2 = this.y + this.height;
        } else if (this.isSelected()) {
            d5 = Math.min(this.x - 6.0, rectangle2D.getX());
            d4 = Math.max(this.x + this.width + 6.0, rectangle2D.getX() + rectangle2D.getWidth());
            d3 = Math.min(this.y - 6.0, rectangle2D.getY());
            d2 = Math.max(this.y + this.height + 6.0, rectangle2D.getY() + rectangle2D.getHeight());
        } else {
            d5 = Math.min(this.x, rectangle2D.getX());
            d4 = Math.max(this.x + this.width, rectangle2D.getX() + rectangle2D.getWidth());
            d3 = Math.min(this.y, rectangle2D.getY());
            d2 = Math.max(this.y + this.height, rectangle2D.getY() + rectangle2D.getHeight());
        }
        int n = 0;
        while (n < this.q.size()) {
            YRectangle yRectangle = this.getLabel(n).getBox();
            d5 = Math.min(yRectangle.getX(), d5);
            d4 = Math.max(yRectangle.getX() + yRectangle.getWidth(), d4);
            d3 = Math.min(yRectangle.getY(), d3);
            d2 = Math.max(yRectangle.getY() + yRectangle.getHeight(), d2);
            ++n;
        }
        rectangle2D.setFrame(d5, d3, d4 - d5, d2 - d3);
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return d2 + d4 >= this.x && d2 <= this.x + this.width && d3 + d5 >= this.y && d3 <= this.y + this.height;
    }

    public boolean contains(double d2, double d3) {
        return d2 >= this.x && d2 <= this.x + this.width && d3 >= this.y && d3 <= this.y + this.height;
    }

    public boolean isInBox(double d2, double d3, double d4, double d5) {
        return !(this.getCenterX() > d2 + d4) && !(this.getCenterX() < d2 | this.getCenterY() > d3 + d5) && !(this.getCenterY() < d3);
    }

    public YList getPortCandidates(double d2) {
        double d3;
        double d4;
        double d5 = this.getCenterX() - (double)((int)(this.getWidth() / 2.0 / d2)) * d2;
        double d6 = this.getCenterY() - (double)((int)(this.getHeight() / 2.0 / d2)) * d2;
        YList yList = new YList();
        Point2D.Double double_ = new Point2D.Double();
        double d7 = this.getHeight() / 10.0;
        while (d5 < this.x + this.width) {
            d4 = this.getY() + 1.0;
            while (d4 < this.getY() + this.getHeight()) {
                if (this.contains(d5, d4)) {
                    this.findIntersection(d5, d4, d5, d4 - d7, double_);
                    yList.add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    break;
                }
                d4 += d7;
            }
            d3 = this.getY() + this.getHeight() - 1.0;
            while (d3 > this.getY()) {
                if (this.contains(d5, d3)) {
                    this.findIntersection(d5, d3, d5, d3 + d7, double_);
                    yList.add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    break;
                }
                d3 -= d7;
            }
            d5 += d2;
        }
        d7 = this.getWidth() / 10.0;
        while (d6 < this.y + this.height) {
            d4 = this.getX() + 1.0;
            while (d4 < this.getX() + this.getWidth()) {
                if (this.contains(d4, d6)) {
                    this.findIntersection(d4, d6, d4 - d7, d6, double_);
                    yList.add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    break;
                }
                d4 += d7;
            }
            d3 = this.getX() + this.getWidth() - 1.0;
            while (d3 > this.getX()) {
                if (this.contains(d3, d6)) {
                    this.findIntersection(d3, d6, d3 + 10.0, d6, double_);
                    yList.add(new YPoint(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    break;
                }
                d3 -= d7;
            }
            d6 += d2;
        }
        yList.add(new YPoint(this.getCenterX(), this.getCenterY()));
        return yList;
    }

    protected abstract void paintNode(Graphics2D var1);

    public void paintHotSpots(Graphics2D graphics2D) {
        graphics2D.setColor(a);
        double d2 = this.width / 2.0;
        double d3 = this.height / 2.0;
        NodeRealizer.g.x = this.x - 6.0;
        NodeRealizer.g.y = this.y - 6.0;
        graphics2D.fill(g);
        NodeRealizer.g.y = this.y + d3 - 2.0;
        graphics2D.fill(g);
        NodeRealizer.g.y = this.y + this.height + 2.0;
        graphics2D.fill(g);
        NodeRealizer.g.x = this.x + d2 - 2.0;
        graphics2D.fill(g);
        NodeRealizer.g.y = this.y - 6.0;
        graphics2D.fill(g);
        NodeRealizer.g.x = this.x + this.width + 2.0;
        graphics2D.fill(g);
        NodeRealizer.g.y = this.y + d3 - 2.0;
        graphics2D.fill(g);
        NodeRealizer.g.y = this.y + this.height + 2.0;
        graphics2D.fill(g);
    }

    public void paintLayer(Graphics2D graphics2D, byte by) {
        if (by == this.getLayer()) {
            this.paint(graphics2D);
        }
    }

    public void paintLayerSloppy(Graphics2D graphics2D, byte by) {
        if (by == this.getLayer()) {
            this.paintSloppy(graphics2D);
        }
    }

    public void paintSloppy(Graphics2D graphics2D) {
        if (this.width <= 0.0 || !this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            graphics2D.setColor(t);
            graphics2D.fillRect((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        } else if (this.e != null) {
            graphics2D.setColor(this.e);
            graphics2D.fillRect((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        }
        if (this.b != null) {
            graphics2D.setColor(this.b);
            graphics2D.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.width <= 0.0 || !this.isVisible()) {
            return;
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        this.paintNode(graphics2D);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public void paintText(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.q.size()) {
            this.getLabel(n).paint(graphics2D);
            ++n;
        }
    }

    public void setEdgesDirty() {
        if (this.n == null) {
            return;
        }
        EdgeCursor edgeCursor = this.n.edges();
        while (edgeCursor.ok()) {
            EdgeRealizer edgeRealizer = ((new)edgeCursor.edge()).l;
            if (edgeRealizer != null) {
                edgeRealizer.setDirty();
            }
            edgeCursor.next();
        }
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(2);
        objectOutputStream.writeInt(this.labelCount());
        int n = 0;
        while (n < this.labelCount()) {
            this.getLabel(n).write(objectOutputStream);
            ++n;
        }
        objectOutputStream.writeObject(this.e);
        objectOutputStream.writeObject(this.b);
        objectOutputStream.writeObject(this.j);
        objectOutputStream.writeFloat((float)this.width);
        objectOutputStream.writeFloat((float)this.height);
        objectOutputStream.writeFloat((float)this.x);
        objectOutputStream.writeFloat((float)this.y);
        objectOutputStream.writeBoolean(this.s);
        objectOutputStream.writeByte((byte)this.r.getLineWidth());
        objectOutputStream.writeByte(this.r.getLineStyle());
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 2: {
                int n = objectInputStream.readInt();
                this.q = new ArrayList(n);
                int n2 = 0;
                while (n2 < n) {
                    NodeLabel nodeLabel = new NodeLabel();
                    nodeLabel.read(objectInputStream);
                    this.addLabel(nodeLabel);
                    ++n2;
                }
                this.e = (Color)objectInputStream.readObject();
                this.b = (Color)objectInputStream.readObject();
                this.j = (Color)objectInputStream.readObject();
                this.setSize(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.setLocation(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.s = objectInputStream.readBoolean();
                this.r = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
                break;
            }
            case 1: {
                this.q = new ArrayList(1);
                NodeLabel nodeLabel = new NodeLabel();
                nodeLabel.read(objectInputStream);
                this.setLabel(nodeLabel);
                this.e = (Color)objectInputStream.readObject();
                this.b = (Color)objectInputStream.readObject();
                this.j = (Color)objectInputStream.readObject();
                this.setSize(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.setLocation(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.s = objectInputStream.readBoolean();
                this.r = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
                break;
            }
            case 0: {
                this.q = new ArrayList(1);
                NodeLabel nodeLabel = new NodeLabel();
                nodeLabel.read(objectInputStream);
                this.setLabel(nodeLabel);
                this.e = (Color)objectInputStream.readObject();
                this.b = (Color)objectInputStream.readObject();
                this.setSize(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.setLocation(objectInputStream.readFloat(), objectInputStream.readFloat());
                this.s = objectInputStream.readBoolean();
                this.r = LineType.getLineType(objectInputStream.readByte(), objectInputStream.readByte());
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
        this.a();
    }

    private void a() {
        this.d = 2;
        this.u = 0;
    }

    void a(Node node) {
        this.n = node;
        this.setEdgesDirty();
    }

    Graph2D b() {
        if (this.n != null) {
            return (Graph2D)this.n.getGraph();
        }
        return null;
    }
}

