/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.util.Map;
import y.base.Edge;
import y.base.Node;
import y.geom.YPoint;
import y.io.gml.EdgeGraphicsParser;
import y.io.gml.ItemParser;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;
import y.view.Port;

public class EdgeParser
extends ItemParser {
    private Graph2D aa;
    private Map y;
    private Map w;
    private Edge ab;
    private EdgeGraphicsParser p;
    private ItemParser q;
    private EdgeRealizer z;
    private YPoint r;
    private YPoint u;
    private double x;
    private double v;
    private double t;
    private double s;

    public EdgeParser(Graph2D graph2D, Map map, Map map2) {
        this.aa = graph2D;
        this.y = map;
        this.w = map2;
        this.q = new ItemParser();
        this.p = new EdgeGraphicsParser();
        this.addChild("graphics", this.p);
        this.addChild("edgeAnchor", this.q);
    }

    public void begin() {
        super.begin();
        this.z = null;
        this.ab = null;
        this.r = null;
        this.u = null;
        this.s = 0.0;
        this.t = 0.0;
        this.v = 0.0;
        this.x = 0.0;
    }

    public void childFinished(ItemParser itemParser) {
        if (itemParser == this.p) {
            this.z = this.p.getEdgeRealizer();
        } else if (itemParser == this.q) {
            this.x = this.q.getDouble("xSource");
            this.v = this.q.getDouble("ySource");
            this.t = this.q.getDouble("xTarget");
            this.s = this.q.getDouble("yTarget");
        }
    }

    public void end() {
        Edge edge;
        Node node = (Node)this.y.get(this.attributes.get("source"));
        Node node2 = (Node)this.y.get(this.attributes.get("target"));
        if (node == null || node2 == null) {
            return;
        }
        this.ab = edge = this.aa.createEdge(node, node2);
        Object v = this.attributes.get("id");
        if (this.z != null) {
            String string;
            this.aa.setRealizer(edge, this.z);
            NodeRealizer nodeRealizer = this.aa.getRealizer(edge.source());
            NodeRealizer nodeRealizer2 = this.aa.getRealizer(edge.target());
            if (this.x != 0.0 || this.v != 0.0) {
                this.z.setSourcePort(new Port(this.x * nodeRealizer.getWidth() / 2.0, this.v * nodeRealizer.getHeight() / 2.0));
            }
            if (this.t != 0.0 || this.s != 0.0) {
                this.z.setTargetPort(new Port(this.t * nodeRealizer2.getWidth() / 2.0, this.s * nodeRealizer2.getHeight() / 2.0));
            }
            if ((string = (String)this.attributes.get("label")) != null) {
                this.z.addLabel(new EdgeLabel(string));
            }
        }
        if (v != null) {
            this.w.put(v, edge);
        }
    }

    public Object getItem() {
        return this.ab;
    }
}

