/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import y.io.IOHandler;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.Util;

public abstract class ImageOutputHandler
extends IOHandler {
    private boolean a;

    protected ImageOutputHandler() {
        this(false);
    }

    protected ImageOutputHandler(boolean bl) {
        this.a = bl;
    }

    public boolean canRead() {
        return false;
    }

    public void read(Graph2D graph2D, InputStream inputStream) {
        throw new UnsupportedOperationException("read operation not supported");
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        Graph2DView graph2DView = (Graph2DView)graph2D.getCurrentView();
        Graph2DView graph2DView2 = graph2DView;
        if (graph2DView2 == null) {
            graph2DView2 = this.createDefaultGraph2DView(graph2D);
        }
        Dimension dimension = graph2DView2.getCanvasSize();
        BufferedImage bufferedImage = this.createImage(dimension.width, dimension.height);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        if (this.a) {
            Util.alias(graphics2D);
        }
        graph2DView2.paintVisibleContent(graphics2D);
        if (this.a) {
            Util.unalias(graphics2D);
        }
        if (graph2DView == null) {
            graph2D.removeView(graph2DView2);
        }
        this.encode(bufferedImage, outputStream);
    }

    protected abstract BufferedImage createImage(int var1, int var2);

    public Graph2DView createDefaultGraph2DView(Graph2D graph2D) {
        Graph2DView graph2DView = new Graph2DView(graph2D);
        Rectangle rectangle = graph2D.getBoundingBox();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        graph2DView.setSize(dimension);
        graph2DView.setPreferredSize(dimension);
        graph2DView.zoomToArea(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
        return graph2DView;
    }

    protected abstract void encode(BufferedImage var1, OutputStream var2) throws IOException;

    public boolean isAntialiasingEnabled() {
        return this.a;
    }

    public void setAntialiasingEnabled(boolean bl) {
        this.a = bl;
    }
}

