/*
 * Decompiled with CFR 0.152.
 */
package twaver.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.PaintSelectionStateFilter;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.E.a;
import twaver.chart.AbstractScaleChart;
import twaver.chart.C;
import twaver.chart.LabelStruct;
import twaver.chart.Pillar;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.chart.SVGBarChart;
import twaver.web.svg.network.SVGContext;

public class BarChart
extends AbstractScaleChart {
    private int \u0462 = TUIManager.getInt("tchart.bar.type");
    private List \u0463 = new ArrayList();
    private int \u0460 = TUIManager.getInt("tchart.bar.bundle.size");
    private boolean \u0461 = TUIManager.getBoolean("tchart.bar.percent.type.value.visible");
    private PaintSelectionStateFilter \u045f = null;

    public BarChart() {
        this(new TDataBox());
    }

    public BarChart(TDataBox box) {
        super(box, null, null);
        this.init();
    }

    public BarChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
        this.init();
    }

    public BarChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
        this.init();
    }

    public BarChart(List items) {
        super(items);
        this.init();
    }

    public BarChart(List items, String title) {
        super(items, title);
        this.init();
    }

    public BarChart(List items, String title, Color backgroundColor) {
        super(items, title, backgroundColor);
        this.init();
    }

    public BarChart(List items, String title, Color backgroundColor, Color foregroundColor) {
        super(items, title, backgroundColor, foregroundColor);
        this.init();
    }

    protected void init() {
        this.xAxisValue = 0.0;
        this.\u0454 = false;
        this.setLowerLimit(0.0);
    }

    private void m() {
        Element element;
        int i2;
        this.proportionsOfRange.clear();
        int count = this.publishedElements.size();
        this.max = 0.0;
        this.min = 0.0;
        if (this.upperLimit != -1.7976931348623157E308) {
            this.max = this.upperLimit;
        }
        if (this.lowerLimit != Double.MAX_VALUE) {
            this.min = this.lowerLimit;
        }
        if (this.upperLimit == -1.7976931348623157E308 || this.lowerLimit == Double.MAX_VALUE) {
            for (i2 = 0; i2 < count; ++i2) {
                element = (Element)this.publishedElements.get(i2);
                double value = this.getValue(element);
                if (this.upperLimit == -1.7976931348623157E308 && value > this.max) {
                    this.max = value;
                }
                if (this.lowerLimit != Double.MAX_VALUE || !(value < this.min)) continue;
                this.min = value;
            }
        }
        if (this.lowerLimit == Double.MAX_VALUE) {
            this.min -= (this.max - this.min) * 0.1;
        }
        this.range = this.max - this.min;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (this.range == 0.0) {
                this.proportionsOfRange.add(new Double(0.0));
                continue;
            }
            this.proportionsOfRange.add(new Double(this.getValue(element) / this.range));
        }
    }

    protected void calculate() {
        if (this.\u0462 == 1) {
            this.m();
        }
        if (this.xScaleTextList != null) {
            if (this.\u0462 == 2) {
                this.calculateValuesProportionsOfRange(false, -1);
            } else if (this.\u0462 == 3) {
                this.calculateValuesProportionsOfRange(false, this.xScaleTextList.size());
            } else if (this.\u0462 == 4) {
                this.calculateValuesProportionsOfRange(false, -1);
            } else if (this.\u0462 == 5) {
                this.calculatePercentValuesProportionsOfRange(this.xScaleTextList.size());
            }
        }
        this.calculateYScaleValueGap();
    }

    protected void calculatePercentValuesProportionsOfRange(int categoryCount) {
        this.proportions.clear();
        int count = this.publishedElements.size();
        double[] eachCategrorySum = null;
        if (categoryCount >= 0) {
            int i2;
            eachCategrorySum = new double[categoryCount];
            for (i2 = 0; i2 < categoryCount; ++i2) {
                eachCategrorySum[i2] = 0.0;
                for (int j2 = 0; j2 < count; ++j2) {
                    Object obj;
                    Element element = (Element)this.publishedElements.get(j2);
                    List list = this.getValues(element);
                    if (list.size() <= i2 || !((obj = list.get(i2)) instanceof Double)) continue;
                    double value = (Double)obj;
                    int n2 = i2;
                    eachCategrorySum[n2] = eachCategrorySum[n2] + value;
                }
            }
            for (i2 = 0; i2 < count; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                List values = this.getValues(element);
                int count2 = values.size();
                for (int j3 = 0; j3 < count2 && j3 < categoryCount; ++j3) {
                    ArrayList<Double> list = (ArrayList<Double>)this.proportions.get(element);
                    if (list == null) {
                        list = new ArrayList<Double>();
                        this.proportions.put(element, list);
                    }
                    if (j3 >= this.startIndex && j3 < this.endIndex && (j3 - this.startIndex) % this.valueSpanCount == 0) {
                        Object obj = values.get(j3);
                        if (obj == null) {
                            list.add(null);
                            continue;
                        }
                        double value = (Double)obj;
                        list.add(new Double(value / eachCategrorySum[j3]));
                        continue;
                    }
                    list.add(null);
                }
            }
        }
    }

    protected int getXAxisExtraGap(Graphics2D g2d) {
        if (this.\u0462 == 1) {
            return 0;
        }
        int gap = 0;
        if (this.xScaleTextList != null) {
            int count = this.xScaleTextList.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String text = this.getXScaleText(i2);
                int h2 = this.B((int)this.xScaleTextOrientation, (String)text, (Font)this.xScaleTextFont).height;
                if (h2 <= gap) continue;
                gap = h2;
            }
        }
        if (gap > 0) {
            gap += this.textGap;
        }
        return gap;
    }

    protected void paintContent(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, int baseLine, double pixelGap, double valueGap) {
        if (this.\u0462 == 1) {
            this.B(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, pixelGap, valueGap);
        }
        if (this.xScaleTextList != null) {
            if (this.\u0462 == 2) {
                this.D(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, pixelGap, valueGap);
            } else if (this.\u0462 == 3) {
                this.A(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, pixelGap, valueGap);
            } else if (this.\u0462 == 4) {
                this.C(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, pixelGap, valueGap);
            } else if (this.\u0462 == 5) {
                this.A(g2d, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, pixelGap, valueGap);
            }
        }
        int count = this.\u0463.size();
        for (int i2 = 0; i2 < count; ++i2) {
            LabelStruct struct = (LabelStruct)this.\u0463.get(i2);
            this.A(g2d, struct);
        }
        this.\u0463.clear();
    }

    private void A(Graphics2D g2d, int index, double x, double y) {
        String text = this.getXScaleText(index);
        this.A(g2d, this.xScaleTextOrientation, text, this.xScaleTextColor, this.xScaleTextFont, (int)x, (int)y, 3);
    }

    private void A(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, double pixelGap, double valueGap) {
        Double value;
        double pillarHeight;
        Double proportion;
        List list;
        Element element;
        int j2;
        int i2;
        double pillarWidth;
        int eCount = this.publishedElements.size();
        int cCount = this.xScaleTextList.size();
        int h2 = (int)(this.min / valueGap * pixelGap);
        int groupCount = cCount / this.\u0460;
        if (cCount % this.\u0460 != 0) {
            ++groupCount;
        }
        if ((pillarWidth = (double)xAxisWidth / (((double)this.\u0460 + 1.0) * (double)groupCount + 1.0)) == 0.0) {
            pillarWidth = 0.1;
        }
        double x = (double)(this.xGap + yAxisTextGap) + pillarWidth;
        for (i2 = 0; i2 < cCount; ++i2) {
            int yOffset = 0;
            int[] offsets = new int[eCount];
            for (j2 = eCount - 1; j2 >= 0; --j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list == null || list.size() <= i2 || (proportion = (Double)list.get(i2)) == null || !((pillarHeight = proportion * this.toValidHeight(yAxisHeight)) < 0.0)) continue;
                offsets[j2] = yOffset;
                yOffset = (int)((double)yOffset + pillarHeight);
            }
            for (j2 = 0; j2 < eCount; ++j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list == null || list.size() <= i2 || (proportion = (Double)list.get(i2)) == null || !((pillarHeight = proportion * this.toValidHeight(yAxisHeight)) < 0.0)) continue;
                value = (Double)this.getValues(element).get(i2);
                this.A(g2d, element, height, xAxisTextGap, pillarWidth, x, -offsets[j2], h2, pillarHeight, value, i2);
            }
            if ((i2 + 1) % this.\u0460 != 0) {
                x += pillarWidth;
                continue;
            }
            x += pillarWidth * 2.0;
        }
        if (this.xAxisVisible) {
            this.paintXAxis(g2d, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        x = (double)(this.xGap + yAxisTextGap) + pillarWidth;
        for (i2 = 0; i2 < cCount; ++i2) {
            this.A(g2d, i2, x + pillarWidth / 2.0, height - this.yGap - xAxisTextGap + this.textGap);
            double yOffset = 0.0;
            for (j2 = eCount - 1; j2 >= 0; --j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list == null || list.size() <= i2 || (proportion = (Double)list.get(i2)) == null || !((pillarHeight = proportion * this.toValidHeight(yAxisHeight)) > 0.0)) continue;
                value = (Double)this.getValues(element).get(i2);
                this.A(g2d, element, height, xAxisTextGap, pillarWidth, x, -yOffset, h2, pillarHeight, value, i2);
                yOffset += pillarHeight;
            }
            if ((i2 + 1) % this.\u0460 != 0) {
                x += pillarWidth;
                continue;
            }
            x += pillarWidth * 2.0;
        }
    }

    private void C(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, double pixelGap, double valueGap) {
        Double value;
        double pillarHeight;
        Double proportion;
        List list;
        Element element;
        int j2;
        int i2;
        int eCount = this.publishedElements.size();
        int cCount = this.xScaleTextList.size();
        int h2 = (int)(this.min / valueGap * pixelGap);
        double w = (double)xAxisWidth / ((double)(cCount * 5) + 1.0);
        double ww = w * 4.0;
        double gap = ww * 3.0 / 8.0 / ((double)eCount - 1.0);
        double x = (double)(this.xGap + yAxisTextGap) + 2.5 * w;
        for (i2 = 0; i2 < cCount; ++i2) {
            for (j2 = eCount - 1; j2 >= 0; --j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list == null || list.size() <= i2 || (proportion = (Double)list.get(i2)) == null || !((pillarHeight = proportion * this.toValidHeight(yAxisHeight)) < 0.0)) continue;
                value = (Double)this.getValues(element).get(i2);
                this.A(g2d, element, height, xAxisTextGap, w + (double)j2 * gap * 2.0, x - (double)j2 * gap, 0.0, h2, pillarHeight, value, i2);
            }
            x += w + ww;
        }
        if (this.xAxisVisible) {
            this.paintXAxis(g2d, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        x = (double)(this.xGap + yAxisTextGap) + 2.5 * w;
        for (i2 = 0; i2 < cCount; ++i2) {
            this.A(g2d, i2, x + w / 2.0, height - this.yGap - xAxisTextGap + this.textGap);
            for (j2 = eCount - 1; j2 >= 0; --j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list == null || list.size() <= i2 || (proportion = (Double)list.get(i2)) == null || !((pillarHeight = proportion * this.toValidHeight(yAxisHeight)) >= 0.0)) continue;
                value = (Double)this.getValues(element).get(i2);
                this.A(g2d, element, height, xAxisTextGap, w + (double)j2 * gap * 2.0, x - (double)j2 * gap, 0.0, h2, pillarHeight, value, i2);
            }
            x += w + ww;
        }
    }

    private void D(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, double pixelGap, double valueGap) {
        Double value;
        double pillarHeight;
        Double proportion;
        List list;
        Element element;
        int j2;
        int i2;
        int eCount = this.publishedElements.size();
        int cCount = this.xScaleTextList.size();
        double w = (double)xAxisWidth / (double)(eCount * cCount + cCount + 1);
        int h2 = (int)(this.min / valueGap * pixelGap);
        double x = this.xGap + yAxisTextGap;
        for (i2 = 0; i2 < cCount; ++i2) {
            x += w;
            for (j2 = 0; j2 < eCount; ++j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list != null && list.size() > i2 && (proportion = (Double)list.get(i2)) != null && (pillarHeight = proportion * this.toValidHeight(yAxisHeight)) < 0.0) {
                    value = (Double)this.getValues(element).get(i2);
                    this.A(g2d, element, height, xAxisTextGap, w, x, 0.0, h2, pillarHeight, value, i2);
                }
                x += w;
            }
        }
        if (this.xAxisVisible) {
            this.paintXAxis(g2d, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        x = this.xGap + yAxisTextGap;
        for (i2 = 0; i2 < cCount; ++i2) {
            this.A(g2d, i2, (x += w) + w * (double)eCount / 2.0, height - this.yGap - xAxisTextGap + this.textGap);
            for (j2 = 0; j2 < eCount; ++j2) {
                element = (Element)this.publishedElements.get(j2);
                list = (List)this.proportions.get(element);
                if (list != null && list.size() > i2 && (proportion = (Double)list.get(i2)) != null && (pillarHeight = proportion * this.toValidHeight(yAxisHeight)) >= 0.0) {
                    value = (Double)this.getValues(element).get(i2);
                    this.A(g2d, element, height, xAxisTextGap, w, x, 0.0, h2, pillarHeight, value, i2);
                }
                x += w;
            }
        }
    }

    private void B(Graphics2D g2d, int width, int height, int yAxisTextGap, int xAxisTextGap, int xAxisWidth, int yAxisHeight, double pixelGap, double valueGap) {
        double pillarHeight;
        Double proportion;
        Element element;
        int i2;
        double pillarWidth;
        int count = this.publishedElements.size();
        int groupCount = count / this.\u0460;
        if (count % this.\u0460 != 0) {
            ++groupCount;
        }
        if ((pillarWidth = (double)xAxisWidth / (((double)this.\u0460 + 1.0) * (double)groupCount + 1.0)) == 0.0) {
            pillarWidth = 0.1;
        }
        int h2 = (int)(this.min / valueGap * pixelGap);
        double x = (double)(this.xGap + yAxisTextGap) + pillarWidth;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfRange.get(i2);
            pillarHeight = proportion * this.toValidHeight(yAxisHeight);
            if (pillarHeight < 0.0) {
                this.A(g2d, element, height, xAxisTextGap, pillarWidth, x, 0.0, h2, pillarHeight, this.getValue(element), -1);
            }
            if ((i2 + 1) % this.\u0460 != 0) {
                x += pillarWidth;
                continue;
            }
            x += pillarWidth * 2.0;
        }
        if (this.xAxisVisible) {
            this.paintXAxis(g2d, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        x = (double)(this.xGap + yAxisTextGap) + pillarWidth;
        for (i2 = 0; i2 < count; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            proportion = (Double)this.proportionsOfRange.get(i2);
            pillarHeight = proportion * this.toValidHeight(yAxisHeight);
            if (pillarHeight >= 0.0) {
                this.A(g2d, element, height, xAxisTextGap, pillarWidth, x, 0.0, h2, pillarHeight, this.getValue(element), -1);
            }
            if ((i2 + 1) % this.\u0460 != 0) {
                x += pillarWidth;
                continue;
            }
            x += pillarWidth * 2.0;
        }
    }

    private void A(Graphics2D g2d, Element element, double height, int yTextGap, double pillarWidth, double x, double yOffset, int h2, double pillarHeight, double value, int index) {
        boolean drawSelected = element.isSelected();
        if (element.isSelected() && this.getPaintSelectionStateFilter() != null) {
            drawSelected = this.getPaintSelectionStateFilter().isPaintable(element);
        }
        int offset = drawSelected ? this.selectedOffset : 0;
        Rectangle2D.Double rect = pillarHeight < 0.0 ? new Rectangle2D.Double(x - (double)offset, yOffset + height - (double)this.yGap - (double)yTextGap + (double)h2 + (double)offset, pillarWidth, -pillarHeight) : new Rectangle2D.Double(x - (double)offset, yOffset + height - (double)this.yGap - (double)yTextGap - pillarHeight + (double)h2 + (double)offset, pillarWidth, pillarHeight);
        Pillar p2 = new Pillar(rect, this.shadowOffset, this.shadowOffset, this.getColor(element));
        Rectangle2D frontRect = p2.getRectangle();
        Color color = p2.getColor();
        if (this.gradient) {
            GradientPaint gp = new GradientPaint((float)frontRect.getX(), 0.0f, color, (float)frontRect.getX() + (float)(frontRect.getWidth() / 2.0), 0.0f, this.getGradientColor(element), true);
            g2d.setPaint(gp);
        } else {
            g2d.setColor(color);
        }
        g2d.fill(frontRect);
        if (this.shadowOffset > 0) {
            g2d.setColor(p2.getTopColor());
            g2d.fill(p2.getTop());
            g2d.setColor(p2.getRightColor());
            g2d.fill(p2.getRight());
        }
        if (drawSelected) {
            g2d.setStroke(this.getSelectedStroke(element));
            g2d.setColor(this.getSelectedColor(element));
            g2d.draw(frontRect);
            if (this.shadowOffset > 0) {
                g2d.draw(p2.getTop());
                g2d.draw(p2.getRight());
            }
        }
        if (this.valueTextVisible) {
            String valueText = "";
            if (this.\u0462 == 5) {
                double percent = (Double)((List)this.proportions.get(element)).get(index);
                valueText = this.getPercentFormatedText(element, value, index, percent);
            } else {
                valueText = this.getFormatedText(element, value, index);
            }
            this.\u0463.add(this.B(element, frontRect, valueText, pillarHeight));
        }
        String text = index < 0 ? this.getToolTipText(element) : this.getToolTipText(element, value, index);
        this.shapeStructs.add(0, new C(p2.getAllShape(), element, text, index));
    }

    private LabelStruct B(Element element, Rectangle2D frontRect, String valueText, double pillarHeight) {
        Dimension labelSize = this.B(valueText, this.valueTextFont);
        Point point = this.B(frontRect, element, labelSize, pillarHeight);
        LabelStruct labelStruct = new LabelStruct(1, valueText, this.valueTextColor, this.valueTextFont, point.x, point.y, this.B(element, pillarHeight));
        return labelStruct;
    }

    private Point B(Rectangle2D frontRect, Element element, Dimension labelSize, double pillarHeight) {
        Point point = new Point();
        int cx = (int)(frontRect.getCenterX() + (double)this.shadowOffset / 2.0);
        int cy = (int)(frontRect.getCenterY() - (double)this.shadowOffset / 2.0);
        int position = this.B(element, pillarHeight);
        if (position == 1) {
            point.x = cx;
            point.y = cy;
        } else if (position == 3 || position == 8 || position == 9) {
            point.x = cx;
            point.y = (int)(frontRect.getY() + frontRect.getHeight());
        } else if (position == 5) {
            point.x = (int)(frontRect.getX() + frontRect.getWidth());
            point.y = cy;
        } else if (position == 4) {
            point.x = (int)frontRect.getX();
            point.y = cy;
        } else if (position == 2 || position == 6 || position == 7) {
            point.x = cx;
            point.y = (int)frontRect.getY();
        }
        return point;
    }

    private int B(Element element, double pillarHeight) {
        Object value = element.getClientProperty("chart.value.text.position");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (this.valueTextCenter) {
            return 1;
        }
        if (pillarHeight >= 0.0) {
            return 2;
        }
        return 3;
    }

    protected String getPercentFormatedText(Element element, double value, int index, double percent) {
        NumberFormat format = this.getFormat(element);
        String ret = format.format(value);
        if (this.unit != null) {
            ret = ret + this.unit;
        }
        ret = this.\u0461 ? "<html><center>" + ret + "<br>(" + format.format(percent * 100.0) + "%)" + "</center></html>" : "<html>" + format.format(percent * 100.0) + "%" + "</html>";
        return ret;
    }

    public int getBarType() {
        return this.\u0462;
    }

    public void setBarType(int barType) {
        this.\u0462 = barType;
        if (this.\u0462 == 3) {
            this.valueTextCenter = true;
        }
        this.publishData(false);
    }

    public int getBundleSize() {
        return this.\u0460;
    }

    public void setBundleSize(int bundleSize) {
        int old = this.\u0460;
        if (bundleSize < 1) {
            bundleSize = 1;
        }
        this.\u0460 = bundleSize;
        if (this.\u0460 != old) {
            this.chartPane.repaint();
        }
    }

    public boolean isPercentTypeValueVisible() {
        return this.\u0461;
    }

    public void setPercentTypeValueVisible(boolean percentTypeValueVisible) {
        this.\u0461 = percentTypeValueVisible;
        this.chartPane.repaint();
    }

    public PaintSelectionStateFilter getPaintSelectionStateFilter() {
        return this.\u045f;
    }

    public void setPaintSelectionStateFilter(PaintSelectionStateFilter paintSelectionStateFilter) {
        this.\u045f = paintSelectionStateFilter;
        this.repaint();
    }

    public void setChartSVGAttribute(AbstractSVGChart abschart) {
        super.setChartSVGAttribute(abschart);
        SVGBarChart chart = (SVGBarChart)abschart;
        chart.setBundleSize(this.getBundleSize());
        chart.setPercentTypeValueVisible(this.isPercentTypeValueVisible());
        chart.setBarType(this.getBarType());
    }

    public void exportSVG(String fileName, int width, int height) {
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith(".svg")) {
            fileName = fileName + ".svg";
        }
        SVGBarChart chart = new SVGBarChart();
        this.setChartSVGAttribute(chart);
        SVGContext context = new SVGContext();
        a.A(fileName, chart.toSVG(context, width, height));
    }
}

