/*
 * Decompiled with CFR 0.152.
 */
package twaver.animate;

import twaver.TWaverUtil;
import twaver.TaskAdapter;
import twaver.TaskScheduler;
import twaver.animate.Animate;

public class AnimateManager {
    private Animate C = null;
    private TaskScheduler D = null;
    private static AnimateManager A = null;
    private boolean B = false;

    private AnimateManager() {
    }

    public TaskScheduler getTaskScheduler() {
        return this.D;
    }

    public Animate getCurrentAnimate() {
        return this.C;
    }

    public static synchronized AnimateManager getInstance() {
        if (A == null || !AnimateManager.A.D.isRunning()) {
            A = new AnimateManager();
            AnimateManager.A.D = TaskScheduler.createTaskScheduler(TWaverUtil.getAnimateSleep());
            AnimateManager.A.D.start("Animate Scheduler Thread");
        }
        return A;
    }

    public void addAnimate(final Animate animate) {
        if (this.B) {
            animate.currentStepIndex = animate.stepSize;
            animate.step(animate.currentStepIndex);
            if (animate.runnable != null) {
                animate.runnable.run();
                animate.runnable = null;
            }
            return;
        }
        if (this.C != null) {
            this.B = true;
            Animate t = this.C;
            this.C = null;
            t.currentStepIndex = t.stepSize;
            t.step(t.currentStepIndex);
            if (t.runnable != null) {
                t.runnable.run();
                t.runnable = null;
            }
            this.B = false;
        }
        this.C = animate;
        animate.currentStepIndex = 0;
        TaskAdapter task = new TaskAdapter(){

            public int getInterval() {
                double t = (double)animate.currentStepIndex / (double)animate.stepSize;
                if (t < 0.2 || t > 0.8) {
                    return animate.getSleep() * 2;
                }
                return animate.getSleep();
            }

            public void run(long clock) {
                if (animate.currentStepIndex < animate.stepSize) {
                    ++animate.currentStepIndex;
                    animate.step(animate.currentStepIndex);
                } else {
                    if (animate.runnable != null) {
                        animate.runnable.run();
                        animate.runnable = null;
                    }
                    AnimateManager.this.D.unregister(this);
                    if (AnimateManager.this.C == animate) {
                        AnimateManager.this.C = null;
                    }
                }
            }
        };
        this.D.register(task);
    }
}

