/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.element;

import com.nepxion.cots.twaver.element.TElement;
import com.nepxion.cots.twaver.element.TGroup;
import com.nepxion.cots.twaver.element.TLink;
import com.nepxion.cots.twaver.element.TNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.DataBoxSelectionModel;
import twaver.Element;
import twaver.TDataBox;

public class TElementManager {
    public static TNode getNode(TDataBox dataBox, String name) {
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TNode) || !element.getName().equals(name)) continue;
            return (TNode)element;
        }
        return null;
    }

    public static List getNodes(TDataBox dataBox) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TNode)) continue;
            nodes.add(element);
        }
        return nodes;
    }

    public static List getNodes(TGroup group) {
        ArrayList nodes = new ArrayList();
        Iterator iterator = group.children();
        while (iterator.hasNext()) {
            nodes.add(iterator.next());
        }
        return nodes;
    }

    public static TGroup getGroup(TDataBox dataBox, String name) {
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TGroup) || !element.getName().equals(name)) continue;
            return (TGroup)element;
        }
        return null;
    }

    public static List getGroups(TDataBox dataBox) {
        ArrayList<Element> groups = new ArrayList<Element>();
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TGroup)) continue;
            groups.add(element);
        }
        return groups;
    }

    public static TLink getLink(TDataBox dataBox, String name) {
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TLink) || !element.getName().equals(name)) continue;
            return (TLink)element;
        }
        return null;
    }

    public static List getLinks(TDataBox dataBox) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        for (Element element : dataBox.getAllElements()) {
            if (!(element instanceof TLink)) continue;
            nodes.add(element);
        }
        return nodes;
    }

    public static TElement getSelectedElement(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().size() != 1 || !(selectionModel.lastElement() instanceof TElement)) {
            return null;
        }
        return (TElement)selectionModel.lastElement();
    }

    public static List getSelectedNodes(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().isEmpty()) {
            return null;
        }
        ArrayList selectedNodes = new ArrayList();
        for (Object object : selectionModel.getAllSelectedElement()) {
            if (!(object instanceof TNode)) continue;
            selectedNodes.add(object);
        }
        return selectedNodes;
    }

    public static TNode getSelectedNode(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().size() != 1 || !(selectionModel.lastElement() instanceof TNode)) {
            return null;
        }
        return (TNode)selectionModel.lastElement();
    }

    public static List getSelectedGroups(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().isEmpty()) {
            return null;
        }
        ArrayList selectedGroups = new ArrayList();
        for (Object object : selectionModel.getAllSelectedElement()) {
            if (!(object instanceof TGroup)) continue;
            selectedGroups.add(object);
        }
        return selectedGroups;
    }

    public static TGroup getSelectedGroup(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().size() != 1 || !(selectionModel.lastElement() instanceof TGroup)) {
            return null;
        }
        return (TGroup)selectionModel.lastElement();
    }

    public static List getSelectedLinks(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().isEmpty()) {
            return null;
        }
        ArrayList selectedLinks = new ArrayList();
        for (Object object : selectionModel.getAllSelectedElement()) {
            if (!(object instanceof TNode)) continue;
            selectedLinks.add(object);
        }
        return selectedLinks;
    }

    public static TLink getSelectedLink(TDataBox dataBox) {
        DataBoxSelectionModel selectionModel = dataBox.getSelectionModel();
        if (selectionModel == null || selectionModel.getAllSelectedElement().size() != 1 || !(selectionModel.lastElement() instanceof TLink)) {
            return null;
        }
        return (TLink)selectionModel.lastElement();
    }

    public static void addGroupChildren(TDataBox dataBox, TGroup group) {
        Iterator iterator = group.children();
        while (iterator.hasNext()) {
            dataBox.addElement((Element)((TNode)iterator.next()));
        }
    }

    public static void removeGroupChildren(TDataBox dataBox, TGroup group) {
        ArrayList children = new ArrayList();
        Iterator iterator = group.children();
        while (iterator.hasNext()) {
            children.add(iterator.next());
        }
        iterator = children.iterator();
        while (iterator.hasNext()) {
            dataBox.removeElement((Element)((TNode)iterator.next()));
        }
        group.clearChildren();
    }
}

