/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.wizard;

import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.container.ContainerManager;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.wizard.JStep;
import com.nepxion.swing.wizard.WizardModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class JWizard
extends JPanel {
    private WizardModel wizardModel;
    private ImageModule imageModule;
    private ContentModule contentModule;
    private ToolBar toolBar;
    private JPanel panel;
    private int currentStepIndex = 0;

    public JWizard(WizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.imageModule = new ImageModule();
        this.contentModule = new ContentModule();
        this.toolBar = new ToolBar();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.imageModule, "West");
        this.panel.add((Component)this.contentModule, "Center");
        double[][] size = new double[][]{{-1.0}, {-1.0, 10.0, 30.0}};
        this.setLayout(new TableLayout(size));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.panel, "0, 0");
        this.add((Component)new JSeparator(), "0, 1");
        this.add((Component)this.toolBar, "0, 2");
    }

    public void setCurrentStep(int currentStepIndex) {
        if (currentStepIndex < 0 || currentStepIndex >= this.wizardModel.getStepCount()) {
            throw new IllegalArgumentException("\u8d85\u51fa\u7d22\u5f15\u8303\u56f4");
        }
        this.currentStepIndex = currentStepIndex;
        JStep step = this.wizardModel.getStepAt(currentStepIndex);
        Window window = HandleManager.getWindow(this);
        if (step.getTitle() != null) {
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(step.getTitle());
            } else if (window instanceof JDialog) {
                ((JDialog)window).setTitle(step.getTitle());
            }
        }
        if (step.getImage() != null) {
            if (this.imageModule.getParent() != this.panel) {
                this.panel.add((Component)this.imageModule, "West");
            }
            this.imageModule.setImage(step.getImage());
        } else {
            this.panel.remove(this.imageModule);
        }
        if (step.getContentPane() != null) {
            if (this.contentModule.getParent() != this.panel) {
                this.panel.add((Component)this.contentModule, "Center");
            }
            this.contentModule.setContentPane(step.getContentPane());
        } else {
            this.panel.remove(this.contentModule);
        }
        this.toolBar.previousButton.setEnabled(currentStepIndex != 0);
        this.toolBar.nextButton.setEnabled(currentStepIndex != this.wizardModel.getStepCount() - 1);
    }

    public void confirm() {
        int stepCount = this.wizardModel.getStepCount();
        if (stepCount == 0) {
            return;
        }
        JStep currentStep = this.wizardModel.getStepAt(this.currentStepIndex);
        if (!currentStep.confirm()) {
            return;
        }
    }

    public void cancel() {
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getWindow(this), "\u786e\u8ba4\u8981\u53d6\u6d88\uff1f", SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        int stepCount = this.wizardModel.getStepCount();
        if (stepCount == 0) {
            return;
        }
        JStep currentStep = this.wizardModel.getStepAt(this.currentStepIndex);
        if (!currentStep.cancel()) {
            return;
        }
        HandleManager.getWindow(this).setVisible(false);
    }

    public void next() {
        int stepCount = this.wizardModel.getStepCount();
        if (stepCount == 0) {
            return;
        }
        JStep currentStep = this.wizardModel.getStepAt(this.currentStepIndex);
        if (!currentStep.next()) {
            return;
        }
        int nextStepIndex = this.currentStepIndex + 1;
        if (nextStepIndex >= stepCount) {
            this.toolBar.nextButton.setEnabled(false);
        }
        this.toolBar.previousButton.setEnabled(true);
        this.setCurrentStep(nextStepIndex);
        HandleManager.getWindow(this).pack();
    }

    public void previous() {
        int stepCount = this.wizardModel.getStepCount();
        if (stepCount == 0) {
            return;
        }
        JStep currentStep = this.wizardModel.getStepAt(this.currentStepIndex);
        if (!currentStep.previous()) {
            return;
        }
        int previousStepIndex = this.currentStepIndex - 1;
        if (previousStepIndex < 0) {
            this.toolBar.previousButton.setEnabled(false);
        }
        this.toolBar.nextButton.setEnabled(true);
        this.setCurrentStep(previousStepIndex);
        HandleManager.getWindow(this).pack();
    }

    public WizardModel getWizardModel() {
        return this.wizardModel;
    }

    public ImageModule getImageModule() {
        return this.imageModule;
    }

    public ContentModule getContentModule() {
        return this.contentModule;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public static JWizard getWizard(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JWizard) {
            return (JWizard)component;
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JWizard)) continue;
            return (JWizard)parent;
        }
        return null;
    }

    public class ToolBar
    extends JPanel {
        public JClassicButton cancelButton;
        public JClassicButton previousButton;
        public JClassicButton nextButton;
        public JClassicButton confirmButton;

        public ToolBar() {
            this.add(Box.createHorizontalGlue());
            this.cancelButton = new JClassicButton("\u64a4\u9500", IconFactory.getSwingIcon("stereo/cancel_16.png"), "\u64a4\u9500");
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JWizard.this.cancel();
                }
            };
            this.cancelButton.addActionListener(cancelActionListener);
            KeyStrokeManager.registerButtonToEscapeKey(this.cancelButton, cancelActionListener);
            this.add(this.cancelButton);
            this.add(Box.createHorizontalStrut(10));
            this.previousButton = new JClassicButton("\u4e0a\u4e00\u6b65", IconFactory.getSwingIcon("stereo/arrow_backward_16.png"), "\u4e0a\u4e00\u6b65");
            this.previousButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JWizard.this.previous();
                }
            });
            this.add(this.previousButton);
            this.add(Box.createHorizontalStrut(5));
            this.nextButton = new JClassicButton("\u4e0b\u4e00\u6b65", IconFactory.getSwingIcon("stereo/arrow_forward_16.png"), "\u4e0b\u4e00\u6b65");
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JWizard.this.next();
                }
            });
            this.add(this.nextButton);
            this.add(Box.createHorizontalStrut(10));
            this.confirmButton = new JClassicButton("\u5b8c\u6210", IconFactory.getSwingIcon("stereo/confirm_16.png"), "\u5b8c\u6210");
            ActionListener confirmActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JWizard.this.confirm();
                }
            };
            this.confirmButton.addActionListener(confirmActionListener);
            KeyStrokeManager.registerButtonToEnterKey(this.confirmButton, confirmActionListener);
            this.add(this.confirmButton);
            this.add(Box.createHorizontalStrut(10));
            this.setLayout(new BoxLayout(this, 0));
        }
    }

    public class ContentModule
    extends JPanel {
        public ContentModule() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        public void setContentPane(Component contentPane) {
            this.removeAll();
            this.add(contentPane, "Center");
            ContainerManager.update(this);
        }
    }

    public class ImageModule
    extends JPanel {
        public JLabel imageLabel = new JLabel();

        public ImageModule() {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setBackground(Color.white);
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createLineBorder(Color.gray)));
            panel.add((Component)this.imageLabel, "Center");
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            this.add((Component)panel, "North");
            this.add(Box.createHorizontalGlue(), "Center");
        }

        public void setImage(Icon image) {
            this.imageLabel.setIcon(image);
        }
    }
}

